/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.BeyondInSizeException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.JpaServiceException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.hibernate.jpa.HibernateEntityManager;
import org.springframework.beans.BeanWrapperImpl;

public final class BlockJpaUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockJpaUtil.class);
    private static final int BATCH_SIZE = 100;
    public static final int MAX_IN_SIZE = 1000;
    private static final int TOTAL_MAX_IN_SIZE = 20000;

    public static EntityManager getEntityManager() {
        return (EntityManager)OSGiUtil.getSpringBean(EntityManager.class);
    }

    private BlockJpaUtil() {
    }

    public static <T> void evict(T entity) {
        if (Objects.isNull(entity)) {
            return;
        }
        HibernateEntityManager entityManager = (HibernateEntityManager)BlockJpaUtil.getEntityManager();
        entityManager.getSession().evict(entity);
    }

    public static <T> void evict(List<T> list) {
        if (BlockCollectionUtil.isEmpty(list)) {
            return;
        }
        list.forEach(it -> BlockJpaUtil.evict(it));
    }

    public static <T> void insertThenCommit(T entity) {
        if (null == entity) {
            return;
        }
        EntityTransaction transaction = null;
        try (EntityManager entityManager = null;){
            entityManager = BlockJpaUtil.getEntityManager();
            transaction = entityManager.getTransaction();
            transaction.begin();
            entityManager.persist(entity);
            transaction.commit();
        }
    }

    public static <T> void batchInsert(List<T> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        EntityTransaction transaction = null;
        try (EntityManager entityManager = null;){
            entityManager = BlockJpaUtil.getEntityManager();
            transaction = entityManager.getTransaction();
            transaction.begin();
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0 && i % 100 == 0) {
                    entityManager.flush();
                    entityManager.clear();
                    transaction.commit();
                    transaction.begin();
                }
                entityManager.persist(list.get(i));
            }
            transaction.commit();
        }
    }

    public static <P, T> List<T> findAllByIds(Function<List<P>, List<T>> func, List<P> ids) {
        if (null == func) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findAllByIds_188", (String)"\u53c2\u6570\u9519\u8bef\uff1afunc\u4e3a\u7a7a\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(ids)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findAllByIds_191", (String)"\u53c2\u6570\u9519\u8bef\uff1aids\u4e3a\u7a7a\u3002"));
        }
        if (ids.size() > 20000) {
            throw new BeyondInSizeException("ABC.0008", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findAllByIds_194", (String)"\u9519\u8bef\uff1a\u8d85\u8fc7IN\u64cd\u4f5c\u5143\u7d20\u4e2a\u6570\u4e0a\u7ebf\u3002"));
        }
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u5206\u6279\u6b21IN\u67e5\u8be2\u8bb0\u5f55\u6761\u6570\uff1a%s", ids.size());
            LOG.info((Object)msg);
        }
        MonitorUtil monitor = MonitorUtil.getInstance(LOG);
        long start = monitor.getStartTime();
        if (ids.size() <= 1000) {
            return func.apply(ids);
        }
        ArrayList dataList = new ArrayList();
        ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
        try {
            int i;
            for (i = 0; i < ids.size(); i += 1000) {
                int length = Math.min(ids.size(), i + 1000);
                List subIds = ids.subList(i, length);
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> (List)func.apply(subIds), CommonUtil.getThreadPoolExecutor());
                futureList.add(future);
            }
            for (i = 0; i < futureList.size(); ++i) {
                Future future = (Future)futureList.get(i);
                dataList.addAll((Collection)future.get(10L, TimeUnit.SECONDS));
            }
        }
        catch (Exception e) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"BlockJpaUtil_findAllByIds_229", (String)"\u6279\u91cfin\u67e5\u8be2\u5931\u8d25\uff1a%s"), e.getMessage());
            throw new JpaServiceException("ABC.0037", msg, e, new Object[0]);
        }
        monitor.monitor("\u5206\u6279\u6b21IN\u67e5\u8be2\u8017\u65f6", start);
        return dataList;
    }

    public static <T> List<T> findPartOfFieldsByIds(List<String> fields, Class<T> clazz, List<String> ids) {
        if (BlockCollectionUtil.isEmpty(fields)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findPartOfFieldsByIds_246", (String)"\u53c2\u6570\u9519\u8bef\uff1afields\u4e3a\u7a7a\u3002"));
        }
        if (null == clazz) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findPartOfFieldsByIds_249", (String)"\u53c2\u6570\u9519\u8bef\uff1aclazz\u4e3a\u7a7a\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(ids)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findPartOfFieldsByIds_252", (String)"\u53c2\u6570\u9519\u8bef\uff1aids\u4e3a\u7a7a\u3002"));
        }
        ArrayList resultList = new ArrayList();
        StringBuilder builder = new StringBuilder();
        builder.append("select ").append(fields.stream().collect(Collectors.joining(", "))).append(" from ").append(clazz.getCanonicalName()).append(" where gid in (:ids)");
        List objArrs = null;
        try (EntityManager em = null;){
            em = BlockJpaUtil.getEntityManager();
            objArrs = em.createQuery(builder.toString()).setParameter("ids", ids).getResultList();
        }
        if (!BlockCollectionUtil.isEmpty(objArrs)) {
            objArrs.forEach(objArr -> {
                try {
                    Object t = clazz.newInstance();
                    BeanWrapperImpl bw = new BeanWrapperImpl(t);
                    Object[] arr = null;
                    arr = fields.size() > 1 ? (Object[])objArr : new Object[]{objArr};
                    for (int i = 0; i < fields.size(); ++i) {
                        if (!((String)fields.get(i)).contains(".")) {
                            bw.setPropertyValue((String)fields.get(i), arr[i]);
                            continue;
                        }
                        String[] fNames = ((String)fields.get(i)).split("\\.");
                        String fParent = fNames[0];
                        String fSon = fNames[1];
                        Class clsP = bw.getPropertyType(fParent);
                        Object objP = clsP.newInstance();
                        BeanWrapperImpl bwSub = new BeanWrapperImpl(objP);
                        bwSub.setPropertyValue(fSon, arr[i]);
                        bw.setPropertyValue(fParent, objP);
                    }
                    resultList.add(t);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("\u62fc\u88c5\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                    }
                    throw new EcpRuntimeException("", EcpI18nUtil.localizedString((String)"BlockJpaUtil_findPartOfFieldsByIds_313", (String)"\u62fc\u88c5\u5bf9\u8c61\u5931\u8d25\uff1a") + e.getMessage(), (Throwable)e, new Object[0]);
                }
            });
        }
        return resultList;
    }

    public static void main(String[] args) {
        List<String> ids = Arrays.asList("a", "b", "c", "d", "e", "f", "a1", "b1", "c1", "d1", "e1", "f1");
        Operator optr = new Operator();
        List result = BlockJpaUtil.findAllByIds(optr::findByIds, ids);
        System.out.println("result=" + result);
    }

    static class Operator {
        Operator() {
        }

        public List<String> findByIds(List<String> ids) {
            try {
                Thread.sleep(11000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return ids.stream().map(str -> "0" + str).collect(Collectors.toList());
        }
    }
}

