/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.ygsoft.abc.service.domain.vo.SignatureDetailVO;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Base64Utils;

public final class BlockPDFUtil {
    private BlockPDFUtil() {
    }

    public static List<SignatureDetailVO> readSignature(byte[] pdfData) {
        ArrayList<SignatureDetailVO> result = new ArrayList<SignatureDetailVO>();
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PdfReader reader = new PdfReader(pdfData);
            AcroFields af = reader.getAcroFields();
            ArrayList names = af.getSignatureNames();
            for (String name : names) {
                PdfDictionary v = af.getSignatureDictionary(name);
                af.signatureCoversWholeDocument(name);
                PdfName sub = v.getAsName(PdfName.SUBFILTER);
                PdfPKCS7 p7 = af.verifySignature(name);
                Certificate[] pkc = p7.getSignCertificateChain();
                X509Certificate signCert = p7.getSigningCertificate();
                System.out.println("-------------------------------------------");
                System.out.println("SignDate:" + BlockDateUtil.formatDate(p7.getSignDate().getTime(), "yyyy-MM-dd HH:mm:ss"));
                System.out.println("Result:" + p7.verify());
                System.out.println("SigAlgName:" + signCert.getSigAlgName());
                System.out.println("SigAlgOID:" + signCert.getSigAlgOID());
                System.out.println("Type:" + signCert.getType());
                System.out.println("Version:" + signCert.getVersion());
                System.out.println("SerialNumber:" + signCert.getSerialNumber());
                System.out.println("IssuerDN-Name:" + signCert.getIssuerDN().getName());
                System.out.println("IssuerX500Principal:" + signCert.getIssuerX500Principal().getName());
                System.out.println("PublicKey:" + signCert.getPublicKey().getAlgorithm());
                System.out.println("ExtendKeyUsage:" + signCert.getExtendedKeyUsage());
                System.out.println("SubjectDN-Name:" + signCert.getSubjectDN().getName());
                System.out.println("SubjectX500Principal:" + signCert.getSubjectX500Principal().getName());
                System.out.println("SigAlgParams:" + Base64Utils.encodeToString((byte[])signCert.getSigAlgParams()));
                System.out.println("Signature:" + Base64Utils.encodeToString((byte[])signCert.getSignature()));
                System.out.println("NotBefore:" + BlockDateUtil.formatFull(signCert.getNotBefore()));
                System.out.println("NotAfter:" + BlockDateUtil.formatFull(signCert.getNotAfter()));
                result.add(SignatureDetailVO.newFrom(p7));
            }
            return result;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }
}

