/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.entity.DynamicEntity;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public final class BlockSqlUtil {
    static final IEcpLog LOG = EcpLogFactory.getLog(BlockSqlUtil.class);
    public static final int QUERY_TYPE_EQ = 0;
    public static final int QUERY_TYPE_NE = 1;
    public static final int QUERY_TYPE_LIKE = 2;
    public static final int QUERY_TYPE_LEFTLIKE = 3;
    public static final int QUERY_TYPE_RIGHTLIKE = 4;
    public static final int QUERY_TYPE_IN = 5;
    public static final int ALL_LIKE = 1;
    public static final int LEFT_LIKE = 2;
    public static final int RIGHT_LIKE = 3;
    public static final char ESCAPE_CHAR = '\\';
    private static final String DEFAULT_SPLITER = ",";
    private static final Pattern SQL_FIXED_PATTERN = Pattern.compile("\\{:(\\S+?)\\}");

    private BlockSqlUtil() {
    }

    public static ISQLTemplate getSqlTemplate() {
        return (ISQLTemplate)OSGiUtil.getService(ISQLTemplate.class);
    }

    public static String buildLikeValue(String value, int type) {
        if (StringUtil.isEmpty((String)value)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeValue_75", (String)"\u53c2\u6570value\u4e3a\u7a7a\u3002"));
        }
        String paramValue = null;
        switch (type) {
            case 1: {
                paramValue = "%" + BlockSqlUtil.escapeLikeValue(value) + "%";
                break;
            }
            case 2: {
                paramValue = BlockSqlUtil.escapeLikeValue(value) + "%";
                break;
            }
            case 3: {
                paramValue = "%" + BlockSqlUtil.escapeLikeValue(value);
                break;
            }
            default: {
                throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeValue_90", (String)"\u53c2\u6570type\u9519\u8bef\u3002"));
            }
        }
        return paramValue;
    }

    public static String buildLikeValue(String value) {
        return BlockSqlUtil.buildLikeValue(value, 1);
    }

    public static String buildOrLikeSql(String field, String key, String value, Map<String, Object> param) {
        return BlockSqlUtil.buildOrLikeSql(field, key, value, param, 1);
    }

    public static String buildOrLikeSql(String field, String key, String value, Map<String, Object> param, int likeType) {
        if (StringUtil.isNullOrTrimEmptyString((String)field)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOrLikeSql_142", (String)"\u53c2\u6570\u9519\u8bef\uff1afield\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)key)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOrLikeSql_145", (String)"\u53c2\u6570\u9519\u8bef\uff1akey\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOrLikeSql_148", (String)"\u53c2\u6570\u9519\u8bef\uff1avalue\u4e3a\u7a7a\u3002"));
        }
        if (null == param) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOrLikeSql_151", (String)"\u53c2\u6570\u9519\u8bef\uff1aparam\u4e3a\u7a7a\u3002"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" OR " + field + " LIKE " + BlockSqlUtil.buildParamKey(key) + " ");
        param.put(key, BlockSqlUtil.buildLikeValue(value, likeType));
        return sb.toString();
    }

    public static String buildLikeSql(String field, String key, String value, Map<String, Object> param) {
        return BlockSqlUtil.buildLikeSql(field, key, value, param, 1);
    }

    public static String buildLikeSql(String field, String key, String value, Map<String, Object> param, int likeType) {
        if (StringUtil.isNullOrTrimEmptyString((String)field)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeSql_198", (String)"\u53c2\u6570\u9519\u8bef\uff1afield\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)key)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeSql_201", (String)"\u53c2\u6570\u9519\u8bef\uff1akey\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isEmpty((String)value)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeSql_204", (String)"\u53c2\u6570\u9519\u8bef\uff1avalue\u4e3a\u7a7a\u3002"));
        }
        if (null == param) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildLikeSql_207", (String)"\u53c2\u6570\u9519\u8bef\uff1aparam\u4e3a\u7a7a\u3002"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND " + field + " LIKE " + BlockSqlUtil.buildParamKey(key) + " ");
        param.put(key, BlockSqlUtil.buildLikeValue(value, likeType));
        return sb.toString();
    }

    public static String buildArrayLikeSql(String field, String key, List<String> values, Map<String, Object> param, int likeType) {
        List<String> list = null;
        if (StringUtil.isNullOrTrimEmptyString((String)field)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildArrayLikeSql_239", (String)"\u53c2\u6570\u9519\u8bef\uff1afield\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)key)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildArrayLikeSql_242", (String)"\u53c2\u6570\u9519\u8bef\uff1akey\u4e3a\u7a7a\u3002"));
        }
        if (null == values || values.isEmpty()) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildArrayLikeSql_245", (String)"\u53c2\u6570\u9519\u8bef\uff1avalues\u4e3a\u7a7a\u3002"));
        }
        if (null == param) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildArrayLikeSql_248", (String)"\u53c2\u6570\u9519\u8bef\uff1aparam\u4e3a\u7a7a\u3002"));
        }
        list = BlockCollectionUtil.filterBlank(values);
        if (list == null || list.isEmpty()) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildArrayLikeSql_252", (String)"\u53c2\u6570\u9519\u8bef\uff1a\u8fc7\u6ee4\u6389\u7a7a\u5b57\u7b26\u4e32\u540elist\u4e3a\u7a7a\u3002"));
        }
        if (list.size() == 1) {
            return BlockSqlUtil.buildLikeSql(field, key, values.get(0), param, likeType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND ( ");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(field + " LIKE " + BlockSqlUtil.buildParamKey(key, i) + " ");
            if (i != list.size() - 1) {
                sb.append(" OR ");
            }
            param.put(key + i, BlockSqlUtil.buildLikeValue(list.get(i), likeType));
        }
        sb.append(" ) ");
        return sb.toString();
    }

    public static String buildArrayLikeSql(String field, String key, List<String> values, Map<String, Object> param) {
        return BlockSqlUtil.buildArrayLikeSql(field, key, values, param, 1);
    }

    private static String buildParamKey(String key) {
        return ":" + key;
    }

    private static String buildParamKey(String key, int index) {
        return key + index;
    }

    public static String escapeLikeValue(String likeValue) {
        if (StringUtil.isEmpty((String)likeValue)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockSqlUtil_escapeLikeValue_313", (String)"\u53c2\u6570\u9519\u8bef\uff1alikeValue\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < likeValue.length(); ++i) {
            char ch = likeValue.charAt(i);
            sb.append(BlockSqlUtil.transferLikeChar(ch));
        }
        return sb.toString();
    }

    private static String transferLikeChar(char c) {
        switch (c) {
            case '\'': {
                return "''";
            }
            case '%': {
                return "\\%";
            }
            case '_': {
                return "\\_";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    public static String escapeSql(String sql) {
        if (StringUtil.isNullOrTrimEmptyString((String)sql)) {
            return null;
        }
        return StringEscapeUtils.escapeSql((String)sql);
    }

    public static String buildInValue(Collection<?> c) {
        if (c == null || c.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object entity : c) {
            if (entity == null) continue;
            if (entity.getClass() == String.class) {
                if (StringUtil.isEmptyString((String)entity.toString())) continue;
                sb.append("'").append(BlockSqlUtil.escapeSql(entity.toString())).append("'");
            } else {
                sb.append(entity);
            }
            sb.append(DEFAULT_SPLITER);
        }
        if (StringUtil.isEmptyString((String)sb.toString())) {
            return null;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String buildInValue(String str) {
        return BlockSqlUtil.buildInValue(str, DEFAULT_SPLITER);
    }

    public static String buildInValue(String str, String spliter) {
        if (StringUtil.isNullOrTrimEmptyString((String)spliter)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildInValue_419", (String)"\u5206\u5272\u5b57\u7b26\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        String[] arr = str.split(spliter);
        return BlockSqlUtil.buildInValue(Arrays.asList(arr));
    }

    public static String replaceSqlFixed(String sql, Map<String, Object> fixedMap) {
        if (StringUtil.isNullOrTrimEmptyString((String)sql)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_replaceSqlFixed_454", (String)"\u53c2\u6570\u9519\u8bef\uff1asql\u4e3a\u7a7a\u3002"));
        }
        Matcher m = SQL_FIXED_PATTERN.matcher(sql);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int start = 0;
        int end = 0;
        while (m.find()) {
            start = m.start();
            end = m.end();
            if (start > index) {
                sb.append(sql.subSequence(index, start));
            }
            if (!fixedMap.containsKey(m.group(1))) {
                throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_replaceSqlFixed_470", (String)("SQL \u66ff\u6362\u56fa\u5b9a\u90e8\u5206\uff0c\u5176\u4e2dKEY:" + m.group(1) + "\uff0c\u5728fixedMap\u4e2d\u4e0d\u5b58\u5728\u3002"), (Object[])new Object[]{m.group(1)}));
            }
            sb.append(fixedMap.get(m.group(1)));
            index = end;
        }
        if (index < sql.length()) {
            sb.append(sql.substring(index));
        }
        return sb.toString();
    }

    public static String buildColumnInClauseSql(String tableAlias, String[] fields, Map<String, Object> param, List<DynamicEntity> list) {
        String alias = "";
        if (!StringUtil.isNullOrTrimEmptyString((String)tableAlias)) {
            alias = tableAlias.trim();
        }
        if (fields == null || fields.length == 0) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildColumnInClauseSql_502", (String)"\u53c2\u6570\u9519\u8bef\uff1afields\u4e3a\u7a7a\u3002"));
        }
        if (param == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildColumnInClauseSql_505", (String)"\u53c2\u6570\u9519\u8bef\uff1aparam\u4e3a\u7a7a\u3002"));
        }
        if (list == null || list.isEmpty()) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildColumnInClauseSql_508", (String)"\u53c2\u6570\u9519\u8bef\uff1alist\u4e3a\u7a7a\u3002"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND ( ");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(" OR ");
            }
            sb.append(BlockSqlUtil.buildOneColumns(alias, fields, i, param, list.get(i)));
        }
        sb.append(" ) ");
        return sb.toString();
    }

    private static String buildOneColumns(String alias, String[] fields, int index, Map<String, Object> param, DynamicEntity ent) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ( ");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (StringUtil.isNullOrTrimEmptyString((String)field)) {
                throw new EcpRuntimeException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOneColumns_543", (String)"\u53c2\u6570\u9519\u8bef\uff1afields\u4e2d\u5305\u542b\u7a7a\u5143\u7d20\u3002"));
            }
            Object value = ent.get(field);
            if (value == null) {
                throw new EcpRuntimeException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildOneColumns_547", (String)("\u53c2\u6570\u9519\u8bef\uff1alist.get(" + index + ").get(" + field + ")\u503c\u4e3anull\u3002"), (Object[])new Object[]{index, field}));
            }
            String fieldWithAlias = BlockSqlUtil.buildFiledWithAlias(alias, field);
            String paramKey = BlockSqlUtil.buildParamKey(field, index);
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(fieldWithAlias + "=:" + paramKey);
            param.put(paramKey, value);
        }
        sb.append(" ) ");
        return sb.toString();
    }

    private static String buildFiledWithAlias(String alias, String field) {
        if (StringUtil.isNullOrTrimEmptyString((String)alias)) {
            return field;
        }
        return alias + "." + field;
    }

    public static List<?> partitionFind(ISQLTemplate sqlTemplate, String sql, Map<String, Object> param, List<String> inValues, Class<?> objClass, String fieldKey, int step) {
        LinkedList resultList = new LinkedList();
        for (int i = 0; i < inValues.size(); i += step) {
            List<String> curList = inValues.subList(i * step, Math.min(inValues.size() - i * step, step));
            param.put(fieldKey, curList);
            List curResults = sqlTemplate.findBySQLWithoutRowNumLimit(sql, param, objClass);
            resultList.addAll(curResults);
        }
        return resultList;
    }

    public static String buildInClauseWithoutLimit(String field, String paramKey, Map<String, Object> params, List<?> list) {
        StringBuilder sb = new StringBuilder();
        int step = 900;
        if (list.size() <= step) {
            sb.append(BlockSqlUtil.buildInClauseWithLimit(field, paramKey, params, list));
        } else {
            sb.append(" (");
            int i = 0;
            int j = 0;
            while (i < list.size()) {
                List<?> subList = list.subList(i, Math.min(list.size(), i + step));
                sb.append(BlockSqlUtil.buildInClauseWithLimit(field, paramKey + j, params, subList));
                if (i + step < list.size()) {
                    sb.append(" OR ");
                }
                i += step;
                ++j;
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    private static String buildInClauseWithLimit(String field, String paramKey, Map<String, Object> params, List<?> list) {
        StringBuilder sb = new StringBuilder();
        String paramName = ":" + paramKey;
        sb.append(" " + field + " IN ( " + paramName + " ) ");
        params.put(paramKey, list);
        return sb.toString();
    }

    public static String buildFieldFragment(String tableAlias, Collection<String> fields) {
        if (fields == null || fields.isEmpty()) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildFieldFragment_658", (String)"\u53c2\u6570fields\u4e3a\u7a7a\u3002"));
        }
        String[] arr = fields.toArray(new String[0]);
        return BlockSqlUtil.buildFieldFragment(tableAlias, arr);
    }

    public static String buildFieldFragment(String tableAlias, String[] fields) {
        if (fields == null || fields.length == 0) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockSqlUtil_buildFieldFragment_671", (String)"\u53c2\u6570fields\u4e3a\u7a7a\u3002"));
        }
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < fields.length; ++i) {
            if (StringUtil.isNullOrTrimEmptyString((String)tableAlias)) {
                sb.append(fields[i]);
            } else {
                sb.append(tableAlias + "." + fields[i]);
            }
            if (i == fields.length - 1) continue;
            sb.append(DEFAULT_SPLITER);
        }
        sb.append(" ");
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] datas = new String[]{"aa", "bb", "cc", "dd", "ee", "ff", "gg", "hh", "nn", "pp"};
        HashMap<String, Object> params = new HashMap<String, Object>();
        System.out.println(BlockSqlUtil.buildInClauseWithoutLimit("T.NAME", "NAME", params, Arrays.asList(datas)));
        System.out.println(params);
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5%\u767e\u5206\u53f7\u67e5\u8be2"));
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5*\u5339\u914d\u4efb\u610f"));
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5.\u5339\u914d\u4e00\u4e2a"));
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5\\\u53cd\u659c\u6760"));
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5\\\\%\u597d\u770b"));
        System.out.println(BlockSqlUtil.escapeLikeValue("\u6d4b\u8bd5\\\\\u597d\u770b"));
    }
}

