/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.DateParseException;
import com.ygsoft.ecp.service.date.EcpDate;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CastUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(CastUtil.class);
    private static final String[] CN_NUMBER_NAME = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_PATTERN_YEARMONTH = "yyyy-MM";
    public static final String EMPTY_STRING = "";
    public static final String ONE_BLANK = " ";
    public static final int UNIT_TEN = 10;
    public static final int UNIT_HUNDRED = 100;
    public static final int UNIT_THOUSAND = 1000;
    public static final int UNIT_TEN_THOUSAND = 10000;
    public static final int UNIT_HUNDRED_THOUSAND = 100000;
    public static final int UNIT_MILLION = 1000000;
    public static final int FOUR = 4;
    public static final int HUNDRED = 100;
    public static final int FOURHUNDRED = 400;
    public static final int YEAR_DAYS = 365;
    public static final int LEAP_YEAR_DAYS = 366;
    private static final HashMap<Integer, Character> CHARMAP = new HashMap<Integer, Character>(){
        {
            this.put(1, Character.valueOf('y'));
            this.put(2, Character.valueOf('M'));
            this.put(3, Character.valueOf('d'));
            this.put(4, Character.valueOf('H'));
            this.put(5, Character.valueOf('m'));
            this.put(6, Character.valueOf('s'));
        }
    };

    private CastUtil() {
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String getTrimString(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = obj.toString();
        return str.trim();
    }

    public static String getSafeString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.toString();
    }

    public static String getBlankString(Object obj) {
        if (obj == null) {
            return ONE_BLANK;
        }
        String str = obj.toString();
        if (StringUtil.isEmpty((String)str)) {
            return ONE_BLANK;
        }
        return str;
    }

    public static String getSafeTrimString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        String str = obj.toString();
        return str.trim();
    }

    public static Double getDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        return Double.valueOf(obj.toString());
    }

    public static Long getLong(Object obj) {
        if (obj == null) {
            return null;
        }
        return Long.valueOf(obj.toString());
    }

    public static Integer getInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        return Integer.valueOf(obj.toString());
    }

    public static int getIntegerDefaultZero(Integer val) {
        if (null == val) {
            return 0;
        }
        return val;
    }

    public static Integer getInteger(BigDecimal decimal, int unit) {
        if (decimal == null) {
            return null;
        }
        BigDecimal result = decimal.multiply(new BigDecimal(unit));
        return result.intValue();
    }

    public static BigDecimal getBigDecimal(Integer value, int unit) {
        if (null == value) {
            return null;
        }
        BigDecimal result = new BigDecimal(1.0 * (double)value.intValue() / (double)unit);
        return result.setScale(2, 4);
    }

    public static Long getLong(BigDecimal decimal, int unit) {
        if (decimal == null) {
            return null;
        }
        BigDecimal result = decimal.multiply(new BigDecimal(unit));
        return result.longValue();
    }

    public static BigDecimal getBigDecimal(Long value, int unit) {
        if (null == value) {
            return null;
        }
        BigDecimal result = new BigDecimal(1.0 * (double)value.longValue() / (double)unit);
        return result.setScale(2, 4);
    }

    public static int getIntegerNull2Zero(Object obj) {
        String str = CastUtil.getSafeString(obj);
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return 0;
        }
        return Integer.valueOf(obj.toString());
    }

    public static BigDecimal getBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = obj.toString();
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        return new BigDecimal(obj.toString());
    }

    public static BigDecimal getNegativeBigDecimal(Object obj) {
        BigDecimal bd = CastUtil.getBigDecimalNullToZero(obj);
        return BigDecimal.ZERO.subtract(bd);
    }

    public static BigDecimal getBigDecimalNullToZero(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (StringUtil.isNullOrTrimEmptyString((String)obj.toString())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public static String dxid2Str(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        String tmpStr = obj.toString();
        return tmpStr.substring(tmpStr.indexOf(".") + 1);
    }

    public static String getToDayStr() {
        Date currentDate = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        return fmt.format(currentDate);
    }

    public static String getDateStr(Date curDate) {
        String value = EMPTY_STRING;
        SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        value = fmt.format(curDate);
        return value;
    }

    public static String getYearMonthDateStr(Date curDate) {
        String value = EMPTY_STRING;
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_PATTERN_YEARMONTH);
        value = fmt.format(curDate);
        return value;
    }

    public static Date getDate(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Date) {
            Date dateObj = (Date)obj;
            return new Date(dateObj.getTime());
        }
        String str = obj.toString();
        SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        Date d = null;
        try {
            d = fmt.parse(str);
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\u5b57\u7b26\u4e32\uff08" + str + "\uff09\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u3002"), (Throwable)e);
            }
            throw new EcpRuntimeException(EMPTY_STRING, EcpI18nUtil.localizedString((String)"CastUtil_getDate_468", (String)("\u5b57\u7b26\u4e32\uff08" + str + "\uff09\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u3002"), (Object[])new Object[]{str}), (Throwable)e, new Object[0]);
        }
        return d;
    }

    public static Date clearTime(Date currentDate) {
        if (null == currentDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addMonth(Date currentDate, int months) {
        if (null == currentDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date addDay(Date currentDate, int days) {
        if (null == currentDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addHour(Date currentDate, int hours) {
        if (null == currentDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(10, hours);
        return cal.getTime();
    }

    public static int newSize(List<?> list) {
        int defSize = 16;
        if (null == list || list.isEmpty()) {
            return 16;
        }
        return list.size();
    }

    public static List<Integer> str2IntegerList(List<String> list) {
        if (null == list) {
            return null;
        }
        ArrayList<Integer> intList = new ArrayList<Integer>(CastUtil.newSize(list));
        for (String str : list) {
            intList.add(CastUtil.getInteger(str));
        }
        return intList;
    }

    public static List<String> int2StringList(List<Integer> list) {
        if (null == list) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>(CastUtil.newSize(list));
        for (Integer i : list) {
            strList.add(CastUtil.getString(i));
        }
        return strList;
    }

    public static List<String> long2StringList(List<Long> list) {
        if (null == list) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>(CastUtil.newSize(list));
        for (Long i : list) {
            strList.add(CastUtil.getString(i));
        }
        return strList;
    }

    public static boolean isNumber(String value) {
        boolean isNumber = false;
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        String reg = "^[0-9]+(.[0-9]+)?$";
        return value.matches("^[0-9]+(.[0-9]+)?$");
    }

    public static boolean checkStr(String value) {
        boolean isNumber = false;
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        String reg = "^[0-9a-zA-Z-\\/]+$";
        return value.matches("^[0-9a-zA-Z-\\/]+$");
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static <T> Optional<List<T>> jsonArrayToList(String jsonArrayStr, Class<T> cls) {
        JSONArray jsonArray = JSONObject.parseArray((String)jsonArrayStr);
        List list = jsonArray.stream().map(s -> {
            Object obj;
            block5: {
                JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)s);
                obj = null;
                try {
                    obj = cls.newInstance();
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = String.valueOf(entry.getValue());
                        try {
                            PropertyDescriptor pd = new PropertyDescriptor(key, cls);
                            if (pd == null) continue;
                            pd.getWriteMethod().invoke(obj, value);
                        }
                        catch (Exception e) {
                            if (!LOG.isInfoEnabled()) continue;
                            LOG.info((Object)(key + "\u5728\u7c7b" + cls + "\u4e2d\u6ca1\u6709\u5bf9\u5e94\u5c5e\u6027"));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error((Object)e);
                }
            }
            return obj;
        }).collect(Collectors.toList());
        return Optional.ofNullable(list);
    }

    public static Map<String, String> toStringMap(Map<String, List<String>> listMap) {
        if (null == listMap) {
            return null;
        }
        boolean ONE_SIZE = true;
        HashMap<String, String> strMap = new HashMap<String, String>();
        listMap.forEach((key, list) -> {
            Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0);
            strMap.put((String)key, (String)list.get(0));
        });
        return strMap;
    }

    public static Map<String, Object> stringToObjectValueMap(Map<String, String> strMap) {
        if (null == strMap) {
            return null;
        }
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        strMap.forEach((key, value) -> objMap.put((String)key, value));
        return objMap;
    }

    private static String replaceEachChar(String s, Character c) {
        StringBuilder sb = new StringBuilder(EMPTY_STRING);
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c1 = Character.valueOf(cArray[i]);
            if (c1.charValue() == ' ') continue;
            sb.append(String.valueOf(c));
        }
        return sb.toString();
    }

    public static Date stringToDate(String dateStr) {
        String dateString = dateStr.trim().replaceAll("[a-zA-Z]", ONE_BLANK);
        if (Pattern.matches("^[-+]?\\d{13}$", dateString)) {
            return new Date(Long.parseLong(dateString));
        }
        Pattern p = Pattern.compile("^(\\d+)\\D*(\\d*)\\D*(\\d*)\\D*(\\d*)\\D*(\\d*)\\D*(\\d*)");
        Matcher m = p.matcher(dateString);
        StringBuilder sb = new StringBuilder(dateString);
        if (m.find(0)) {
            int count = m.groupCount();
            for (int i = 1; i <= count; ++i) {
                for (Map.Entry<Integer, Character> entry : CHARMAP.entrySet()) {
                    if (entry.getKey() != i) continue;
                    sb.replace(m.start(i), m.end(i), CastUtil.replaceEachChar(m.group(i), entry.getValue()));
                }
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(dateString + " \u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f\u3002"));
            }
            throw new DateParseException("ABC.0018", "\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef");
        }
        SimpleDateFormat sf = new SimpleDateFormat(sb.toString());
        try {
            return sf.parse(dateString);
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(dateString + " \u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f\u3002"));
            }
            throw new DateParseException("ABC.0018", EcpI18nUtil.localizedString((String)"CastUtil_stringToDate_780", (String)"\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef"), e, new Object[0]);
        }
    }

    public static String dateToStringCN(Date date) {
        StringBuilder sb = new StringBuilder(EMPTY_STRING);
        if (null == date) {
            return sb.toString();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(cal.get(2) + 1);
        String day = String.valueOf(cal.get(5));
        for (int i = 0; i < year.length(); ++i) {
            sb.append(CN_NUMBER_NAME[Integer.parseInt(String.valueOf(year.charAt(i)))]);
        }
        sb.append("\u5e74");
        if (month.length() == 2) {
            sb.append("\u5341");
            if (!String.valueOf(month.charAt(1)).equals("0")) {
                sb.append(CN_NUMBER_NAME[Integer.parseInt(String.valueOf(month.charAt(1)))]);
            }
        } else {
            sb.append(CN_NUMBER_NAME[Integer.parseInt(String.valueOf(month.charAt(0)))]);
        }
        sb.append("\u6708");
        if (day.length() == 2) {
            Integer value = Integer.parseInt(String.valueOf(day.charAt(0)));
            if (!value.equals(1)) {
                sb.append(CN_NUMBER_NAME[value]);
            }
            sb.append("\u5341");
            if (!String.valueOf(day.charAt(1)).equals("0")) {
                sb.append(CN_NUMBER_NAME[Integer.parseInt(String.valueOf(day.charAt(1)))]);
            }
        } else {
            sb.append(CN_NUMBER_NAME[Integer.parseInt(String.valueOf(day.charAt(0)))]);
        }
        sb.append("\u65e5");
        return sb.toString();
    }

    public static String dateToString(Date date, Locale locale) {
        StringBuilder sb = new StringBuilder(EMPTY_STRING);
        if (null == date) {
            return sb.toString();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy", locale);
        return sdf.format(date);
    }

    public static String ecpDateToString(EcpDate ecpDate) {
        if (Objects.isNull(ecpDate)) {
            return null;
        }
        Long millis = ecpDate.toCalendar().getTimeInMillis();
        return CastUtil.getString(millis);
    }

    public static EcpDate strToEcpDate(String millis) {
        if (StringUtil.isNullOrTrimEmptyString((String)millis)) {
            return null;
        }
        return new EcpDate(new Date(CastUtil.getLong(millis)));
    }

    public static String localeToString(Locale locale) {
        if (Objects.isNull(locale)) {
            return null;
        }
        return locale.toString();
    }

    public static Locale strToLocale(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((char)'_').split((CharSequence)str));
        int size = list.size();
        switch (size) {
            case 1: {
                return new Locale((String)list.get(0));
            }
            case 2: {
                return new Locale((String)list.get(0), (String)list.get(1));
            }
            case 3: {
                return new Locale((String)list.get(0), (String)list.get(1), (String)list.get(2));
            }
        }
        throw new AbcServiceException("ABC.0015", EcpI18nUtil.localizedString((String)"CastUtil_strToLocale_916", (String)"Locale\u683c\u5f0f\u9519\u8bef\u3002"));
    }

    public static String timeZoneToString(TimeZone timeZone) {
        if (Objects.isNull(timeZone)) {
            return null;
        }
        return timeZone.getID();
    }

    public static TimeZone strToTimeZone(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        return TimeZone.getTimeZone(ZoneId.of(str));
    }
}

