/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.alibaba.ans.shaded.com.google.common.collect.Lists;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.domain.vo.UserVO;
import com.ygsoft.abc.service.exception.AbcEncodeException;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.querydelivery.type.EqualQueryOperator;
import com.ygsoft.abc.service.querydelivery.type.GtQueryOperator;
import com.ygsoft.abc.service.querydelivery.type.LikeQueryOperator;
import com.ygsoft.abc.service.querydelivery.type.LtQueryOperator;
import com.ygsoft.abc.service.querydelivery.type.QueryOperator;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockJSONUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.EncryDesUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.alibaba.fastjson.JSONArray;
import com.ygsoft.alibaba.fastjson.JSONObject;
import com.ygsoft.ecp.framework.util.ResourceUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class CommonUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(CommonUtil.class);
    public static final String PAGE_FIELD_CONTENT = "content";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    private static final int EMPTY_SIZE = 0;
    private static final Random random = new Random(new Date().getTime());
    private static final Map<String, String> FIELD_OPERATOR_TO_QUERY_OPERATOR = ImmutableMap.of((Object)"contain", (Object)"like", (Object)"equal", (Object)"eq", (Object)"greater", (Object)"gt", (Object)"less", (Object)"lt");

    private CommonUtil() {
    }

    public static int getLength(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static int getLength(byte[] arr) {
        if (arr == null) {
            return 0;
        }
        return arr.length;
    }

    public static boolean isEquals(String str1, String str2) {
        if (null == str1) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean isNotEquals(String str1, String str2) {
        if (null == str1) {
            return false;
        }
        return !str1.equals(str2);
    }

    public static <T> T getOnlyOne(List<T> list) {
        if (BlockCollectionUtil.isEmpty(list)) {
            return null;
        }
        PreconditionUtil.checkArgument(list.size() == 1, "\u5305\u542b\u591a\u4e2a\u5143\u7d20\u3002");
        return list.get(0);
    }

    public static <T> T getOnlyOne(List<T> list, String msg) {
        if (BlockCollectionUtil.isEmpty(list)) {
            return null;
        }
        PreconditionUtil.checkArgument(list.size() == 1, msg);
        return list.get(0);
    }

    public static String firstNonTrimEmpty(String first, String second) {
        if (CommonUtil.isNotTrimEmptyString(first)) {
            return first;
        }
        if (StringUtil.isNullOrTrimEmptyString((String)second)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_firstNonTrimEmpty_121", (String)"\u53c2\u6570\u9519\u8bef\uff1asecond\u4e3a\u7a7a\u3002"));
        }
        return second;
    }

    public static String firstNotTrimEmpty(String ... strs) {
        for (String str : strs) {
            if (!CommonUtil.isNotTrimEmptyString(str)) continue;
            return str;
        }
        throw EmptyValueException.newInstance("\u6240\u6709\u5b57\u7b26\u4e32\u90fd\u4e3a\u7a7a\u3002");
    }

    public static <T> T firstNonNull(T first, T second) {
        if (null == second) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_firstNonNull_133", (String)"\u53c2\u6570\u9519\u8bef\uff1asecond\u4e3a\u7a7a\u3002"));
        }
        return first != null ? first : second;
    }

    public static byte[] toBytes(String str) {
        if (null == str) {
            return null;
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw AbcEncodeException.getInstance("\u5b57\u7b26\u4e32\u8f6c\u5b57\u8282\u6570\u7ec4\u5931\u8d25\u3002", e);
        }
    }

    public static String toString(byte[] arr) {
        if (null == arr) {
            return null;
        }
        try {
            return new String(arr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw AbcEncodeException.getInstance("\u5b57\u8282\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32\u5931\u8d25\u3002", e);
        }
    }

    public static boolean isNotTrimEmptyString(String value) {
        return !StringUtil.isNullOrTrimEmptyString((String)value);
    }

    public static String extractHeadByLimitLength(String str, int maxLength) {
        PreconditionUtil.checkArgument(maxLength > 0, "\u53c2\u6570\u9519\u8bef\uff1amaxLength\u5fc5\u987b\u5927\u4e8e0\u3002");
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    public static Object deepClone(Object obj) {
        Object object;
        if (null == obj) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_deepClone_154", (String)"\u53c2\u6570\u9519\u8bef\uff1aobj\u4e3anull\u3002"));
        }
        ObjectOutputStream output = null;
        ObjectInputStream input = null;
        try {
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            output = new ObjectOutputStream(byteOutStream);
            output.writeObject(obj);
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
            input = new ObjectInputStream(byteInStream);
            object = input.readObject();
        }
        catch (Exception e) {
            try {
                throw new AbcIOException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
        return object;
    }

    /*
     * Exception decompiling
     */
    public static String getStackTrace(Exception e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> parseQuery(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (query != null && !"".equals(query)) {
            String[] params;
            for (String param : params = query.split(",")) {
                String[] s = param.split(":");
                map.put(s[0], s[1]);
            }
        }
        return map;
    }

    public static <T> T buildObj(Class<T> cls, Map<String, String> params) {
        T obj;
        block28: {
            obj = null;
            HashMap innerObjectMap = null;
            try {
                obj = cls.newInstance();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.indexOf(".") > -1) {
                        PropertyDescriptor innerPd;
                        String key_1 = key.split("\\.")[0];
                        String key_2 = key.split("\\.")[1];
                        PropertyDescriptor pd = new PropertyDescriptor(key_1, cls);
                        Class<?> innerCls = pd.getPropertyType();
                        Object innerObj = null;
                        if (innerObjectMap == null) {
                            innerObjectMap = new HashMap();
                        }
                        if (innerObjectMap.containsKey(key_1)) {
                            innerObj = innerObjectMap.get(key_1);
                        } else {
                            innerObj = pd.getPropertyType().newInstance();
                            innerObjectMap.put(key_1, innerObj);
                            pd.getWriteMethod().invoke(obj, innerObj);
                        }
                        if ((innerPd = new PropertyDescriptor(key_2, innerCls)) == null) continue;
                        Class<Number> innerProperty = innerPd.getPropertyType();
                        String innerValue = params.get(key);
                        if (innerProperty.isAssignableFrom(Integer.TYPE) || innerProperty.isAssignableFrom(Integer.class)) {
                            innerPd.getWriteMethod().invoke(innerObj, Integer.parseInt(innerValue));
                            continue;
                        }
                        if (innerProperty.isAssignableFrom(Float.TYPE) || innerProperty.isAssignableFrom(Float.class)) {
                            innerPd.getWriteMethod().invoke(innerObj, Float.valueOf(Float.parseFloat(innerValue)));
                            continue;
                        }
                        if (innerProperty.isAssignableFrom(Long.TYPE) || innerProperty.isAssignableFrom(Long.class)) {
                            innerPd.getWriteMethod().invoke(innerObj, Long.parseLong(innerValue));
                            continue;
                        }
                        if (innerProperty.isAssignableFrom(Double.TYPE) || innerProperty.isAssignableFrom(Double.class)) {
                            innerPd.getWriteMethod().invoke(innerObj, Double.parseDouble(innerValue));
                            continue;
                        }
                        if (innerProperty.isAssignableFrom(BigDecimal.class)) {
                            innerPd.getWriteMethod().invoke(innerObj, new BigDecimal(innerValue));
                            continue;
                        }
                        innerPd.getWriteMethod().invoke(innerObj, innerValue);
                        continue;
                    }
                    PropertyDescriptor pd = new PropertyDescriptor(key, cls);
                    if (pd == null) continue;
                    Class<Serializable> propertyType = pd.getPropertyType();
                    if (propertyType.isAssignableFrom(Integer.TYPE) || propertyType.isAssignableFrom(Integer.class)) {
                        pd.getWriteMethod().invoke(obj, Integer.parseInt(value));
                        continue;
                    }
                    if (propertyType.isAssignableFrom(Float.TYPE) || propertyType.isAssignableFrom(Float.class)) {
                        pd.getWriteMethod().invoke(obj, Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if (propertyType.isAssignableFrom(Long.TYPE) || propertyType.isAssignableFrom(Long.class)) {
                        pd.getWriteMethod().invoke(obj, Long.parseLong(value));
                        continue;
                    }
                    if (propertyType.isAssignableFrom(Double.TYPE) || propertyType.isAssignableFrom(Double.class)) {
                        pd.getWriteMethod().invoke(obj, Double.parseDouble(value));
                        continue;
                    }
                    if (propertyType.isAssignableFrom(BigDecimal.class)) {
                        pd.getWriteMethod().invoke(obj, new BigDecimal(value));
                        continue;
                    }
                    if (propertyType.isAssignableFrom(Date.class)) {
                        pd.getWriteMethod().invoke(obj, new SimpleDateFormat("yyyy-MM-dd").parse(value));
                        continue;
                    }
                    pd.getWriteMethod().invoke(obj, value);
                }
            }
            catch (ParseException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (IntrospectionException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (InstantiationException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (IllegalArgumentException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (InvocationTargetException e) {
                if (!LOG.isErrorEnabled()) break block28;
                LOG.error((Object)e);
            }
        }
        return obj;
    }

    public static <T> T buildObj(Class<T> cls, String param) {
        Map<String, String> map = CommonUtil.parseQuery(param);
        return CommonUtil.buildObj(cls, map);
    }

    public static String getStringValFromRowMap(Map<String, Object> rowMap, String field) {
        String val = "";
        Object obj = rowMap.get(field);
        if (obj != null) {
            val = obj.toString();
        }
        return val;
    }

    public static String formatAmount(String amountStr) {
        if (amountStr != null && !amountStr.isEmpty()) {
            String points = "";
            if (amountStr.indexOf(".") > -1) {
                String[] strs = amountStr.split("\\.");
                amountStr = strs[0];
                points = "." + strs[1];
            }
            StringBuilder sb = new StringBuilder(amountStr);
            StringBuilder newSb = new StringBuilder();
            char[] chars = (sb = sb.reverse()).toString().toCharArray();
            if (chars.length > 0) {
                for (int i = 0; i < chars.length; ++i) {
                    if (i != 0 && i % 3 == 0 && i < chars.length) {
                        newSb.append(",");
                    }
                    newSb.append(chars[i]);
                }
                newSb = newSb.reverse();
            }
            amountStr = newSb.toString() + points;
        }
        return amountStr;
    }

    public static String getSystemDisk() {
        String prop = "abc.attachment.temp.dir";
        return PropertyConfigUtil.getStrictProperty("abc.attachment.temp.dir");
    }

    private static boolean isUnknown(String remoteIp) {
        return remoteIp == null || remoteIp.length() == 0 || "unknown".equalsIgnoreCase(remoteIp);
    }

    public static String getRemortIP(HttpServletRequest request) {
        try {
            String remoteIp = request.getHeader("x-forwarded-for");
            if (CommonUtil.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("Proxy-Client-IP");
            }
            if (CommonUtil.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("WL-Proxy-Client-IP");
            }
            if (CommonUtil.isUnknown(remoteIp)) {
                remoteIp = request.getRemoteAddr();
            }
            if (CommonUtil.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("http_client_ip");
            }
            if (CommonUtil.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (remoteIp != null && remoteIp.indexOf(",") != -1) {
                remoteIp = remoteIp.substring(remoteIp.lastIndexOf(",") + 1, remoteIp.length()).trim();
            }
            return remoteIp;
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"ip\u83b7\u53d6\u5931\u8d25", e);
            }
            return "0.0.0.0";
        }
    }

    @Deprecated
    public static String toJSONString(Object obj) {
        return BlockJSONUtil.toComposerJSONString(obj);
    }

    @Deprecated
    public static String toJSONStringWithOutJcls(Object obj) {
        return BlockJSONUtil.toJSONString(obj);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("\n>>>\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a" + e.getMessage()));
            }
            Thread.currentThread().interrupt();
        }
    }

    public static String getLocalIPHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String ip = addr.getHostAddress();
            String hostName = addr.getHostName();
            return ip + "/" + hostName;
        }
        catch (Exception e) {
            CommonUtil.logError("\u83b7\u53d6\u672c\u673aIP\u548c\u4e3b\u673a\u540d\u79f0\u5931\u8d25", e);
            return "";
        }
    }

    public static <T> List<T> getPageContents(JSONObject jsonObj, Class<T> clazz) {
        if (null == jsonObj || null == clazz) {
            String msg = EcpI18nUtil.localizedString((String)"CommonUtil_getPageContents_538", (String)"\u53c2\u6570\u9519\u8bef\uff1ajsonObj\u6216clazz\u4e3anull\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (!jsonObj.containsKey((Object)PAGE_FIELD_CONTENT)) {
            String msg = EcpI18nUtil.localizedString((String)"CommonUtil_getPageContents_542", (String)"\u89e3\u6790jsonObj\u4e0d\u5305\u542bcontent\u5b57\u6bb5\u3002");
            throw new AbcServiceException("ABC.0015", msg);
        }
        ArrayList list = new ArrayList();
        JSONArray jsonArr = (JSONArray)jsonObj.get((Object)PAGE_FIELD_CONTENT);
        jsonArr.forEach(json -> {
            Object record = JSONObject.parseObject((String)json.toString(), (Class)clazz);
            list.add(record);
        });
        return list;
    }

    public static String replaceDotToUnderline(String typeName) {
        if (null == typeName) {
            return null;
        }
        return typeName.replaceAll("\\.", "_");
    }

    public static int newListSize(Collection<?> collection) {
        if (null == collection) {
            return 0;
        }
        return collection.size();
    }

    public static String extractUrl(String url) {
        String copyUrl = url;
        int idx = (copyUrl = copyUrl.replaceFirst(HTTP_PREFIX, "").replaceFirst(HTTPS_PREFIX, "")).indexOf("/");
        if (idx > -1 && (copyUrl = copyUrl.substring(0, idx)).contains(":")) {
            copyUrl = copyUrl.substring(0, copyUrl.indexOf(":"));
        }
        return copyUrl;
    }

    public static <T, R> List<R> extract(List<T> list, Function<T, R> func) {
        if (Objects.isNull(func)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_extract_607", (String)"\u53c2\u6570\u9519\u8bef\uff1afunc\u4e3anull\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        List extractList = list.stream().map(func).collect(Collectors.toList());
        return extractList;
    }

    public static <T> List<T> removeDuplicate(List<T> list, Comparator<T> comparator) {
        if (Objects.isNull(comparator)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_removeDuplicate_624", (String)"\u53c2\u6570\u9519\u8bef\uff1acomparator\u4e3anull\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        List uniqueList = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), ArrayList::new));
        return uniqueList;
    }

    public static <K, V> Map<K, V> listToMap(List<V> list, Function<V, K> func) {
        if (Objects.isNull(func)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_listToMap_642", (String)"\u53c2\u6570\u9519\u8bef\uff1afunc\u4e3anull\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        Map<K, Object> map = list.stream().collect(Collectors.toMap(func, ele -> ele));
        return map;
    }

    public static QueryOperator fieldOperatorToQueryOperator(String fieldOperator) {
        if (StringUtil.isNullOrTrimEmptyString((String)fieldOperator)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"CommonUtil_fieldOperatorToQueryOperator_659", (String)"\u53c2\u6570\u9519\u8bef\uff1afieldOperator\u4e3a\u7a7a\u3002"));
        }
        switch (fieldOperator) {
            case "contain": {
                return LikeQueryOperator.newInstance();
            }
            case "equal": {
                return EqualQueryOperator.newInstance();
            }
            case "greater": {
                return GtQueryOperator.newInstance();
            }
            case "less": {
                return LtQueryOperator.newInstance();
            }
        }
        return LikeQueryOperator.newInstance();
    }

    public static InputStream readConfig(String filePath) {
        List urls = ResourceUtil.findResources((String)filePath);
        if (BlockCollectionUtil.isEmpty(urls)) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"CommonUtil_readConfig_680", (String)"\u6307\u5b9a\u8def\u5f84(%s)\u67e5\u627e\u8d44\u6e90\u5931\u8d25\u3002"), filePath);
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            return ((URL)urls.get(0)).openStream();
        }
        catch (IOException e) {
            throw new AbcServiceException("ABC.0015", e.getMessage(), e, new Object[0]);
        }
    }

    public static long randomNumber(int length) {
        String str = CastUtil.getString(random.nextDouble());
        int idx = str.indexOf(46);
        str = StringUtil.trim((String)str.substring(idx + 1));
        str = CommonUtil.firstNumber() + str;
        if (str.length() >= length) {
            return CastUtil.getInteger(str.substring(0, length)).intValue();
        }
        int padCount = length - str.length();
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < padCount; ++i) {
            sb.append("0");
        }
        return CastUtil.getLong(sb.toString());
    }

    public static String nextNumberWithPaddingPrefixZero(String value) {
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            String msg = "\u53c2\u6570\u9519\u8befvalue\u4e3a\u7a7a\u3002";
            throw new EmptyValueException("ABC.0001", "\u53c2\u6570\u9519\u8befvalue\u4e3a\u7a7a\u3002");
        }
        int length = value.length();
        int intValue = CastUtil.getInteger(value);
        return CommonUtil.paddingPrefixZero(intValue + 1, length);
    }

    public static String paddingPrefixZero(int value, int length) {
        String str = CastUtil.getString(value);
        if (str.length() > length) {
            String msg = "\u6570\u503c\u957f\u5ea6\u8d85\u8fc7\u6307\u5b9alength\u3002";
            throw new AbcServiceException("ABC.0015", "\u6570\u503c\u957f\u5ea6\u8d85\u8fc7\u6307\u5b9alength\u3002");
        }
        if (str.length() == length) {
            return str;
        }
        int padCount = length - str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < padCount; ++i) {
            sb.append("0");
        }
        return sb.toString() + str;
    }

    private static int firstNumber() {
        int maxCount = 10;
        int first = 0;
        int i = 0;
        while (++i < 10) {
            first = random.nextInt(10);
            if (first == 0) continue;
            return first;
        }
        return 1;
    }

    public static Map<String, String> parseParamUrl(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            return map;
        }
        if (url.contains("?")) {
            int idx = url.indexOf(63);
            String paramUrl = url.substring(idx + 1);
            ArrayList params = Lists.newArrayList((Iterable)Splitter.on((char)'&').split((CharSequence)paramUrl));
            for (String param : params) {
                String[] arr = param.split("=");
                String field = CastUtil.getSafeString(arr[0]);
                String value = CastUtil.getSafeString(arr[1]);
                map.put(field, value);
            }
        }
        return map;
    }

    public static String mapToParamUrl(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        map.forEach((key, value) -> sb.append((String)key).append("=").append((String)value).append("&"));
        String paramUrl = sb.toString();
        if (paramUrl.endsWith("&")) {
            return paramUrl.substring(0, paramUrl.length() - 1);
        }
        return paramUrl;
    }

    private static void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error((Object)("\n###" + obj));
            } else {
                LOG.error((Object)("\n###" + obj), e);
            }
        }
    }

    public static InetAddress getLocalAddress() {
        block4: {
            try {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = allNetInterfaces.nextElement();
                    if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress ip = addresses.nextElement();
                        if (ip == null) continue;
                        return ip;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)"\u83b7\u53d6\u672c\u673aIP\u5730\u5740\u5931\u8d25\u3002");
            }
        }
        return null;
    }

    public static String confusionStr(String info, int hold) {
        int i;
        char[] m = info.toCharArray();
        if (info.length() > 2) {
            for (i = 0; i < info.length(); ++i) {
                if (i < hold || i >= info.length() - hold) continue;
                m[i] = 42;
            }
        } else if (info.length() == 2) {
            for (i = 0; i < info.length(); ++i) {
                if (i < 1) continue;
                m[i] = 42;
            }
        }
        String result = String.valueOf(m);
        return result;
    }

    public static void confusionAndEncodeUserUserVO(UserVO userVO) {
        String cardId = userVO.getCardId();
        String email = userVO.getEmail();
        String movetel = userVO.getMovetel();
        if (!StringUtil.isNullOrTrimEmptyString((String)cardId)) {
            userVO.setCardId(EncryDesUtil.doEncodeByDefaultKey(CommonUtil.confusionStr(cardId, 4)));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)email)) {
            userVO.setEmail(EncryDesUtil.doEncodeByDefaultKey(CommonUtil.confusionStr(email, 3)));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)movetel)) {
            userVO.setMovetel(EncryDesUtil.doEncodeByDefaultKey(CommonUtil.confusionStr(movetel, 3)));
        }
    }

    public static void encodeUserVO(UserVO userVO) {
        String cardId = userVO.getCardId();
        String email = userVO.getEmail();
        String movetel = userVO.getMovetel();
        if (!StringUtil.isNullOrTrimEmptyString((String)cardId)) {
            userVO.setCardId(EncryDesUtil.doEncodeByDefaultKey(cardId));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)email)) {
            userVO.setEmail(EncryDesUtil.doEncodeByDefaultKey(email));
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)movetel)) {
            userVO.setMovetel(EncryDesUtil.doEncodeByDefaultKey(movetel));
        }
    }

    public static Executor getThreadPoolExecutor() {
        Executor executor = (Executor)OSGiUtil.getSpringBean((String)"abcThreaPoolExecutor");
        return executor;
    }

    public static boolean isNumber(String str) {
        String regex = "^[-\\+]?[\\d]*[.]?[\\d]+$";
        return Pattern.matches("^[-\\+]?[\\d]*[.]?[\\d]+$", str);
    }

    public static void main(String[] args) {
        String typeName = "com.ygsoft.abc.service.tool.CommonUtil";
        System.out.println(CommonUtil.replaceDotToUnderline("com.ygsoft.abc.service.tool.CommonUtil"));
    }
}

