/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import jodd.io.StreamUtil;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public final class ExcelUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExcelUtil.class);

    private ExcelUtil() {
    }

    public static Workbook getWrokbook(InputStream in, String fileName) {
        Workbook workbook = null;
        if (null == in) {
            throw new RuntimeException(EcpI18nUtil.localizedString((String)"ExcelUtil_getWrokbook_69", (String)"\u6587\u4ef6\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isEmpty((String)fileName)) {
            throw new RuntimeException(EcpI18nUtil.localizedString((String)"ExcelUtil_getWrokbook_72", (String)"\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002"));
        }
        try {
            workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u3002", (Throwable)e);
            }
            throw new RuntimeException(EcpI18nUtil.localizedString((String)"ExcelUtil_getWrokbook_87", (String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u3002"), e);
        }
        return workbook;
    }

    public static String getCellValue(Row row, int colIndex) {
        String value = "";
        if (null == row || colIndex < 0) {
            return value;
        }
        Cell cell = row.getCell(colIndex);
        value = ExcelUtil.getCellValue(cell);
        return value;
    }

    public static Date getCellDateValue(Row row, int colIndex) {
        String value = "";
        Date curDate = new Date();
        if (null == row || colIndex < 0) {
            return curDate;
        }
        Cell cell = row.getCell(colIndex);
        value = ExcelUtil.getCellValue(cell);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return curDate;
        }
        if (!value.contains("\u6708") || !value.contains("\u65e5")) {
            return curDate;
        }
        try {
            String[] tempArr = value.split("\u6708");
            int month = Integer.parseInt(tempArr[0]);
            tempArr = tempArr[1].split("\u65e5");
            int day = Integer.parseInt(tempArr[0]);
            tempArr = tempArr[1].split("/");
            tempArr = tempArr[1].split(":");
            int hour = Integer.parseInt(tempArr[0]);
            int minute = Integer.parseInt(tempArr[1]);
            int year = LocalDate.now().getYear();
            LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, 0);
            Date tempDate = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
            return tempDate;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\u89e3\u6790\u7684\u5ba1\u6838\u65f6\u95f4\u5f02\u5e38\uff1a" + e.toString()));
            }
            return curDate;
        }
    }

    public static String getCellValue(Cell cell) {
        DecimalFormat df;
        String cellValue = "";
        if (null == cell) {
            return cellValue;
        }
        if (CellType.STRING == cell.getCellType()) {
            cellValue = cell.getStringCellValue();
        }
        if (CellType.NUMERIC == cell.getCellType()) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                cellValue = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cell.getDateCellValue());
            } else {
                cellValue = String.valueOf(cell.getNumericCellValue());
                df = new DecimalFormat("#.##");
                cellValue = df.format(Double.valueOf(cellValue));
            }
        }
        if (CellType.BOOLEAN == cell.getCellType()) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        }
        if (CellType.BLANK == cell.getCellType()) {
            cellValue = "";
        }
        if (CellType.FORMULA == cell.getCellType()) {
            cellValue = String.valueOf(cell.getNumericCellValue());
            df = new DecimalFormat("#.##");
            cellValue = df.format(Double.valueOf(cellValue));
        }
        return cellValue.trim();
    }

    public static void exportTemplate(HttpServletResponse response, String filePath, String fileName) {
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            String encodeFileName = URLEncoder.encode(fileName, "utf-8");
            in = CommonUtil.readConfig(filePath);
            byteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)byteOut);
            byte[] imagebs = byteOut.toByteArray();
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName);
            response.getOutputStream().write(imagebs);
        }
        catch (Exception e) {
            try {
                throw new AbcServiceException("ABC.0015", e.getMessage(), e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(byteOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)byteOut);
    }

    public static byte[] workbookParseByte(HSSFWorkbook workbook) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            String errorMsg = String.format("\u5904\u7406\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a%s", e.getMessage());
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)errorMsg, (Throwable)e);
            }
            throw new AbcServiceException("ABC.0015", errorMsg);
        }
        finally {
            StreamUtil.close((Closeable)os);
        }
    }
}

