/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public final class ImgUtil {
    static final IEcpLog LOG = EcpLogFactory.getLog(BlockIOUtil.class);
    private static final Integer ZERO = 0;
    private static final Integer ONE_ZERO_TWO_FOUR = 1024;
    private static final int MIN_FILE_SIZE_KB = 20;
    private static final String SOURCE_IMAGE_INFO = "\u539f\u56fesize=%sKB,height=%s,width=%s";
    private static final String TARGET_IMAGE_INFO = "\u538b\u7f29\u56fesize=%sKB,height=%s,width=%s";

    private ImgUtil() {
    }

    public static byte[] compressForSize(byte[] imageBytes, long desFileSize) {
        if (imageBytes == null || imageBytes.length <= ZERO || (long)imageBytes.length < desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
            return imageBytes;
        }
        if (desFileSize < 20L) {
            throw AbcServiceException.newInstance("\u8bbe\u7f6e\u8fc7\u4f4e\uff0c\u538b\u7f29\u6700\u5c0f20KB\u3002");
        }
        try {
            if (LOG.isInfoEnabled()) {
                BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(imageBytes));
                LOG.info((Object)String.format(SOURCE_IMAGE_INFO, imageBytes.length / ONE_ZERO_TWO_FOUR, bufImg.getHeight(), bufImg.getWidth()));
            }
            while ((long)imageBytes.length > desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
                double accuracy = ImgUtil.getAccuracy(imageBytes.length / ONE_ZERO_TWO_FOUR, desFileSize);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(0.85f).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
                BlockIOUtil.close(inputStream);
                BlockIOUtil.close(outputStream);
                System.out.println("+1");
                if (!LOG.isInfoEnabled()) continue;
                BufferedImage bufImg2 = ImageIO.read(new ByteArrayInputStream(imageBytes));
                LOG.info((Object)String.format(TARGET_IMAGE_INFO, imageBytes.length / ONE_ZERO_TWO_FOUR, bufImg2.getHeight(), bufImg2.getWidth()));
            }
        }
        catch (Exception e) {
            throw AbcServiceException.newInstance("\u56fe\u7247\u538b\u7f29\u5931\u8d25\u3002", e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long currentSize, long desFileSize) {
        double ratio = (double)currentSize * 1.0 / ((double)desFileSize * 1.0);
        System.out.println("ratio=" + ratio);
        if (ratio <= 0.5) {
            return 0.9;
        }
        if (ratio <= 2.0) {
            return 0.85;
        }
        if (ratio <= 5.0) {
            return 0.8;
        }
        if (ratio <= 10.0) {
            return 0.6;
        }
        return 0.4;
    }

    public static void main(String[] args) {
        byte[] imageBytes = BlockIOUtil.readBytes("file:E:/work/image/10.3.jpg");
        byte[] compressBytes = ImgUtil.compressForSize(imageBytes, 900L);
        BlockIOUtil.write(compressBytes, "E:/work/image/new.jpg");
    }
}

