/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.types.DateTimeUnitEnum;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

public final class LocalDateUtil {
    public static final int HOUR_23 = 23;
    public static final int MINUTE_59 = 59;
    public static final int SECOND_59 = 59;
    private static final Map<DateTimeUnitEnum, String> UNIT_TO_PATTERN = ImmutableMap.builder().put((Object)DateTimeUnitEnum.YEAR, (Object)"yyyy").put((Object)DateTimeUnitEnum.MONTH, (Object)"yyyyMM").put((Object)DateTimeUnitEnum.WEEK, (Object)"yyyyww").put((Object)DateTimeUnitEnum.DAY, (Object)"yyyyMMdd").put((Object)DateTimeUnitEnum.HOUR, (Object)"yyyyMMddHH").put((Object)DateTimeUnitEnum.MINUTE, (Object)"yyyyMMddHHmm").put((Object)DateTimeUnitEnum.SECOND, (Object)"yyyyMMddHHmmss").build();

    private LocalDateUtil() {
    }

    public static LocalDate nowDate() {
        return LocalDate.now();
    }

    public static LocalTime nowTime() {
        return LocalTime.now();
    }

    public static LocalDateTime nowDateTime() {
        return LocalDateTime.now();
    }

    public static String formatDate(LocalDate localDate, String pattern) {
        return localDate.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseDate(String text, String pattern) {
        return LocalDate.parse(text, DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        return dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseDateTime(String text, String pattern) {
        return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime setZeroTime(LocalDateTime dateTime) {
        LocalDateTime localDateTime = dateTime.withHour(0).withMinute(0).withSecond(0);
        return localDateTime;
    }

    public static LocalDateTime setLastTime(LocalDateTime dateTime) {
        LocalDateTime localDateTime = dateTime.withHour(23).withMinute(59).withSecond(59);
        return localDateTime;
    }

    public static boolean beforeNowByDateTimeUnit(LocalDateTime localDateTime, DateTimeUnitEnum dateTimeUnit, boolean containsEqual) {
        String nowStr;
        LocalDateTime now = LocalDateTime.now();
        String pattern = UNIT_TO_PATTERN.get((Object)dateTimeUnit);
        String dateStr = LocalDateUtil.formatDateTime(localDateTime, pattern);
        int compare = dateStr.compareTo(nowStr = LocalDateUtil.formatDateTime(now, pattern));
        if (compare < 0) {
            return true;
        }
        return containsEqual && compare == 0;
    }

    public static boolean afterNowByDateTimeUnit(LocalDateTime localDateTime, DateTimeUnitEnum dateTimeUnit, boolean containsEqual) {
        String nowStr;
        LocalDateTime now = LocalDateTime.now();
        String pattern = UNIT_TO_PATTERN.get((Object)dateTimeUnit);
        String dateStr = LocalDateUtil.formatDateTime(localDateTime, pattern);
        int compare = dateStr.compareTo(nowStr = LocalDateUtil.formatDateTime(now, pattern));
        if (compare > 0) {
            return true;
        }
        return containsEqual && compare == 0;
    }
}

