/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.ecp.core.framework.internal.context.LoginContext;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Objects;

public final class MonitorUtil {
    private IEcpLog log;
    private Class<?> clazz = null;
    private String methodName = null;
    private long start = 0L;

    private MonitorUtil(IEcpLog log) {
        this.log = log;
    }

    private MonitorUtil(IEcpLog log, long start) {
        this.log = log;
        this.start = start;
    }

    private MonitorUtil(Class<?> clazz, String methodName) {
        this.clazz = clazz;
        this.methodName = methodName;
        this.start = System.currentTimeMillis();
    }

    public static MonitorUtil getInstance(IEcpLog log) {
        return new MonitorUtil(log, System.currentTimeMillis());
    }

    public static MonitorUtil getInstance(Class<?> clazz, String methodName) {
        return new MonitorUtil(clazz, methodName);
    }

    public long getStartTime() {
        long start = System.currentTimeMillis();
        return start;
    }

    public void monitor(String msg, long start) {
        if (StringUtil.isNullOrTrimEmptyString((String)msg)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"MonitorUtil_monitor_54", (String)"\u53c2\u6570\u9519\u8bef\uff1amsg\u4e3a\u7a7a\u3002"));
        }
        if (start <= 0L) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"MonitorUtil_monitor_57", (String)"\u53c2\u6570\u9519\u8bef\uff1astart\u5fc5\u987b\u5927\u4e8e0\u3002"));
        }
        long end = System.currentTimeMillis();
        long interval = end - start;
        this.log.info((Object)(">>>" + msg + "\uff1a" + interval + "\uff08\u6beb\u79d2\uff09"));
    }

    public void monitor(String msg) {
        if (StringUtil.isNullOrTrimEmptyString((String)msg)) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1amsg\u4e3a\u7a7a\u3002");
        }
        if (this.start <= 0L) {
            throw EmptyValueException.newInstance("\u8d77\u59cb\u65f6\u95f4\u672a\u8bbe\u7f6e\u3002");
        }
        long end = System.currentTimeMillis();
        long interval = end - this.start;
        this.log.info((Object)(">>>" + msg + "\uff1a" + interval + "\uff08\u6beb\u79d2\uff09"));
    }

    public void reset() {
        this.start = 0L;
    }

    private String getCurrentUserId() {
        LoginContext loginContext = (LoginContext)LoginContextUtil.getLoginContext();
        if (Objects.isNull(loginContext)) {
            return "sys";
        }
        return loginContext.getUserId();
    }
}

