/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.ecp.service.tool.StringUtil;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public final class OptionalUtil {
    private OptionalUtil() {
    }

    public static Optional<Integer> stringToInt(String str) {
        Objects.requireNonNull(str);
        try {
            return Optional.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> stringToLong(String str) {
        Objects.requireNonNull(str);
        try {
            return Optional.of(Long.parseLong(str));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<BigDecimal> stringToBigDecimal(String str) {
        Objects.requireNonNull(str);
        try {
            return Optional.of(new BigDecimal(str));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<BigDecimal> stringToBigDecimalNull2Zero(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return Optional.of(BigDecimal.ZERO);
        }
        try {
            return Optional.of(new BigDecimal(str));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

