/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.domain.bo.ParallelQueryBO;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.InvalidNumberRangeException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.SqlDebugUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public final class ParallelQueryUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ParallelQueryUtil.class);
    private final ISQLTemplate sqlTemplate;

    private ParallelQueryUtil(ISQLTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public static ParallelQueryUtil newInstance(ISQLTemplate sqlTemplate) {
        return new ParallelQueryUtil(sqlTemplate);
    }

    public void execute(List<ParallelQueryBO> list) {
        if (BlockCollectionUtil.isEmpty(list)) {
            String msg = EcpI18nUtil.localizedString((String)"ParallelQueryUtil_execute_62", (String)"\u53c2\u6570\u9519\u8bef\uff1alist\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (list.size() > 10) {
            String msg = EcpI18nUtil.localizedString((String)"ParallelQueryUtil_execute_66", (String)"\u5e76\u53d1\u67e5\u8be2\u6700\u591a\u652f\u6301\u4e00\u6b2110\u4e2a\u7ebf\u7a0b\u3002size=") + list.size();
            throw new InvalidNumberRangeException("ABC.0007", msg);
        }
        final CountDownLatch latch = new CountDownLatch(list.size());
        for (final ParallelQueryBO bo : list) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Object result = ParallelQueryUtil.this.findResult(bo);
                        bo.setResult(result);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Object findResult(ParallelQueryBO bo) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u5e76\u53d1\u6267\u884csql:" + SqlDebugUtil.sqlWithValue(bo.getSql(), bo.getParam())));
        }
        List result = this.sqlTemplate.findBySQLWithoutRowNumLimit(bo.getSql(), bo.getParam(), bo.getTargetClass());
        return result;
    }
}

