/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.itextpdf.text.Document;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.ygsoft.abc.service.tool.BlockCodingUtil;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.tool.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.springframework.web.multipart.MultipartFile;

public class PdfConvertA4Utils {
    public static void main(String[] args) {
        System.out.println(PdfConvertA4Utils.isA4("D:/temp/YG2021CQ597\u7b51\u68a6\u76d2\u5b5011.pdf"));
    }

    public static File convert(File sourceFile) {
        if (PdfConvertA4Utils.isA4(sourceFile.getAbsolutePath())) {
            return sourceFile;
        }
        File tempDirectory = new File(BlockIOUtil.getTempPath());
        File tempFile = new File(tempDirectory, PdfConvertA4Utils.buildTempFileName());
        PdfConvertA4Utils.convert(sourceFile.getAbsolutePath(), tempFile.getAbsolutePath());
        return tempFile;
    }

    public static File convert(MultipartFile file) {
        File sourceFile = PdfConvertA4Utils.saveTempFile(file);
        if (PdfConvertA4Utils.isA4(sourceFile.getAbsolutePath())) {
            return sourceFile;
        }
        File tempDirectory = new File(BlockIOUtil.getTempPath());
        File tempFile = new File(tempDirectory, PdfConvertA4Utils.buildTempFileName());
        PdfConvertA4Utils.convert(sourceFile.getAbsolutePath(), tempFile.getAbsolutePath());
        FileUtil.delete((String)sourceFile.getPath());
        return tempFile;
    }

    /*
     * Exception decompiling
     */
    private static File saveTempFile(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String buildTempFileName() {
        String timeStr = BlockDateUtil.formatDate(new Date(), "yyyyMMddHHmmss");
        String randomStr = BlockCodingUtil.randomLetters(10);
        return timeStr + "_" + randomStr + ".pdf";
    }

    public static boolean isA4(String path) {
        try {
            PdfReader pdfReader = new PdfReader(path);
            PdfReader.unethicalreading = true;
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                Rectangle pageSize = pdfReader.getPageSize(i);
                float width = pageSize.getWidth();
                float height = pageSize.getHeight();
                if (height > width && PageSize.A4.getHeight() == height && PageSize.A4.getWidth() == width || height < width && PageSize.A4.getHeight() == width && PageSize.A4.getWidth() == height) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new EcpRuntimeException("ABC.0014", "\u8bfb\u53d6PDF\u6587\u4ef6\u5f02\u5e38", (Throwable)ex, new Object[0]);
        }
    }

    public static void convert(String source, String target) {
        try {
            PdfReader pdfReader = new PdfReader(source);
            PdfReader.unethicalreading = true;
            Document doc = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(target));
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                float heightScale;
                float widthScale;
                PdfImportedPage page = writer.getImportedPage(pdfReader, i);
                float width = page.getWidth();
                float height = page.getHeight();
                if (height > width) {
                    doc.setPageSize(PageSize.A4);
                    doc.newPage();
                    widthScale = PdfConvertA4Utils.getWidthScale(width);
                    heightScale = PdfConvertA4Utils.getHeightScale(height);
                    cb.addTemplate((PdfTemplate)page, widthScale, 0.0f, 0.0f, heightScale, 0.0f, 0.0f);
                    continue;
                }
                doc.setPageSize(new Rectangle(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
                doc.newPage();
                widthScale = PdfConvertA4Utils.getWidthScale(height);
                heightScale = PdfConvertA4Utils.getHeightScale(width);
                cb.addTemplate((PdfTemplate)page, widthScale, 0.0f, 0.0f, heightScale, 0.0f, 0.0f);
            }
            doc.close();
        }
        catch (Exception ex) {
            throw new EcpRuntimeException("ABC.0014", "PDF\u8f6c\u6362\u4e3aA4\u5927\u5c0f\u5f02\u5e38\u3002", (Throwable)ex, new Object[0]);
        }
    }

    private static float getWidthScale(float width) {
        float scale = PageSize.A4.getWidth() / width;
        return scale;
    }

    private static float getHeightScale(float height) {
        float scale = PageSize.A4.getHeight() / height;
        return scale;
    }
}

