/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcIllegalArgumentException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class PreconditionUtil {
    private PreconditionUtil() {
    }

    public static void checkArgument(boolean expression, String errMsg) {
        PreconditionUtil.checkEmpty(errMsg);
        if (!expression) {
            throw new AbcIllegalArgumentException("ABC.0030", errMsg);
        }
    }

    public static <T> T checkNotNull(T reference, String errMsg) {
        PreconditionUtil.checkEmpty(errMsg);
        if (null == reference) {
            throw new EmptyValueException("ABC.0001", errMsg);
        }
        return reference;
    }

    public static String checkNotTrimEmpty(String str, String errMsg) {
        PreconditionUtil.checkEmpty(errMsg);
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            throw new EmptyValueException("ABC.0001", errMsg);
        }
        return str;
    }

    public static void checkNotEmpty(Object obj, String errMsg) {
        Map map;
        Collection c;
        Object[] arr;
        PreconditionUtil.checkEmpty(errMsg);
        if (Objects.isNull(obj)) {
            throw EmptyValueException.newInstance(errMsg);
        }
        if (String.class.equals(obj.getClass())) {
            PreconditionUtil.checkNotTrimEmpty((String)obj, errMsg);
        } else if (obj.getClass().isArray() ? (arr = (Object[])obj).length == 0 : (obj instanceof Collection ? (c = (Collection)obj).isEmpty() : obj instanceof Map && (map = (Map)obj).isEmpty())) {
            throw EmptyValueException.newInstance(errMsg);
        }
    }

    private static void checkEmpty(String errMsg) {
        if (StringUtil.isNullOrTrimEmptyString((String)errMsg)) {
            throw new EmptyValueException("ABC.0001", EcpI18nUtil.localizedString((String)"PreconditionUtil_checkEmpty_73", (String)"\u53c2\u6570errMsg\u4e3a\u7a7a\u3002"));
        }
    }
}

