/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.domain.vo.ProcessVO;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.SystemUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.function.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ProcessManagerUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ProcessManagerUtil.class);

    private ProcessManagerUtil() {
    }

    public static int execShell(String scriptPath, String scriptArgs) {
        int n;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("--->scriptPath:" + scriptPath + "\uff0cscriptArgs:" + scriptArgs));
        }
        String cmd = scriptPath;
        if (!StringUtil.isNullOrTrimEmptyString((String)scriptArgs)) {
            cmd = scriptPath + " " + scriptArgs;
        }
        BufferedReader inputReader = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("--->cmd:" + cmd));
            }
            ProcessBuilder builder = new ProcessBuilder("/bin/chmod", "755", scriptPath);
            Process process = builder.start();
            process.waitFor();
            ProcessBuilder shbuilder = new ProcessBuilder("/bin/sh", "-c", cmd);
            Process ps = shbuilder.start();
            ProcessManagerUtil.asynReadErrorStream(ps);
            inputReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(process.getInputStream())));
            String str = null;
            while ((str = inputReader.readLine()) != null) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("--->ProcessInputStream:" + str));
            }
            n = ps.waitFor();
        }
        catch (Exception e) {
            try {
                throw AbcServiceException.newInstance("\u8c03\u7528Shell\u5931\u8d25\u3002", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(inputReader);
                throw throwable;
            }
        }
        BlockIOUtil.close(inputReader);
        return n;
    }

    public static void kill(String pid) {
        PreconditionUtil.checkNotTrimEmpty(pid, "\u53c2\u6570\u9519\u8bef\uff1apid\u4e3a\u7a7a\u3002");
        try {
            if (SystemUtil.getOSType().isWindows()) {
                Runtime.getRuntime().exec("taskkill /F /PID " + pid);
            } else {
                Runtime.getRuntime().exec("kill -9 " + pid);
            }
        }
        catch (Exception e) {
            throw AbcServiceException.newInstance("\u5173\u95ed\u8fdb\u7a0b\u5931\u8d25\u3002", e);
        }
    }

    public static List<ProcessVO> taskList(String prefix) {
        PreconditionUtil.checkNotTrimEmpty(prefix, "\u53c2\u6570\u9519\u8bef\uff1aprefix\u4e3a\u7a7a\u3002");
        ArrayList<ProcessVO> list = new ArrayList<ProcessVO>();
        BufferedReader inputReader = null;
        try {
            ProcessBuilder processBuilder = null;
            processBuilder = SystemUtil.getOSType().isWindows() ? new ProcessBuilder("tasklist") : new ProcessBuilder("/bin/bash", "-c", "ps -ef");
            Process process = processBuilder.start();
            ProcessManagerUtil.asynReadErrorStream(process);
            inputReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(process.getInputStream())));
            ArrayList<String> lines = new ArrayList<String>();
            String str = null;
            while ((str = inputReader.readLine()) != null) {
                lines.add(str);
            }
            for (int i = 0; i < lines.size(); ++i) {
                ProcessVO processVO;
                String line = (String)lines.get(i);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("--->line:" + line));
                }
                if (Objects.isNull((Object)(processVO = ProcessManagerUtil.buildProcessVO(line, prefix)))) continue;
                list.add(processVO);
            }
        }
        catch (Exception e) {
            try {
                throw AbcServiceException.newInstance("\u67e5\u8be2\u8fdb\u7a0b\u4fe1\u606f\u5931\u8d25\u3002", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(inputReader);
                throw throwable;
            }
        }
        BlockIOUtil.close(inputReader);
        return list;
    }

    private static void asynReadErrorStream(Process process) {
        CompletableFuture.runAsync(() -> ProcessManagerUtil.readErrorStream(process), CommonUtil.getThreadPoolExecutor());
    }

    private static void readErrorStream(Process process) {
        BufferedReader errorReader = null;
        try {
            errorReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(process.getErrorStream())));
            String str = null;
            while ((str = errorReader.readLine()) != null) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("***>ErrorStream:" + str));
            }
        }
        catch (Exception e) {
            try {
                throw AbcServiceException.newInstance("\u8bfb\u53d6ErrorStream\u5931\u8d25\u3002", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(errorReader);
                throw throwable;
            }
        }
        BlockIOUtil.close(errorReader);
    }

    private static ProcessVO buildProcessVO(String line, String prefix) {
        if (SystemUtil.getOSType().isWindows()) {
            if (line.length() < 35) {
                return null;
            }
            String processName = line.substring(0, 25).trim();
            String pid = line.substring(25, 35).trim();
            if (processName.startsWith(prefix)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("--->pid=" + pid + ",processName=" + processName));
                }
                return ProcessVO.newInstance(processName, pid);
            }
            return null;
        }
        if (line.contains(prefix)) {
            String[] inf = line.split("\\s+");
            String processName = inf[inf.length - 1];
            String pid = inf[1];
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("--->pid=" + pid + ",processName=" + processName));
            }
            return ProcessVO.newInstance(processName, pid);
        }
        return null;
    }

    public static void main(String[] args) {
        ProcessManagerUtil.taskList("chrome");
    }
}

