/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.common.types.EcpStorageType;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.PatternException;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.types.SystemEnum;
import com.ygsoft.abc.service.types.SystemStateEnum;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class PropertyConfigUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(PropertyConfigUtil.class);
    private static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    public static final String APPID_KEY = "cache.tenant.appid";
    public static final String ECP_STORAGE_TYPE_KEY = "ecp.default.storage";
    public static final String RUNTYPE_KEY = "abc.runtype";
    public static final String RUMTIME_ENVIRONMENT_KEY = "abc.runtime.environment";
    public static final String SYSTEM_KEY = "abc.system";
    public static final String SYSTEM_STATE_KEY = "abc.system.state";
    public static final String DB_TYPE_KEY = "abc.database.type";
    public static final String FOURA_TYPE_KEY = "abc.4a.type";
    public static final String LOGIN_URL_KEY = "abc.login.url";
    public static final String UPCHAIN_4A_KEY = "abc.4a.upchain.active";
    public static final String UPCHAIN_KEY = "abc.upchain.switch";
    public static final String AUTH_AGAIN_KEY = "abc.auth.again";
    public static final String DEBUG_KEY = "abc.debug.switch";
    public static final String METHOD_TRACE_KEY = "abc.method.trace";
    public static final String REST_TRACE_KEY = "abc.rest.trace";
    public static final String UNIT_TEST_KEY = "abc.unit.test";
    public static final String TENANT_ONLY_ONE_KEY = "abc.4a.tenant.onlyone";
    public static final String ORG_ADD_WITH_ADMIN_KEY = "abc.4a.org.add_with_admin";
    public static final String ORG_ADD_WITH_APPROVE_KEY = "abc.4a.org.add_with_approve";
    public static final String ORG_BUSINESSNO_CHECK_KEY = "abc.4a.org.businessno.check";
    public static final String ORG_ADD_ADMIN_ROLE_KEY = "abc.4a.org.add_admin_role";
    public static final String TENANT_USER_WITH_ORG_ADMIN = "abc.4a.tenant_user_with_org_admin";
    public static final String USER_CARDID_CHECK_KEY = "abc.4a.user.cardid.check";
    public static final String USER_CARDID_REQUIRED_KEY = "abc.4a.user.cardid.required";
    public static final String USER_MOVETEL_CHECK_KEY = "abc.4a.user.movetel.check";
    public static final String USER_MOVETEL_REQUIRED_KEY = "abc.4a.user.movetel.required";
    public static final String ENCODE_USER_KEY_INFORMATION = "abc.4a.user.encode.key.information";
    public static final String ADD_AND_APPROVED_KEY = "abc.4a.add_and_approved";
    public static final String ROLE_MODEL_KEY = "abc.4a.role_model";
    public static final String ROLE_REPEAT_CHECK_KEY = "abc.4a.role.repeat.check";
    public static final String SPECIAL_CHAR_KEY = "abc.intercept.special";
    public static final String SENSITIVE_WORD_KEY = "abc.intercept.sensitive";
    public static final String SENSITIVEINFO_DESENS_KEY = "abc.sensitiveInfo.desens";
    public static final String URL_PERMISSION_KEY = "abc.url.permission";
    public static final String VIP_ADDRESS_KEY = "server.vipaddress";
    public static final String WEB_VIP_ADDRESS_KEY = "abc.web.vip_address";
    public static final String ENTIRE_MAPP_KEY = "abc.entire.mapp";
    public static final String AUDIT_LOG_KEY = "abc.auditlog.active";
    public static final String LARGE_OBJECT_KEY = "abc.db.largeobject";
    public static final String REDIS_SERVER_KEY = "abc.redis.server.url";
    public static final String REDIS_PORT_KEY = "abc.redis.server.port";
    public static final String REDIS_DBINDEX_KEY = "abc.redis.server.dbindex";
    public static final String CHAIN_APPNAME_KEY = "abc.chaincode.appName";
    public static final String CHAIN_APPID_KEY = "abc.chaincode.appId";
    public static final String CHAIN_APPSECRET_KEY = "abc.chaincode.appSecret";
    public static final String CHAIN_TOKEN_EXPIRE_KEY = "abc.chaincode.tokenExpire";
    public static final String CHAIN_SERVER_KEY = "abc.chaincode.server";
    public static final String CHAIN_PORT_KEY = "abc.chaincode.port";
    public static final String CHAIN_URL_KEY = "abc.chaincode.url";
    public static final String CHAIN_NAME_KEY = "abc.chaincode.name";
    public static final String CHAIN_VERSION_KEY = "abc.chaincode.version";
    public static final String CHAIN_CHANNEL_NAME_KEY = "abc.chaincode.channelName";
    public static final String CHAIN_ORG_NUMBER_KEY = "abc.upchain.orgnumber";
    public static final String CHAIN_NODE_NUMBER_KEY = "abc.upchain.nodenumber";
    public static final String UMC_INTEGRATION_KEY = "abc.4a.integration";
    public static final String USER_MENU_EXPIRE_KEY = "abc.4a.menu.expire";
    public static final String USER_MENU_CHECK_KEY = "abc.4a.menu.check";
    public static final String UMC_VERSION_KEY = "abc.umc.version";
    public static final String AUDIT_ABLE_KEY = "abc.audit.enable";
    public static final String STRESS_TEST_KEY = "abc.stress.test";
    public static final String INTERCEPT_SENSITIVE_IMAGE = "abc.intercept.sensitive.image";
    public static final String SENSITIVE_WORD_KEY_ENABLE = "abc.intercept.sensitive.enable";
    public static final String SECURITY_SWITCH_KEY = "abc.security.switch";
    public static final String FILE_MAX_SIZE_KEY = "abc.file.max_size";
    public static final String ADMIN_USE_BUSENESSNO_KEY = "abc.4a.admin.use_businessno";
    public static final String ADMIN_ROLE = "abc.4a.admin.role";
    public static final String SMS_ACTIVE_KEY = "sms.active";
    public static final String CFCA_CERTIFICATE_TYPE = "abc.cfca.certificate.type";
    public static final String EXCEL_SPECIALCHAR_REPLACEEMPTY_KEY = "abc.excel.specialchar.replaceempty";
    public static final String FILE_MAX_SIZE = "100M";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String LOCAL_SNOWFLAKEID = "local";
    public static final String ON = "on";
    public static final String OFF = "off";
    public static final String RUNTYPE_PRODUCT = "0";
    public static final String UMC_VERSION_1X = "1";
    public static final String UMC_VERSION_2X = "2";
    private static final String CHAIN_REQUEST_URL_PATTERN = "%s/chainApi/%s/%s";
    private static final String TRANSACTION_BY_TXID_URL_PATTERN = "%s/channelApi/getTransactionByTxId?channelName=%s&transactionId=%s";
    private static final String BLOCK_CHAIN_INFO_URL_PATTERN = "%s/channelApi/getBlockChainInfo?channelName=%s";
    private static final String CHAIN_TRANS_TOTAL_NUMBER_PATTERN = "%s/channelApi/getTransactionTotalNum";
    private static final String CHAIN_INSTOCK_HISTORY_PATTERN = "%s/channelApi/%s/%s/instock/getEntityListByGid?gid=%s";
    private static final String LATEST_CHAIN_REQUEST_URL_PATTERN = "%s/contract/mapp/rest/assets/chainApi/%s/%s";
    private static final String LATEST_TRANSACTION_BY_TXID_URL_PATTERN = "%s/contract/mapp/rest/assets/query/channelApi/getTransactionByTxId?channelName=%s&transactionId=%s";
    private static final String LATEST_BLOCK_CHAIN_INFO_URL_PATTERN = "%s/contract/mapp/rest/assets/query/channelApi/getBlockChainInfo?channelName=%s";
    private static final String LATEST_CHAIN_TRANS_TOTAL_NUMBER_PATTERN = "%s/contract/mapp/rest/assets/query/transactionStatisticsApi/getTransactionTotalNum";

    private PropertyConfigUtil() {
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void setProperty(String key, String value) {
        PreconditionUtil.checkNotTrimEmpty(key, "\u53c2\u6570key\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(value, "\u53c2\u6570value\u4e3a\u7a7a\u3002");
        CACHE.put(key, value);
        System.setProperty(key, value);
    }

    public static String getProperty(String key) {
        if (StringUtil.isNullOrTrimEmptyString((String)key)) {
            String msg = EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getProperty_208", (String)"\u53c2\u6570key\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        String value = System.getProperty(key);
        if (!Objects.isNull(value)) {
            CACHE.put(key, value);
        }
        return value;
    }

    public static String getStrictProperty(String key) {
        if (StringUtil.isNullOrTrimEmptyString((String)key)) {
            String msg = EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getStrictProperty_236", (String)"\u53c2\u6570key\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        String value = System.getProperty(key);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            String i18nKey = "PropertyConfigUtil_getStrictProperty_245";
            String localMsg = "\u672a\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u5728application.properties\u4e2d\u914d\u7f6e(%s)\u53c2\u6570";
            String msg = String.format(EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getStrictProperty_245", (String)"\u672a\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u5728application.properties\u4e2d\u914d\u7f6e(%s)\u53c2\u6570"), key);
            throw new EmptyValueException("ABC.0001", msg);
        }
        CACHE.put(key, value);
        return value;
    }

    public static String getAppId() {
        return "-1";
    }

    public static boolean isTrue(String val) {
        return TRUE.equalsIgnoreCase(val);
    }

    public static boolean isExtendUMC() {
        String value = PropertyConfigUtil.getProperty(UMC_INTEGRATION_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return "extend".equals(value);
    }

    public static String getRunType() {
        String runType = PropertyConfigUtil.getProperty(RUNTYPE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)runType)) {
            return RUNTYPE_PRODUCT;
        }
        return runType;
    }

    public static boolean isDevelopEnvironment() {
        String value = PropertyConfigUtil.getProperty(RUMTIME_ENVIRONMENT_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return "dev".equalsIgnoreCase(value);
    }

    public static boolean isProductEnvironment() {
        String value = PropertyConfigUtil.getProperty(RUMTIME_ENVIRONMENT_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return "prod".equalsIgnoreCase(value);
    }

    @Deprecated
    public static SystemEnum getSystem() {
        String value = PropertyConfigUtil.getStrictProperty(SYSTEM_KEY);
        return SystemEnum.values()[Integer.valueOf(value)];
    }

    public static SystemStateEnum getSystemState() {
        String value = PropertyConfigUtil.getProperty(SYSTEM_STATE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return SystemStateEnum.RUNNING;
        }
        if (OFF.equalsIgnoreCase(value)) {
            return SystemStateEnum.SHUTDOWN;
        }
        return SystemStateEnum.RUNNING;
    }

    public static DatabaseType getDatabaseType() {
        String value = PropertyConfigUtil.getProperty(DB_TYPE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return DatabaseType.Oracle;
        }
        return DatabaseType.values()[Integer.valueOf(value)];
    }

    public static String get4AType() {
        return PropertyConfigUtil.getStrictProperty(FOURA_TYPE_KEY);
    }

    public static String getLoginUrl() {
        return PropertyConfigUtil.getStrictProperty(LOGIN_URL_KEY);
    }

    public static boolean is4AUpchain() {
        String value = PropertyConfigUtil.getProperty(UPCHAIN_4A_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isUrlPermission() {
        String value = PropertyConfigUtil.getProperty(URL_PERMISSION_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static String getVipAddress() {
        return PropertyConfigUtil.getStrictProperty(VIP_ADDRESS_KEY);
    }

    public static String getWebVipAddress() {
        return PropertyConfigUtil.getStrictProperty(WEB_VIP_ADDRESS_KEY);
    }

    public static boolean isEntireMapp() {
        String value = PropertyConfigUtil.getProperty(ENTIRE_MAPP_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isUpchain() {
        String value = PropertyConfigUtil.getProperty(UPCHAIN_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isAuthAgain() {
        String value = PropertyConfigUtil.getProperty(AUTH_AGAIN_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isDebug() {
        String value = PropertyConfigUtil.getProperty(DEBUG_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isTraceMethod() {
        String value = PropertyConfigUtil.getProperty(METHOD_TRACE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isTraceRest() {
        String value = PropertyConfigUtil.getProperty(REST_TRACE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isUnitTest() {
        String value = PropertyConfigUtil.getProperty(UNIT_TEST_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equalsIgnoreCase(value);
    }

    public static boolean isUmcVersion1X() {
        String value = PropertyConfigUtil.getProperty(UMC_VERSION_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return UMC_VERSION_1X.equals(value);
    }

    public static boolean isTenantOnlyOne() {
        String value = PropertyConfigUtil.getProperty(TENANT_ONLY_ONE_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isOrgAddWithAdmin() {
        String value = PropertyConfigUtil.getProperty(ORG_ADD_WITH_ADMIN_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isOrgAddWithApprove() {
        String value = PropertyConfigUtil.getProperty(ORG_ADD_WITH_APPROVE_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isOrgBusinessNoCheck() {
        String value = PropertyConfigUtil.getProperty(ORG_BUSINESSNO_CHECK_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isTenantUserWithOrgAdmin() {
        String value = PropertyConfigUtil.getProperty(TENANT_USER_WITH_ORG_ADMIN);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isUserCardIdCheck() {
        String value = PropertyConfigUtil.getProperty(USER_CARDID_CHECK_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isSensitiveInfoDesens() {
        String value = PropertyConfigUtil.getProperty(SENSITIVEINFO_DESENS_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isUserCardIdRequired() {
        String value = PropertyConfigUtil.getProperty(USER_CARDID_REQUIRED_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isUserMovetelRequired() {
        String value = PropertyConfigUtil.getProperty(USER_MOVETEL_REQUIRED_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isUserMenuCheck() {
        String value = PropertyConfigUtil.getProperty(USER_MENU_CHECK_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static int getMenuExpire() {
        String value = PropertyConfigUtil.getProperty(USER_MENU_EXPIRE_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            try {
                String unit;
                String val = value.trim();
                int num = Integer.valueOf(val.substring(0, val.length() - 1));
                switch (unit = val.substring(val.length() - 1)) {
                    case "m": {
                        return num * 60;
                    }
                    case "h": {
                        return num * 60 * 60;
                    }
                    case "d": {
                        return num * 24 * 60 * 60;
                    }
                }
                throw new PatternException("ABC.0039", String.format(EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getMenuExpire_430", (String)"abc.4a.menu.expire\u914d\u7f6e\u9519\u8bef\uff1a%s"), value));
            }
            catch (Exception e) {
                String msg = String.format(EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getMenuExpire_438", (String)"abc.4a.menu.expire\u914d\u7f6e\u9519\u8bef\uff1a%s"), value);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)msg);
                }
                throw new PatternException("ABC.0039", msg);
            }
        }
        return 1800;
    }

    public static boolean isUserMovetelCheck() {
        String value = PropertyConfigUtil.getProperty(USER_MOVETEL_CHECK_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return true;
    }

    public static boolean isEncodeUserKeyInformation() {
        String value = PropertyConfigUtil.getProperty(ENCODE_USER_KEY_INFORMATION);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isInterceptSpecial() {
        String value = PropertyConfigUtil.getProperty(SPECIAL_CHAR_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return TRUE.equals(value);
    }

    public static boolean isInterceptSensitive() {
        String value = PropertyConfigUtil.getProperty(SENSITIVE_WORD_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return TRUE.equals(value);
    }

    public static boolean isActiveAuditLog() {
        String value = PropertyConfigUtil.getProperty(AUDIT_LOG_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return TRUE.equals(value);
    }

    public static boolean isAllowLargeObject() {
        String value = PropertyConfigUtil.getProperty(LARGE_OBJECT_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equals(value);
    }

    public static boolean isAddAndApproved() {
        String value = PropertyConfigUtil.getProperty(ADD_AND_APPROVED_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return PropertyConfigUtil.isTrue(value);
    }

    public static String getRedisIP() {
        return PropertyConfigUtil.getStrictProperty(REDIS_SERVER_KEY);
    }

    public static int getRedisPort() {
        String value = PropertyConfigUtil.getStrictProperty(REDIS_PORT_KEY);
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getRedisPort_513", (String)"redis\u7aef\u53e3\u914d\u7f6e(%s)\uff0c\u975e\u6cd5\u6570\u5b57(%s)\u3002"), REDIS_PORT_KEY, value);
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static int getRedisDBIndex() {
        String value = PropertyConfigUtil.getStrictProperty(REDIS_DBINDEX_KEY);
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getRedisDBIndex_527", (String)"redis\u6570\u636e\u5e93index\u914d\u7f6e(%s)\uff0c\u975e\u6cd5\u6570\u5b57(%s)\u3002"), REDIS_DBINDEX_KEY, value);
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static final String getUpchainOrgNum() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_ORG_NUMBER_KEY);
    }

    public static final String getUpchainNodeNum() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_NODE_NUMBER_KEY);
    }

    public static boolean getAuditableKey() {
        String value = PropertyConfigUtil.getProperty(AUDIT_ABLE_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static String getFileMaxSize() {
        String value = PropertyConfigUtil.getProperty(FILE_MAX_SIZE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return FILE_MAX_SIZE;
        }
        return value;
    }

    public static boolean isStressTest() {
        String value = PropertyConfigUtil.getProperty(STRESS_TEST_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return TRUE.equals(value);
    }

    public static boolean isInterceptSensitiveImageTest() {
        String value = PropertyConfigUtil.getProperty(INTERCEPT_SENSITIVE_IMAGE);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return TRUE.equals(value);
    }

    public static boolean isInterceptSensitiveWordTest() {
        String value = PropertyConfigUtil.getProperty(SENSITIVE_WORD_KEY_ENABLE);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return TRUE.equals(value);
    }

    public static boolean isOpenSecurity() {
        String value = PropertyConfigUtil.getProperty(SECURITY_SWITCH_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return false;
        }
        return ON.equals(value);
    }

    public static String getChainAppName() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_APPNAME_KEY);
    }

    public static String getChainAppId() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_APPID_KEY);
    }

    public static String getChainAppSecret() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_APPSECRET_KEY);
    }

    public static String getChainChannelName() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_CHANNEL_NAME_KEY);
    }

    public static String getChainName() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_NAME_KEY);
    }

    public static String getChainUrl() {
        if (CACHE.containsKey(CHAIN_URL_KEY)) {
            return CACHE.get(CHAIN_URL_KEY);
        }
        String url = PropertyConfigUtil.getProperty(CHAIN_URL_KEY);
        if (StringUtil.isNotEmptyString((String)url)) {
            CACHE.put(CHAIN_URL_KEY, url);
            return url;
        }
        String server = PropertyConfigUtil.getStrictProperty(CHAIN_SERVER_KEY);
        String port = PropertyConfigUtil.getStrictProperty(CHAIN_PORT_KEY);
        String joinUrl = String.format("%s:%s", server, port);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801url=%s", joinUrl);
            LOG.info((Object)msg);
        }
        CACHE.put(CHAIN_URL_KEY, joinUrl);
        return joinUrl;
    }

    public static String getChainRequestUrl() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String chainName = PropertyConfigUtil.getChainName();
        String url = String.format(CHAIN_REQUEST_URL_PATTERN, chainUrl, channelName, chainName);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801requestUrl=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getLatestChainRequestUrl() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String chainName = PropertyConfigUtil.getChainName();
        String url = String.format(LATEST_CHAIN_REQUEST_URL_PATTERN, chainUrl, channelName, chainName);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801requestUrl=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getChainUrlOfTransactionByTxId(String txid) {
        if (StringUtil.isNullOrTrimEmptyString((String)txid)) {
            String msg = EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getChainUrlOfTransactionByTxId_626", (String)"\u53c2\u6570\u9519\u8bef\uff1atxid\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String url = String.format(TRANSACTION_BY_TXID_URL_PATTERN, chainUrl, channelName, txid);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getTransactionByTxId=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getLatestChainUrlOfTransactionByTxId(String txid) {
        if (StringUtil.isNullOrTrimEmptyString((String)txid)) {
            String msg = EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getChainUrlOfTransactionByTxId_626", (String)"\u53c2\u6570\u9519\u8bef\uff1atxid\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String url = String.format(LATEST_TRANSACTION_BY_TXID_URL_PATTERN, chainUrl, channelName, txid);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getTransactionByTxId=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getChainUrlOfBlockTotalHeight() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String url = String.format(BLOCK_CHAIN_INFO_URL_PATTERN, chainUrl, channelName);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getBlockChainInfo=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getLatestChainUrlOfBlockTotalHeight() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String url = String.format(LATEST_BLOCK_CHAIN_INFO_URL_PATTERN, chainUrl, channelName);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getBlockChainInfo=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getChainUrlOfTransactionTotalNumber() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String url = String.format(CHAIN_TRANS_TOTAL_NUMBER_PATTERN, chainUrl);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getChainUrlOfTransactionTotalNumber=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getLatestChainUrlOfTransactionTotalNumber() {
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String url = String.format(LATEST_CHAIN_TRANS_TOTAL_NUMBER_PATTERN, chainUrl);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getChainUrlOfTransactionTotalNumber=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static String getChainUrlOfInstockHistory(String gid) {
        if (StringUtil.isNullOrTrimEmptyString((String)gid)) {
            String msg = EcpI18nUtil.localizedString((String)"PropertyConfigUtil_getChainUrlOfTransactionByTxId_677", (String)"\u53c2\u6570\u9519\u8bef\uff1agid\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String chainUrl = PropertyConfigUtil.getChainUrl();
        String channelName = PropertyConfigUtil.getChainChannelName();
        String chainName = PropertyConfigUtil.getChainName();
        String url = String.format(CHAIN_INSTOCK_HISTORY_PATTERN, chainUrl, channelName, chainName, gid);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u94fe\u7801getChainUrlOfInstockHistory=%s", url);
            LOG.info((Object)msg);
        }
        return url;
    }

    public static boolean isAdminUseBusinessNo() {
        String value = PropertyConfigUtil.getProperty(ADMIN_USE_BUSENESSNO_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static String getChainVersion() {
        return PropertyConfigUtil.getStrictProperty(CHAIN_VERSION_KEY);
    }

    public static boolean isVersion3Chaincode() {
        String chainVersion = PropertyConfigUtil.getChainVersion();
        return !StringUtil.isNullOrTrimEmptyString((String)chainVersion) && "3".equals(chainVersion);
    }

    public static String getDefaultAdminRole() {
        return PropertyConfigUtil.getProperty(ADMIN_ROLE);
    }

    public static boolean isOrgAddAdminRole() {
        String value = PropertyConfigUtil.getProperty(ORG_ADD_ADMIN_ROLE_KEY);
        if (!StringUtil.isNullOrTrimEmptyString((String)value)) {
            return TRUE.equals(value);
        }
        return false;
    }

    public static boolean isSMSActive() {
        String value = PropertyConfigUtil.getProperty(SMS_ACTIVE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return TRUE.equals(value);
    }

    public static EcpStorageType getStorageType() {
        String value = PropertyConfigUtil.getProperty(ECP_STORAGE_TYPE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return EcpStorageType.DB;
        }
        return EcpStorageType.parse(value);
    }

    public static String getCfcaCertificateType() {
        return PropertyConfigUtil.getProperty(CFCA_CERTIFICATE_TYPE);
    }

    public static int getChainTokenExpire() {
        String value = PropertyConfigUtil.getProperty(CHAIN_TOKEN_EXPIRE_KEY);
        if (StringUtil.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        return 3;
    }

    public static boolean isRoleRepeatCheck() {
        String value = PropertyConfigUtil.getProperty(ROLE_REPEAT_CHECK_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return TRUE.equals(value);
    }
}

