/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.RestRuntimeException;
import com.ygsoft.alibaba.fastjson.JSONArray;
import com.ygsoft.alibaba.fastjson.JSONObject;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class RestfulUtil
implements IEcpToolLogic {
    public static <T> List<T> getRestModelFromPage(String restData, Type javaType) {
        RestfulUtil.doRestNull(restData);
        RestfulUtil.doRestError(restData);
        String dealedJson = RestfulUtil.removeJcls(restData);
        JSONObject jsonRest = JSONObject.parseObject((String)dealedJson);
        JSONArray contentArr = jsonRest.getJSONArray("content");
        ArrayList<Object> targetBOList = new ArrayList<Object>();
        if (contentArr != null && contentArr.size() > 0) {
            for (int i = 0; i < contentArr.size(); ++i) {
                targetBOList.add(JSONUtil.fromJsonString((String)contentArr.getString(i), (Type)javaType));
            }
        }
        return targetBOList;
    }

    public static <T> List<T> getRestModelObject(String restData, Type javaType) {
        RestfulUtil.doRestNull(restData);
        RestfulUtil.doRestError(restData);
        String dealedJson = RestfulUtil.removeJcls(restData);
        JSONArray contentArr = JSONObject.parseArray((String)dealedJson);
        ArrayList<Object> targetBOList = new ArrayList<Object>();
        if (contentArr != null && contentArr.size() > 0) {
            for (int i = 0; i < contentArr.size(); ++i) {
                targetBOList.add(JSONUtil.fromJsonString((String)contentArr.getString(i), (Type)javaType));
            }
        }
        return targetBOList;
    }

    public static <T> T getRestModel(String restData, Class<T> javaType) {
        RestfulUtil.doRestNull(restData);
        RestfulUtil.doRestError(restData);
        String dealedJson = RestfulUtil.removeJcls(restData);
        return (T)JSONUtil.fromJsonString((String)dealedJson, javaType);
    }

    public static Object getRestSimpleObject(String restData) {
        RestfulUtil.doRestNull(restData);
        RestfulUtil.doRestError(restData);
        return restData;
    }

    public static String getRestVoidObject(String restData) {
        RestfulUtil.doRestError(restData);
        return restData;
    }

    private static void doRestNull(String restData) {
        if (StringUtil.isEmptyString((String)restData)) {
            throw new RestRuntimeException("E0200.0001", "E0200.0001", EcpI18nUtil.localizedString((String)"RestfulUtil_doRestNull_103", (String)"REST\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002{0}"), restData);
        }
    }

    private static void doRestError(String restData) {
        if (StringUtil.isNotEmptyString((String)restData) && restData.indexOf("errCode") > 0) {
            throw new RestRuntimeException("E0200.0001", EcpI18nUtil.localizedString((String)"RestfulUtil_doRestError_113", (String)"REST\u670d\u52a1\u5185\u90e8\u5f02\u5e38\u3002{0}"), restData);
        }
    }

    private static String removeJcls(String restData) {
        if (restData.indexOf("\"jcls\"") > -1) {
            JSONObject jsonObj = JSONObject.parseObject((String)restData);
            if (jsonObj.containsKey((Object)"jcls")) {
                jsonObj.remove((Object)"jcls");
            }
            return JSONUtil.toJsonWithoutJcls((Object)jsonObj);
        }
        return restData;
    }
}

