/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.domain.bo.sensitiveWords.FilteredResult;
import com.ygsoft.abc.service.domain.bo.sensitiveWords.Node;
import com.ygsoft.abc.service.domain.bo.sensitiveWords.Word;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SensitiveWordUtil {
    private static final Logger LOG;
    private static final String SENSITIVE_WORDS_DICT = "/META-INF/sensitiveWord/sensitive-words.dict";
    private static final String POSITIVE_WORDS_DICT = "/META-INF/sensitiveWord/positive-words.dict";
    private static final char REPLACE_CHAR = '*';
    private static Node tree;
    private static Node positiveTree;
    private static Pattern p;

    private SensitiveWordUtil() {
    }

    public static String replaceSensitiveWords(String text) {
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return "";
        }
        FilteredResult result = SensitiveWordUtil.filterHtml(text, '*');
        return result.getFilteredContent();
    }

    public static String replaceSensitiveWords(String text, char replaceChar) {
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return "";
        }
        FilteredResult result = SensitiveWordUtil.filterHtml(text, replaceChar);
        return result.getFilteredContent();
    }

    public static boolean existsSensitiveWords(String text) {
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return false;
        }
        FilteredResult result = SensitiveWordUtil.filterHtml(text, '*');
        return result.getHasSensiviWords();
    }

    private static FilteredResult simpleFilter(String sentence, char replacement) {
        StringBuilder sb = new StringBuilder(sentence);
        List<Word> positiveWords = SensitiveWordUtil.simpleFilter2DictFindWords(sb, positiveTree);
        List<Word> sensitiveWords = SensitiveWordUtil.simpleFilter2DictFindWords(sb, tree);
        Iterator<Word> sIt = sensitiveWords.iterator();
        block0: while (sIt.hasNext()) {
            Word sWord = sIt.next();
            for (Word word : positiveWords) {
                if (word.getEndPos() >= sWord.getStartPos()) break;
            }
            for (Word word : positiveWords) {
                if (word.getStartPos() > sWord.getEndPos()) break;
                if (word.getStartPos() < sWord.getStartPos() && word.getEndPos() >= sWord.getStartPos() && word.getLevel() > sWord.getLevel()) {
                    sIt.remove();
                    continue block0;
                }
                if (word.getStartPos() <= sWord.getEndPos() && word.getEndPos() > sWord.getEndPos() && word.getLevel() > sWord.getLevel()) {
                    sIt.remove();
                    continue block0;
                }
                if (word.getStartPos() > sWord.getStartPos() || word.getEndPos() < sWord.getEndPos() || !(word.getLevel() > sWord.getLevel())) continue;
                sIt.remove();
                continue block0;
            }
        }
        Double maxLevel = 0.0;
        StringBuilder badWords = new StringBuilder();
        for (Word word : sensitiveWords) {
            badWords.append(word.getWord()).append(",");
            if (!(word.getLevel() > maxLevel)) continue;
            maxLevel = word.getLevel();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Word word : positiveWords) {
            stringBuilder.append(word.getWord()).append(",");
        }
        for (Word word : sensitiveWords) {
            for (int i = 0; i < word.getPos().length; ++i) {
                sb.replace(word.getPos()[i], word.getPos()[i] + 1, "" + replacement);
            }
        }
        FilteredResult filteredResult = new FilteredResult();
        filteredResult.setBadWords(badWords.toString());
        filteredResult.setGoodWords(stringBuilder.toString());
        filteredResult.setFilteredContent(sb.toString());
        filteredResult.setOriginalContent(sentence);
        filteredResult.setLevel(maxLevel);
        filteredResult.setHasSensiviWords(!sensitiveWords.isEmpty());
        return filteredResult;
    }

    private static FilteredResult filterTextWithPunctation(String originalString, char replacement) {
        return SensitiveWordUtil.filter(SensitiveWordUtil.filterPunctation(originalString), replacement);
    }

    private static FilteredResult filterHtml(String originalString, char replacement) {
        return SensitiveWordUtil.filter(SensitiveWordUtil.filterPunctationAndHtml(originalString), replacement);
    }

    private static char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private static List<Word> simpleFilter2DictFindWords(StringBuilder sentence, Node dictTree) {
        LinkedList<Word> foundWords = new LinkedList<Word>();
        Node node = dictTree;
        int start = 0;
        int end = 0;
        for (int i = 0; i < sentence.length(); ++i) {
            start = i;
            end = i;
            node = dictTree;
            Node lastFoundNode = null;
            for (int j = i; j < sentence.length() && (node = node.findChar(SensitiveWordUtil.toLowerCase(sentence.charAt(j)))) != null; ++j) {
                if (!node.getIsEnd()) continue;
                end = j;
                lastFoundNode = node;
            }
            if (end <= start) continue;
            int[] pos = new int[end - start + 1];
            for (int j = 0; j < pos.length; ++j) {
                pos[j] = start + j;
            }
            Word word = new Word();
            word.setPos(pos);
            word.setStartPos(start);
            word.setEndPos(end);
            word.setLevel(lastFoundNode.getLevel());
            word.setWord(lastFoundNode.getWord());
            foundWords.add(word);
        }
        return foundWords;
    }

    private static void insertWord(Node tree, String word, double level) {
        String lowerWord = word.toLowerCase();
        Node node = tree;
        for (int i = 0; i < lowerWord.length(); ++i) {
            node = node.addChar(lowerWord.charAt(i));
        }
        node.setIsEnd(true);
        node.setLevel(level);
        node.setWord(lowerWord);
    }

    private static boolean isPunctuationChar(String c) {
        Matcher m = p.matcher(c);
        return m.find();
    }

    private static PunctuationOrHtmlFilteredResult filterPunctation(String originalString) {
        StringBuilder filteredString = new StringBuilder();
        ArrayList<Integer> charOffsets = new ArrayList<Integer>();
        for (int i = 0; i < originalString.length(); ++i) {
            String c = String.valueOf(originalString.charAt(i));
            if (SensitiveWordUtil.isPunctuationChar(c)) continue;
            filteredString.append(c);
            charOffsets.add(i);
        }
        PunctuationOrHtmlFilteredResult result = new PunctuationOrHtmlFilteredResult();
        result.setOriginalString(originalString);
        result.setFilteredString(filteredString);
        result.setCharOffsets(charOffsets);
        return result;
    }

    private static PunctuationOrHtmlFilteredResult filterPunctationAndHtml(String originalString) {
        StringBuilder filteredString = new StringBuilder();
        ArrayList<Integer> charOffsets = new ArrayList<Integer>();
        int k = 0;
        for (int i = 0; i < originalString.length(); ++i) {
            String c = String.valueOf(originalString.charAt(i));
            if (originalString.charAt(i) == '<') {
                for (k = i + 1; k < originalString.length(); ++k) {
                    if (originalString.charAt(k) == '<') {
                        k = i;
                        break;
                    }
                    if (originalString.charAt(k) == '>') break;
                }
                i = k;
                continue;
            }
            if (SensitiveWordUtil.isPunctuationChar(c)) continue;
            filteredString.append(c);
            charOffsets.add(i);
        }
        PunctuationOrHtmlFilteredResult result = new PunctuationOrHtmlFilteredResult();
        result.setOriginalString(originalString);
        result.setFilteredString(filteredString);
        result.setCharOffsets(charOffsets);
        return result;
    }

    private static FilteredResult filter(PunctuationOrHtmlFilteredResult pohResult, char replacement) {
        StringBuilder sentence = pohResult.getFilteredString();
        StringBuilder sb = new StringBuilder(pohResult.getOriginalString());
        List<Integer> charOffsets = pohResult.getCharOffsets();
        List<Word> positiveWords = SensitiveWordUtil.simpleFilter2DictFindWords(sentence, positiveTree);
        List<Word> sensitiveWords = SensitiveWordUtil.simpleFilter2DictFindWords(sentence, tree);
        Iterator<Word> sIt = sensitiveWords.iterator();
        block0: while (sIt.hasNext()) {
            int i;
            Word pWord = null;
            Word sWord = sIt.next();
            for (i = 0; i < positiveWords.size() && (pWord = positiveWords.get(i)).getEndPos() < sWord.getStartPos(); ++i) {
            }
            for (i = 0; i < positiveWords.size() && (pWord = positiveWords.get(i)).getStartPos() <= sWord.getEndPos(); ++i) {
                if (pWord.getStartPos() < sWord.getStartPos() && pWord.getEndPos() >= sWord.getStartPos() && pWord.getLevel() > sWord.getLevel()) {
                    sIt.remove();
                    continue block0;
                }
                if (pWord.getStartPos() <= sWord.getEndPos() && pWord.getEndPos() > sWord.getEndPos() && pWord.getLevel() > sWord.getLevel()) {
                    sIt.remove();
                    continue block0;
                }
                if (pWord.getStartPos() > sWord.getStartPos() || pWord.getEndPos() < sWord.getEndPos() || !(pWord.getLevel() > sWord.getLevel())) continue;
                sIt.remove();
                continue block0;
            }
        }
        Double maxLevel = 0.0;
        StringBuilder badWords = new StringBuilder();
        for (Word word : sensitiveWords) {
            badWords.append(word.getWord()).append(",");
            if (!(word.getLevel() > maxLevel)) continue;
            maxLevel = word.getLevel();
        }
        StringBuilder goodWords = new StringBuilder();
        for (Word word : positiveWords) {
            goodWords.append(word.getWord()).append(",");
        }
        for (Word word : sensitiveWords) {
            for (int i = 0; i < word.getPos().length; ++i) {
                sb.replace(charOffsets.get(word.getPos()[i]), charOffsets.get(word.getPos()[i]) + 1, "" + replacement);
            }
        }
        FilteredResult filteredResult = new FilteredResult();
        filteredResult.setBadWords(badWords.toString());
        filteredResult.setGoodWords(goodWords.toString());
        filteredResult.setFilteredContent(sb.toString());
        filteredResult.setOriginalContent(pohResult.getOriginalString());
        filteredResult.setLevel(maxLevel);
        filteredResult.setHasSensiviWords(!sensitiveWords.isEmpty());
        return filteredResult;
    }

    static {
        block55: {
            block54: {
                LOG = LoggerFactory.getLogger(SensitiveWordUtil.class);
                tree = new Node();
                try (InputStream is = SensitiveWordUtil.class.getResourceAsStream(SENSITIVE_WORDS_DICT);
                     InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                    Properties prop = new Properties();
                    prop.load(reader);
                    Enumeration<?> en = prop.propertyNames();
                    while (en.hasMoreElements()) {
                        String word = (String)en.nextElement();
                        SensitiveWordUtil.insertWord(tree, word, Double.valueOf(prop.getProperty(word)));
                    }
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block54;
                    LOG.error(String.format("\u8bfb\u53d6\u654f\u611f\u8bcd\u5b57\u5178\u6587\u4ef6\u5f02\u5e38\uff1a%s", e.toString()));
                }
            }
            String regex = "[\\pP\\pZ\\pS\\pM\\pC]";
            p = Pattern.compile("[\\pP\\pZ\\pS\\pM\\pC]", 2);
            positiveTree = new Node();
            try (InputStream is = SensitiveWordUtil.class.getResourceAsStream(POSITIVE_WORDS_DICT);
                 InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                Properties prop = new Properties();
                prop.load(reader);
                Enumeration<?> en = prop.propertyNames();
                while (en.hasMoreElements()) {
                    String word = (String)en.nextElement();
                    SensitiveWordUtil.insertWord(positiveTree, word, Double.valueOf(prop.getProperty(word)));
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block55;
                LOG.error(String.format("\u8bfb\u53d6\u80af\u5b9a\u8bcd\u5b57\u5178\u6587\u4ef6\u5f02\u5e38\uff1a%s", e.toString()));
            }
        }
    }

    private static class PunctuationOrHtmlFilteredResult {
        private String originalString;
        private StringBuilder filteredString;
        private List<Integer> charOffsets;

        private PunctuationOrHtmlFilteredResult() {
        }

        public String getOriginalString() {
            return this.originalString;
        }

        public void setOriginalString(String newVal) {
            this.originalString = newVal;
        }

        public StringBuilder getFilteredString() {
            return this.filteredString;
        }

        public void setFilteredString(StringBuilder newVal) {
            this.filteredString = newVal;
        }

        public List<Integer> getCharOffsets() {
            return this.charOffsets;
        }

        public void setCharOffsets(List<Integer> newVal) {
            this.charOffsets = newVal;
        }
    }
}

