/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DBUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class SqlDebugUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SqlDebugUtil.class);
    private static final String SINGLE_QUOTES = "'";
    private static final String COMMA = ",";
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String ORACLE_TO_DATE = "TO_DATE('%s','YYYY-MM-DD HH24:MI:SS')";

    public static String sqlWithValue(String sql, Map<String, Object> param) {
        if (StringUtil.isNullOrTrimEmptyString((String)sql)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"SqlDebugUtil_sqlWithValue_59", (String)"\u4f20\u5165SQL\u9519\u8bef\uff0c\u4e3a\u7a7a\u3002"));
        }
        try {
            StringBuilder sb = new StringBuilder();
            Pattern p = Pattern.compile("\\:\\w+");
            Matcher m = p.matcher(sql);
            int index = 0;
            int start = 0;
            int end = 0;
            while (m.find()) {
                String paramKey = m.group().substring(1);
                start = m.start();
                end = m.end();
                if (start > index) {
                    sb.append(sql.subSequence(index, start));
                }
                if (param.get(paramKey) == null) {
                    LOG.warn((Object)("\n\u6839\u636e\u6b63\u5219\u8868\u8fbe\u5f0f\u627e\u5230\u7684KEY=" + paramKey + "\uff0c\u5728param\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684VALUE\u3002"));
                    sb.append(m.group());
                } else {
                    sb.append(SqlDebugUtil.transferSQLValue(param.get(paramKey)));
                }
                index = end;
            }
            if (index < sql.length()) {
                sb.append(sql.substring(index));
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n\u5f85\u8f6c\u6362\u7684SQL=" + sql + "\n\u7ed1\u5b9a\u53c2\u6570params=" + param), (Throwable)e);
            }
            return "\u8f6c\u6362SQL\u53d1\u751f\u9519\u8bef\u3002";
        }
    }

    private static Object transferSQLValue(Object paramValue) {
        if (paramValue.getClass().equals(String.class)) {
            return SqlDebugUtil.valueOfString((String)paramValue);
        }
        if (paramValue.getClass().equals(Date.class)) {
            return SqlDebugUtil.valueOfDate((Date)paramValue);
        }
        if (paramValue instanceof Object[]) {
            return SqlDebugUtil.valueOfArray((Object[])paramValue);
        }
        if (paramValue instanceof List) {
            return SqlDebugUtil.valueOfList((List)paramValue);
        }
        return paramValue;
    }

    static String valueOfString(String strValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(SINGLE_QUOTES);
        sb.append(StringEscapeUtils.escapeSql((String)strValue));
        sb.append(SINGLE_QUOTES);
        return sb.toString();
    }

    static String valueOfDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        StringBuilder sb = new StringBuilder();
        if (SqlDebugUtil.isOracle()) {
            String dateSql = String.format(ORACLE_TO_DATE, dateFormat.format(date));
            sb.append(dateSql);
        } else {
            sb.append(SINGLE_QUOTES + dateFormat.format(date) + SINGLE_QUOTES);
        }
        return sb.toString();
    }

    private static boolean isOracle() {
        return DBUtil.isOracle();
    }

    static String valueOfArray(Object[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (obj.getClass().equals(String.class)) {
                sb.append(SqlDebugUtil.valueOfString((String)obj));
            } else {
                sb.append(obj);
            }
            if (i == array.length - 1) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    static String valueOfList(List list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj.getClass().equals(String.class)) {
                sb.append(SqlDebugUtil.valueOfString((String)obj));
            } else {
                sb.append(obj);
            }
            if (i == list.size() - 1) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }
}

