/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.types;

import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.exception.CheckFailedException;
import java.util.Map;

public enum YesnoEnum {
    NO{

        @Override
        public boolean isNo() {
            return true;
        }
    }
    ,
    YES{

        @Override
        public boolean isYes() {
            return true;
        }
    };

    private static final Map<String, YesnoEnum> MAP;
    public static final String[] CAPTIONS;

    public static YesnoEnum parse(String str) {
        if (str == null) {
            return null;
        }
        YesnoEnum value = MAP.get(str);
        if (value == null) {
            throw CheckFailedException.newInstance("\u4e0d\u652f\u6301\u7684\u679a\u4e3e\u503c\u3002");
        }
        return value;
    }

    public boolean isNo() {
        return false;
    }

    public boolean isYes() {
        return false;
    }

    public Integer getId() {
        return this.ordinal();
    }

    public String getText() {
        int idx = this.ordinal();
        return CAPTIONS[idx];
    }

    static {
        MAP = ImmutableMap.of((Object)"0", (Object)((Object)NO), (Object)"1", (Object)((Object)YES));
        CAPTIONS = new String[]{"\u5426", "\u662f"};
    }
}

