/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateProxyContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.SESV1ValidateContainerExt;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.SESV4ValidateContainerExt;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.SignedDataValidateContainer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDValidateProxyContainer2
extends OFDValidateProxyContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OFDValidateProxyContainer2.class);
    public static final String issuedKey = "issued";
    public static final String issuedGd = "303";
    public static final String issuedZdc = "999";
    public static final String issuedLocal = "local";
    public static final String signVersion2 = "2";

    protected void validateSeal(SigType sigType, String signAlgName, byte[] tbsContent, byte[] signedValue) throws IOException, GeneralSecurityException {
        SignInfoVO signInfoVO = OFDValidateProxyContainer2.getSinInfoBySealData((byte[])signedValue);
        if (signInfoVO != null) {
            this.getSignInfoS().add(signInfoVO);
        }
        SignedDataValidateContainer validator = null;
        Map extraData = this.getExtraData();
        if (!extraData.isEmpty()) {
            validator = this.getValidatorByExtraData(extraData);
        }
        if (validator == null) {
            validator = this.getValidatorBySinInfo(signInfoVO);
        }
        if (validator == null) {
            validator = this.createDefaultValidate();
        }
        validator.validate(sigType, signAlgName, tbsContent, signedValue);
        LOG.info(String.format("verifyOfd seal start by: %s with cert: %s", validator.getClass().getSimpleName(), signInfoVO));
    }

    private String getSubject(SignInfoVO signInfoVO) {
        if (signInfoVO == null || signInfoVO.getCertInfo() == null || signInfoVO.getCertInfo().getSubject() == null) {
            return null;
        }
        return signInfoVO.getCertInfo().getSubject();
    }

    private SignedDataValidateContainer getValidatorByExtraData(Map<String, String> extraData) {
        SignedDataValidateContainer sealValidate = null;
        String issued = extraData.get(issuedKey);
        if (!issuedZdc.equals(issued) || OFDValidateProxyContainer2.isLinux()) {
            // empty if block
        }
        if (issuedLocal.equals(issued)) {
            sealValidate = this.createDefaultValidate();
        }
        return sealValidate;
    }

    private static boolean isLinux() {
        return !System.getProperty("os.name").toLowerCase().contains("win");
    }

    private SignedDataValidateContainer getValidatorBySinInfo(SignInfoVO signInfoVO) {
        SignedDataValidateContainer sealValidate = null;
        String subject = this.getSubject(signInfoVO);
        if (subject != null) {
            // empty if block
        }
        if (signVersion2.equals(signInfoVO.getSignVersion())) {
            sealValidate = this.createSESV1Validate();
        }
        return sealValidate;
    }

    private SignedDataValidateContainer createDefaultValidate() {
        return new SESV4ValidateContainerExt();
    }

    private SignedDataValidateContainer createSESV1Validate() {
        return new SESV1ValidateContainerExt();
    }
}

