/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.pdf;

import com.alibaba.fastjson.JSONObject;
import com.hnxc.soft.api.HNVoucherFileUtil;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.ygsoft.abc.mapp.ygca.exception.VerifyRuntimeException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithm;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithmFactory;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmParseException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmValidException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfCztAlgorithmFactory;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfFssAlgorithmFactory;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfGbAlgorithmFactory;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfSxxhAlgorithmFactory;
import com.ygsoft.abc.mapp.ygca.ext.utils.HNVoucherUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyListSignResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.X509CertVOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreFactory;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PdfValidator.class);
    private static final List<IPdfAlgorithmFactory> pdfAlgorithmFactories = new ArrayList<IPdfAlgorithmFactory>();

    private PdfValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyListSignResultVO validate(File file) {
        FileInputStream is = null;
        byte[] fileData = null;
        try {
            is = new FileInputStream(file);
            fileData = IOUtil.toByteArray((InputStream)is);
        }
        catch (FileNotFoundException e) {
            VerifyListSignResultVO verifyListSignResultVO;
            try {
                verifyListSignResultVO = new VerifyListSignResultVO(YesnoEnum.NSP, "pdf\u6587\u4ef6\u4e0d\u5b58\u5728", null);
            }
            catch (Throwable throwable) {
                PdfValidator.close(is);
                throw throwable;
            }
            PdfValidator.close(is);
            return verifyListSignResultVO;
        }
        PdfValidator.close(is);
        return PdfValidator.validate2(fileData);
    }

    public static VerifyListSignResultVO validate(InputStream is) {
        byte[] fileData = IOUtil.toByteArray((InputStream)is);
        return PdfValidator.validate2(fileData);
    }

    private static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable o : closeable) {
                if (o == null) continue;
                try {
                    o.close();
                }
                catch (IOException e) {
                    LOG.warn("close error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyListSignResultVO validate2(byte[] fileData) {
        VerifyListSignResultVO listSignResultVO;
        block25: {
            listSignResultVO = new VerifyListSignResultVO();
            PdfReader reader = null;
            ByteArrayInputStream bai = null;
            try {
                bai = new ByteArrayInputStream(fileData);
                reader = new PdfReader((InputStream)bai);
                AcroFields acroFields = reader.getAcroFields();
                ArrayList signatureNames = acroFields.getSignatureNames();
                if (signatureNames != null && signatureNames.size() > 0) {
                    signatureNames.sort(String::compareTo);
                    ArrayList<SignInfoVO> signInfos = new ArrayList<SignInfoVO>();
                    for (String signatureName : signatureNames) {
                        Certificate certificate = PdfValidator.verifySignature(reader.getSafeFile(), acroFields, signatureName);
                        SignInfoVO signInfoVO = new SignInfoVO(X509CertVOUtil.convert((Certificate)certificate));
                        signInfos.add(signInfoVO);
                    }
                    listSignResultVO.setSignInfos(signInfos);
                    break block25;
                }
                String xmlStr = HNVoucherFileUtil.xtractXMLFromPDF((byte[])fileData);
                listSignResultVO.setSignInfos(HNVoucherUtil.parseSignInfoVOs(xmlStr));
                if (xmlStr != null) {
                    boolean result = HNVoucherFileUtil.verifyVoucher((byte[])fileData);
                    if (!result) {
                        listSignResultVO.setSuccessed(YesnoEnum.NO);
                        listSignResultVO.setFailMessage("\u6587\u4ef6\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
                        VerifyListSignResultVO signatureName = listSignResultVO;
                        return signatureName;
                    }
                    break block25;
                }
                VerifyListSignResultVO verifyListSignResultVO = new VerifyListSignResultVO(YesnoEnum.NSP, "\u6587\u4ef6\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u540d", null);
                return verifyListSignResultVO;
            }
            catch (Exception e) {
                VerifyListSignResultVO verifyListSignResultVO;
                LOG.warn("pdf\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
                if (e instanceof PdfAlgorithmValidException) {
                    verifyListSignResultVO = new VerifyListSignResultVO(YesnoEnum.NO, e.getMessage(), null);
                    return verifyListSignResultVO;
                }
                verifyListSignResultVO = new VerifyListSignResultVO(YesnoEnum.NSP, "pdf\u9a8c\u7b7e\u4e0d\u652f\u6301", null);
                return verifyListSignResultVO;
            }
            finally {
                if (bai != null) {
                    try {
                        bai.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        listSignResultVO.setSuccessed(YesnoEnum.YES);
        listSignResultVO.setFailMessage("\u6587\u4ef6\u9a8c\u7b7e\u901a\u8fc7");
        LOG.info(String.format("validate pdf status: %s,  result: %s", listSignResultVO.getSuccessed(), JSONObject.toJSONString((Object)listSignResultVO)));
        return listSignResultVO;
    }

    private static Certificate verifySignature(RandomAccessFileOrArray originalPDF, AcroFields acroFields, String signatureName) throws CertificateStoreException, PdfAlgorithmValidException, PdfAlgorithmParseException {
        Certificate targetCertificate = null;
        for (IPdfAlgorithmFactory pdfAlgorithmFactory : pdfAlgorithmFactories) {
            IPdfAlgorithm pdfAlgorithm = pdfAlgorithmFactory.produce(originalPDF, acroFields, signatureName);
            Certificate certificate = null;
            try {
                certificate = pdfAlgorithm.parse();
                LOG.info(String.format("\u7b7e\u7ae0:[%s],\u7b97\u6cd5[%s]\u5339\u914d\u6210\u529f", signatureName, pdfAlgorithm.getValidateName()));
            }
            catch (PdfAlgorithmParseException e) {
                continue;
            }
            if (ConfigTool.checkCert()) {
                CertificateStoreFactory.getInstance().verify(certificate);
            }
            Boolean validateResult = pdfAlgorithm.validate();
            targetCertificate = certificate;
            if (validateResult.booleanValue()) break;
            throw new PdfAlgorithmValidException("\u7b7e\u540d\u503c\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
        }
        if (targetCertificate == null) {
            LOG.warn(String.format("\u7b7e\u7ae0:[%s],\u6ca1\u6709\u7b97\u6cd5\u5339\u914d\u6210\u529f", signatureName));
            throw new PdfAlgorithmParseException("\u7b97\u6cd5\u4e0d\u652f\u6301\u3002");
        }
        return targetCertificate;
    }

    public static VerifyListSignResultVO verifyPdfSignList(byte[] fileData) {
        if (fileData == null) {
            throw new VerifyRuntimeException("\u53c2\u6570\u9519\u8bef\uff1afileData\u4e3a\u7a7a\u3002");
        }
        try {
            return PdfValidator.validate2(fileData);
        }
        catch (Exception e) {
            throw new VerifyRuntimeException("\u9a8c\u7b7e\u4e0d\u652f\u6301\u3002", (Throwable)e);
        }
    }

    public static VerifyResultVO verifyPdf(byte[] fileData) {
        VerifyListSignResultVO listSignResult = PdfValidator.verifyPdfSignList(fileData);
        return VerifyResultVO.from((VerifyListSignResultVO)listSignResult);
    }

    static {
        pdfAlgorithmFactories.add(new PdfCztAlgorithmFactory());
        pdfAlgorithmFactories.add(new PdfFssAlgorithmFactory());
        pdfAlgorithmFactories.add(new PdfSxxhAlgorithmFactory());
        pdfAlgorithmFactories.add(new PdfGbAlgorithmFactory());
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

