/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.pdf.impl;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithm;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmParseException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmValidException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfValidateBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.crypto.digests.SM3Digest;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCztAlgorithm
extends PdfValidateBase
implements IPdfAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(PdfCztAlgorithm.class);
    private PublicKey publicKey;
    private byte[] originMsg;
    private byte[] digest;

    public PdfCztAlgorithm(RandomAccessFileOrArray originalPDF, AcroFields acroFields, String signatureName) {
        super(originalPDF, acroFields, signatureName);
    }

    @Override
    public String getValidateName() {
        return "\u8d22\u653f\u5385pdf\u9a8c\u7b7e\u7b97\u6cd5";
    }

    @Override
    public Certificate parse() throws PdfAlgorithmParseException {
        try {
            PdfDictionary pdfDictionary = this.getAcroFields().getSignatureDictionary(this.getSignatureName());
            PdfName subFilter = pdfDictionary.getAsName(PdfName.SUBFILTER);
            PdfString contents = pdfDictionary.getAsString(PdfName.CONTENTS);
            PdfArray byteRange = pdfDictionary.getAsArray(PdfName.BYTERANGE);
            byte[] originData = PdfCztAlgorithm.getOriginData(this.getOriginalPDF(), byteRange);
            byte[] signBytes = contents.getOriginalBytes();
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(signBytes));
            ASN1Primitive pkcs = din.readObject();
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier signedDataObjId = (ASN1ObjectIdentifier)signedData.getObjectAt(0);
            if (!"1.2.156.10197.6.1.4.2.2".equals(signedDataObjId.getId())) {
                throw new PdfAlgorithmParseException("pdf\u7b7e\u540d\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            ASN1Sequence content = (ASN1Sequence)((ASN1TaggedObject)signedData.getObjectAt(1)).getObject();
            int version = ((ASN1Integer)content.getObjectAt(0)).getValue().intValue();
            ASN1TaggedObject extendedCertificatesAndCertificates = (ASN1TaggedObject)content.getObjectAt(1);
            ASN1Sequence digestAlgorithm = (ASN1Sequence)content.getObjectAt(2);
            ASN1Sequence digestEncryptionAlgorithm = (ASN1Sequence)content.getObjectAt(3);
            ASN1Sequence serverInfo = (ASN1Sequence)content.getObjectAt(4);
            ASN1Sequence encryptDigest = (ASN1Sequence)content.getObjectAt(5);
            ASN1ObjectIdentifier algorithm = (ASN1ObjectIdentifier)digestAlgorithm.getObjectAt(0);
            if (!"1.2.156.10197.1.401".equals(algorithm.getId())) {
                throw new PdfAlgorithmParseException("pdfHash\u7b97\u6cd5\u4e0d\u652f\u6301");
            }
            ASN1ObjectIdentifier encryptionAlgorithm = (ASN1ObjectIdentifier)digestEncryptionAlgorithm.getObjectAt(0);
            if (!"1.2.156.10197.1.301.1".equals(encryptionAlgorithm.getId())) {
                throw new PdfAlgorithmParseException("pdf\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301");
            }
            SM3Digest dig1 = new SM3Digest();
            byte[] m1 = new byte[dig1.getDigestSize()];
            dig1.update(originData, 0, originData.length);
            dig1.doFinal(m1, 0);
            byte[] serverInfoBytes = serverInfo.getEncoded();
            byte[] timeStampInfoBytes = new byte[]{};
            byte[] segment2 = new byte[serverInfoBytes.length + timeStampInfoBytes.length];
            System.arraycopy(serverInfoBytes, 0, segment2, 0, serverInfoBytes.length);
            System.arraycopy(timeStampInfoBytes, 0, segment2, serverInfoBytes.length, timeStampInfoBytes.length);
            SM3Digest dig2 = new SM3Digest();
            byte[] m2 = new byte[dig2.getDigestSize()];
            dig2.update(segment2, 0, segment2.length);
            dig2.doFinal(m2, 0);
            byte[] msg = new byte[m1.length + m2.length];
            System.arraycopy(m1, 0, msg, 0, m1.length);
            System.arraycopy(m2, 0, msg, m1.length, m2.length);
            ASN1Sequence cert = ASN1Sequence.getInstance((ASN1TaggedObject)extendedCertificatesAndCertificates, (boolean)false);
            ASN1Sequence certASN1Sequence = (ASN1Sequence)cert.getObjectAt(0);
            byte[] pemCertificate = certASN1Sequence.getEncoded();
            Certificate certificate = PdfCztAlgorithm.getCertByBytes(pemCertificate);
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificate;
                this.setPublicKey(x509Cert.getPublicKey());
            }
            if (this.getPublicKey() == null) {
                throw new PdfAlgorithmParseException("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u5931\u8d25");
            }
            this.setDigest(encryptDigest.getEncoded());
            LOG.info(String.format("m1: %s, segment2: %s, m2: %s, msg: %s, digest: %s", new String(Base64.encode((byte[])m1)), new String(Base64.encode((byte[])segment2)), new String(Base64.encode((byte[])m2)), new String(Base64.encode((byte[])msg)), new String(Base64.encode((byte[])this.getDigest()))));
            this.setOriginMsg(msg);
            return certificate;
        }
        catch (Exception e) {
            if (e instanceof PdfAlgorithmParseException) {
                throw (PdfAlgorithmParseException)e;
            }
            throw new PdfAlgorithmParseException("\u7b7e\u540d\u4fe1\u606f\u89e3\u6790\u5931\u8d25", e);
        }
    }

    @Override
    public Boolean validate() throws PdfAlgorithmValidException, PdfAlgorithmParseException {
        return super.verifySm3WithSm2(this.getOriginMsg(), this.getDigest(), this.getPublicKey());
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] getOriginMsg() {
        return this.originMsg;
    }

    public void setOriginMsg(byte[] originMsg) {
        this.originMsg = originMsg;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

