/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.pdf.impl;

import com.itextpdf.text.io.RASInputStream;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.ygsoft.abc.mapp.ygca.algorithm.util.Base64Kit;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithm;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmParseException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmValidException;
import com.ygsoft.abc.mapp.ygca.gwcw.util.GmUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.bouncycastle149.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfValidateBase
implements IPdfAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(PdfValidateBase.class);
    private final RandomAccessFileOrArray originalPDF;
    private final AcroFields acroFields;
    private final String signatureName;

    public PdfValidateBase(RandomAccessFileOrArray originalPDF, AcroFields acroFields, String signatureName) {
        this.originalPDF = originalPDF;
        this.acroFields = acroFields;
        this.signatureName = signatureName;
    }

    public static void printSignedData(byte[] signBytes) {
        try {
            String signBytesBase64 = Base64Kit.toBase64String((byte[])signBytes);
            String signBytesData = new String(Hex.encode((byte[])signBytes));
            LOG.info("signBytesBase64: " + signBytesBase64);
            LOG.info("signBytesData: " + signBytesData);
        }
        catch (Exception e) {
            LOG.warn("printSignedData error ", (Throwable)e);
        }
    }

    public static byte[] getOriginData(RandomAccessFileOrArray originalPDF, PdfArray byteRange) {
        byte[] originData = null;
        RASInputStream rg = null;
        ByteArrayOutputStream outputStream = null;
        try {
            rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(originalPDF.createSourceView(), byteRange.asLongArray()));
            outputStream = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int n = 0;
            while (-1 != (n = rg.read(buf))) {
                outputStream.write(buf, 0, n);
            }
            originData = outputStream.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u83b7\u53d6pdf\u539f\u59cb\u6570\u636e\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                PdfValidateBase.close(new Closeable[]{rg});
                PdfValidateBase.close(outputStream);
                throw throwable;
            }
        }
        PdfValidateBase.close(new Closeable[]{rg});
        PdfValidateBase.close(outputStream);
        return originData;
    }

    public static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable o : closeable) {
                if (o == null) continue;
                try {
                    o.close();
                }
                catch (IOException e) {
                    LOG.warn("close error", (Throwable)e);
                }
            }
        }
    }

    public Boolean verifySm3WithSm2(byte[] originMsg, byte[] digest, PublicKey publicKey) throws PdfAlgorithmValidException, PdfAlgorithmParseException {
        boolean result = false;
        try {
            result = GmUtil.verifySm3WithSm2((byte[])originMsg, (byte[])digest, (PublicKey)publicKey);
        }
        catch (InvalidSignedValueException e) {
            throw new PdfAlgorithmParseException(e);
        }
        return result;
    }

    public static Certificate getCertByBytes(byte[] pemCertificate) throws PdfAlgorithmParseException {
        Certificate certificate;
        CertificateFactory certFactory = null;
        ByteArrayInputStream bis = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509", "BC162");
            bis = new ByteArrayInputStream(pemCertificate);
            certificate = certFactory.generateCertificate(bis);
        }
        catch (Exception e) {
            try {
                throw new PdfAlgorithmParseException("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                PdfValidateBase.close(bis);
                throw throwable;
            }
        }
        PdfValidateBase.close(bis);
        return certificate;
    }

    public RandomAccessFileOrArray getOriginalPDF() {
        return this.originalPDF;
    }

    public AcroFields getAcroFields() {
        return this.acroFields;
    }

    public String getSignatureName() {
        return this.signatureName;
    }
}

