/**
 * 封装的请求工具类.
 */
define(["jquery",
    "ecp.service",
    "ecp.utils",
    "ecp.component.dialog",
    "abc.basic.pureTool",
    "ecp.component.loading"], function ($, ecp, ecpUtils, $dialog, pureTool, PageLoading) {
	
	'use strict'; //使用js语法严格模式(提高代码运行效率)
	var LOGIN_CONTEXT_KEY = "_login_context_key";
    // 本地浏览器存储生命周期一天（毫秒）
    var LOCAL_STORAGE_TIME = 24 * 3600 * 1000;
	var loading = new PageLoading();
	
	var RequestUtil = function () {};
	RequestUtil.prototype = {
        /**
         * 弹出提示
         * @param msg 提示信息
         * @param hasTrans  是否对msg中的<  >  进行转义，防止xss攻击    传入true转义，传入false或不传不转义
         */
        notify : function(msg, hasTrans){
        	if (hasTrans && hasTrans === true) {
        		ecpUtils.notify(msg);
        	} else {
        		ecpUtils.notify(pureTool.encodeHtml(msg));
        	}
        },
        
        /**
         * 弹出提示
         * @param msg 提示信息
         */
        dialog: function (msg) {
        	$dialog.dialog({title: '提示', content: msg, isTip: true});
        },
		/**
		 * 检查参数是否为空
		 * 数值0：true
		 * 字符串'0'：false
		 */
		isEmpty: function (v) {
			return ecpUtils.isEmpty(v);
		},
        /**
         * 参数转换为数组，如果是数组直接返回
         */
        toArray: function (param) {
            if (this.isEmpty(param)) {
                throw new Error("参数错误：param为空。 ");
            }
            if ($.isArray(param)) {
                return param;
            }
            var arr = param.split(',');
            return arr;
        },
        /**
         * 根据key获取本地浏览器存储
         * @param key key
         * @returns {*}
         */
        getLocalStorage: function (key) {
            return $.jStorage.get(key) || [];
        },
        /**
         * 设置本地浏览器存储
         * @param key
         * @param value
         * @param liveTime 生命周期（毫秒），可选，
         * 不传默认取LOCAL_STORAGE_TIME：一个星期
         */
        setLocalStorage: function (key, value, liveTime) {
            var liveTime = liveTime || LOCAL_STORAGE_TIME;
            $.jStorage.set(key, value, {TTL: liveTime});
        },
        /**
         * 根据key清楚本地浏览器存储.
         */
        clearLocalStorage: function (key) {
            $.jStorage.deleteKey(key)
        },
        /**
         * 清空缓存
         */
        clearAllLocalStorage: function () {
            $.jStorage.flush();
        },
        /**
         * 显示BlockUI.
         */
        showBlockUI: function () {
            loading.show();
        },

        /**
         * 隐藏显示BlockUI.
         */
        hideBlockUI: function () {
            loading.hide();
        },
        /**
         * 显示指定ID的遮罩.
         */
        showTargetBlockUI: function (targetID) {
            var opt = {
                container: $('#' + targetID),
                timeout: 10000
            };
            var loading = new PageLoading(opt);
            loading.show();
            return loading;
        },
        /**
         * 隐藏指定ID的遮罩.
         */
        hideTargetBlockUI: function (loading) {
            if (this.isEmpty(loading)) {
                throw new Error("参数错误：target为空。");
            }
            loading.hide();
        },
        /**
         * 检查是否错误数据.
         * {status: 200, errCode: "", errMsg: "参数value为空。", moreInfoUrl: "mailto:support@ygsoft.com"}
         */
        isErrorData : function(respData) {
        	if (null == respData) {
        		return false;
        	}
        	var errCode = respData.hasOwnProperty("errCode");
        	var errMsg = respData.hasOwnProperty("errMsg");
        	return errCode && errMsg;
        },
		/**
		 * 防止重复操作-根据变量状态.
		 * @param controller 调用者.
		 * @param func 处理函数.
		 */
		preventRepeatWithState: function(controller, func) {
			return function() {
				if (controller["_submitState"]) {
					console.log("preventRepeat!");
					return;
				}
				controller["_submitState"] = true;
				setTimeout(function() {
					controller["_submitState"] = false;
		    	}, 1000);
				var args = [];
				for(var attr in arguments) {
					args.push(arguments[attr]);
				}
				func.apply(controller, args);
			};
		},
		/**
		 * 防止重复提交.
		 * @param ids
		 * @param container
		 * @param serialID
		 */
		preventRepeat: function (ids, container, serialID) {
		    if (this.isEmpty(ids)) {
		        throw new Error("参数错误：ids为空。");
		    }
		
		    if (this.isEmpty(container)) {
		        container = $("body");
		    }
		
		    //serialID 默认空串
		    if (this.isEmpty(serialID)) {
		        serialID = '';
		    }
		    ids = this.toArray(ids);
		    //禁用按钮
		    $.each(ids, function (i, id) {
		        $('#' + id + serialID).attr("disabled", true);
		    });
		
		    //启用按钮
		    setTimeout(function () {
		        $.each(ids, function (i, id) {
		            $('#' + id + serialID).attr("disabled", false);
		        });
		    }, 1000)
		},
		/**
		 * 发送vccode.
		 */
		sendVccode: function(userName, tenantId, appId) {
	    	var locale = $.cookie("ecp_locale") || "zh-cn";
	    	var args = ecpUtils.getAllArgument(true);
	    	var tenantId= tenantId || args.tenantid || "-1";
	    	var appId = appId || args.appid || "-1";
	    	var url = "/necp/mapp/4a/necp/login/sendVccode?userName="+userName+"&tenantId="+tenantId+"&appId="+appId+"&locale="+locale;
	    	var result = ecp.RemoteService.doPost(url, {});
	    	return result;
	    },
        /**
         * 同步的Get请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param hasBlockUI 是否显示加载画面
         */
        synGet: function (url, hasBlockUI) {
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            try {
                var result = ecp.RemoteService.doGet(url, null);
            } catch (e) {
                // ajax异常-默认关闭遮罩，避免多次交互下遮罩不关闭。
                this.hideBlockUI();
                throw new Error("程序发生错误：" + e.message);
            } finally {
                if (hasBlockUI) {
                    this.hideBlockUI();
                }
            }

            return result;
        },
        /**
         * 异步的Get请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param callback 返回结果后回调处理
         * @param hasBlockUI 是否显示加载画面
         * @param targetID 遮罩模板ID.
         */
        asynGet: function (url, callback, hasBlockUI, targetID) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                //全屏遮罩.
                if (this.isEmpty(targetID)) {
                    this.showBlockUI();
                } else {
                    var blockObj = this.showTargetBlockUI(targetID);
                }
            }

            // 后台调用
            ecp.RemoteService.doGetAsync(url, null, function (result) {
                if (hasBlockUI) {
                    //全屏遮罩.
                    if (that.isEmpty(targetID)) {
                        that.hideBlockUI();
                    } else {
                        blockObj.hide();
                    }
                }
                if (result.isSuccess()) {
                	if (that.isErrorData(result.data)) {
                		var errInfo = that._parseErrorMsg(result.data);
                		that.dialog(errInfo.errMsg);
                		return;
                	}
                	//---------------正常数据返回处理--------------
                    var respData = {};
                    if (!that.isEmpty(result.data)) {
                        // 初始化主表数据
                        respData = result.data;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    that.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        
        /**
         * 异步的Get请求（分页查询）--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param callback 返回结果后回调处理
         * @param hasBlockUI 是否显示加载画面
         */
        asynGetPage: function (url, callback, hasBlockUI) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            ecp.RemoteService.doGetAsync(url, null, function (result) {
                if (hasBlockUI) {
                    that.hideBlockUI();
                }
                if (result.isSuccess()) {
                    var respData = {};
                    if (result.data != null && !that.isEmpty(result.data.content)) {
                        // 初始化主表数据
                        respData = result.data.content;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    that.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        /**
         * 同步的Post请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param requestParam 请求参数
         * @param hasBlockUI 是否显示加载画面
         */
        synPost: function (url, requestParam, hasBlockUI) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            try {
                var result = ecp.RemoteService.doPost(url, requestParam);
            } catch (e) {
                // ajax异常-默认关闭遮罩，避免多次交互下遮罩不关闭。
                this.hideBlockUI();
                throw new Error("程序发生错误：" + e.message);
            } finally {
                if (hasBlockUI) {
                    this.hideBlockUI();
                }
            }

            return result;
        },
        /**
         * 异步的Post请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param requestParam 请求参数
         * @param callback 请求完后回调
         * @param hasBlockUI 是否显示加载画面
         */
        asynPost: function (url, requestParam, callback, hasBlockUI) {
            var that = this;
            var util = window.top.abcUtil || that;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
            	util.showBlockUI();
            }

            // 后台调用
            ecp.RemoteService.doPostAsync(url, requestParam, function (result) {
                if (hasBlockUI) {
                	util.hideBlockUI();
                }
                if (result.isSuccess()) {
                    var respData = {};
                    if (!that.isEmpty(result.data)) {
                        // 初始化主表数据
                        respData = result.data;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    util.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        /**
         * 解析错误信息.
         */
        _parseErrorMsg: function (errInfo) {
            if (typeof (errInfo) == "string") {
            	if (errInfo.startWith("<html>")) {
            		// 可能掉线返回拦截页面.
            		errInfo = {'errMsg': "对不起，您访问的服务不可用，请联系系统管理员。"};
            	} else {
            		errInfo = JSON.parse(errInfo);
            	}
            }
            return errInfo;
        },
        /**
         * 初始化扩展上下文.
         * @param url 扩展上下文请求地址.
         * @param ecpLoginContext ECP原始上下文对象.
         */
        initExtendLoginContext: function(url, ecpLoginContext) {
        	var that = this;
        	if (this.isEmpty(url)) {
                throw new Error("参数错误：url为空。");
            }
        	if (this.isEmpty(ecpLoginContext)) {
                throw new Error("参数错误：ecpLoginContext为空。");
            }
            // 后台调用
            try {
                var result = ecp.RemoteService.doPost(url, ecpLoginContext);
            	// 绑定到jStorage中
            	that.setLoginContext(null, result);
            } catch (e) {
                throw new Error("程序发生错误：" + e.message);
            } 
        },
        /**
         * 检查session是否有效(是否已登录).
         */
        checkSession : function(token) {
        	// 没有超时返回：{}
        	// 超时返回：｛"LOG_DESC", "会话超时。"｝
        	token = token || this.getEcpToken();
        	if (this.isEmpty(token)) {
        		console.info("token为空。");
        		return false;
        	}
        	// 1、如果是session过期.
        	var res = this.synPost("/validsession?tokenid=" + token, []);
        	if (res.LOG_DESC) {
        		console.info(res.LOG_DESC);
        		return false;
        	}
        	
        	// 2、如果是正常退出，而token还有.
        	var cxt = this.getContext();
        	if (cxt == null) {
    			return false;
    		}
    		var userName = cxt.userName;
    		if (userName == null) {
    			return false;
    		}
        	return true;
        },
        /**
         * 获取平台的上下文.
         */
        getContext : function() {
        	var res = this.synPost("/context", []);
        	return res;
        },
        /**
         * 设置登录上下文.
         * @param url 获取上下文的地址
         * @param loginContextVO 登录上下文
         */
        setLoginContext: function (url, loginContextVO) {
        	if (loginContextVO) {
        		this.setLocalStorage(LOGIN_CONTEXT_KEY, loginContextVO);
        	} else {
	            var respData = this.synGet(url);
	            this.setLocalStorage(LOGIN_CONTEXT_KEY, respData);
        	}
        },

        /**
         * 获取登录上下文.
         * @param url 获取上下文的地址，可选
         */
        getLoginContext: function (url) {
            var contextVO = this.getLocalStorage(LOGIN_CONTEXT_KEY);
            if (contextVO) {
                return contextVO;
            } else if (url) {
                this.setLoginContext(url);
                return this.getLocalStorage(LOGIN_CONTEXT_KEY);
            }
            return null;
        },
		/**
		 * 退出.
		 */
		logout: function (callback) {
			var url = "/logout4";
			$.jStorage.set("cacheKey_jstorage_logout", new Date().valueOf());
			ecp.RemoteService.doPostAsync(url, [], function (result) {
				if (result.isSuccess()) {
					if (result.data != null) {
						// 发送退出消息
						$.jStorage.set("cacheKey_jstorage_logout", new Date().valueOf());
					}
					if (callback) {
						callback();
					}
				} else {
					ecp.Log.error("退出失败");
					ecp.Exception.throwError("TC0001", "退出失败", result.data);
				}
			});
		},
        /**
         * 获取配置参数.
         * @param url 访问配置参数url.
         * @param key 参数key.
         */
        getConfigProperty : function(url, key) {
        	if (this.isEmpty(key)) {
        		throw new Error("参数错误：key为空。");
        	}
        	var val = this.getLocalStorage(key);
        	// GongQiang: this.isEmpty(val)对 true/false 判断异常.
        	if (val != null && val != "") {
        		return val;
        	}
        	//var url = "/abc/mapp/ygec/query/sysconfig/get-property?key=" + key;
        	url = url + "?key=" + key;
        	var val = this.synGet(url);
        	this.setLocalStorage(key, val);
        	return val;
        }
	};
	return new RequestUtil();
});