define(["jquery",
    "ecp.service",
    'abc.base64.util',
    'i18n!/assets/plugins/nls/common.js',
    "ecp.utils",
    "ecp.utils.window",
    "ecp.component.dialog",
    //"ecp.export",
    'ecp.component.loading',
    "qzz.object",
    "ecp.utils.des",
    "jquery.blockui",
    "jstorage",
    "ecp.extender.indigenous",
    "abc.common.uuid",
    'datetimepicker',
    "ecp.serverlog"], function ($, ecp, base64Util, $curLocaleNls, ecpUtils, winUtil, $dialog, /*ecpExport,*/ PageLoading, qzzObj, $des) {

    'use strict'; //使用js语法严格模式(提高代码运行效率)
    // 默认开日志功能
    var IS_ENABLELOG = true && (null != window.console);
    // 本地浏览器存储生命周期一天（毫秒）
    var LOCAL_STORAGE_TIME = 24 * 3600 * 1000;
    var loading = new PageLoading();

    var LOGIN_CONTEXT_KEY = "_login_context_key";

	/**
	 * 省份编号映射.
	 */
    var PROVINCE_CODE = ['11', '12', '13', '14', '15', '21',
        '22', '23', '31', '32', '33', '34',
        '35', '36', '37', '41', '42', '43',
        '44', '45', '46', '50', '51', '52',
        '53', '54', '61', '62', '63', '64',
        '65', '71', '81', '82'];

	/**
	 * 身份证加权因子表.
	 */
    var CARD_FACTOR = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];

	/**
	 * 校验码换算表.
	 */
    var CARD_PARITY = ["1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"];
    /**
     * html特殊字符.
     */
    var REGX_HTML_ENCODE = /"|&|'|<|>|[\x00-\x20]|[\x7F-\xFF]|[\u0100-\u2700]/g;
    /**
     * html特殊字符.
     */
    var REGX_HTML_DECODE = /&\w+;|&#(\d+);/g;
    
    var HTML_DECODE = {
            "<" : "<", 
            ">" : ">", 
            "&" : "&", 
            " ": " ", 
            '"': "\"", 
            "©": ""
     
            // Add more
        };
    /**
     * 注册ajax完成后事件.
     */
    $(document).ajaxComplete(function (event, xhr, options) {
        if ("REDIRECT" == xhr.getResponseHeader("REDIRECT")) {
            var loginUrl = xhr.getResponseHeader("CONTEXTPATH");
            while (window != window.top) {
                window = window.top;
            }
            if (loginUrl) {
                window.location.href = loginUrl;
            }
        }
    });

    var CommUtil = function () {
    };
    /**************************************************************常用工具方法-START***************************************************************/
    CommUtil.prototype = {
        /*
	 *
	 * field2Lowercase(data);
	 * isEmptyJQuery(jqObj);
	 * uuid(length, unit);
	 * isAllOpt(val);
	 * contains(val);
	 * inArray(value, arr);
	 * toString(param);
	 * toArray(param);
	 * str2Array(str, filterBlank);
	 * array2Map(arr, keyField);
	 * filterArrayBlank(arr);
	 * nullStr2Blank(datas, fields);
	 *
	 * nextDay(date, days);
	 * simpleFormatDate(date);
	 * formatDate(date, fmt);
	 * jsonDate2Str(jsonDate);
	 * checkDateRange(d1, d2);
	 *
	 * parseNumber(p);
	 * formatNumber(num);
	 * bitToNumbers(n);
	 *
	 * logInfo(str, date);
	 * logBegin(str);
	 * logEnd(str);
	 * nativelogBegin(str);
	 * nativelogEnd(str);
	 *
	 * getLocalStorage(key);
	 * setLocalStorage(key, value, liveTime);
	 * clearLocalStorage(key);
	 * clearAllLocalStorage();
	 *
	 * triggerGldxMore(gldxObj, pkgObj)
	 * afterQzzTableRendered(callBackFunc, pkgObj);
	 * execFuncByWait(funcObj, interval, curCount, maxCount);
	 *
	 * throwException(msg);
	 * getEcpToken();
	 * downloadGet(url);页面下载，get方法
	 * downloadPost(url);页面下载，post方法
	 */

        /**
         * ecp.utils引用.
         */
        ecpUtils: ecpUtils,

        /**
         * 对象深度克隆.
         */
        clone: function (obj) {
            var that = this;
            // Handle the 3 simple types, and null or undefined
            if (null == obj || "object" != typeof obj) return obj;

            // Handle Date
            if (obj instanceof Date) {
                var copy = new Date();
                copy.setTime(obj.getTime());
                return copy;
            }

            // Handle Array
            if (obj instanceof Array) {
                var copy = [];
                for (var i = 0, len = obj.length; i < len; ++i) {
                    copy[i] = that.clone(obj[i]);
                }
                return copy;
            }

            // Handle Object
            if (obj instanceof Object) {
                var copy = {};
                for (var attr in obj) {
                    if (obj.hasOwnProperty(attr)) copy[attr] = that.clone(obj[attr]);
                }
                return copy;
            }
            throw new Error("Unable to copy obj! Its type isn't supported.");
        },
        /**
         * 检查参数是否为空
         * 数值0：true
         * 字符串'0'：false
         */
        isEmpty: function (v) {
            return ecpUtils.isEmpty(v);
        },
        /**
         * 检查参数是否为空
         * 数值0: false
         */
        isEmptyNumber: function (v) {
            if (null == v) {
                return true;
            }
            if (this.trim(v + '') == '') {
                return true;
            }
            return false;
        },
	    /**
	     * 脱敏处理.
	     * @param str 待脱敏字符串.
	     * @param index 开始脱敏的index.
	     * @param length 脱敏字符个数.
	     */
        desensitive : function(str, index, length) {
	    	if (this.isEmpty(str)) {
	    		return str;
	    	}
	    	var result = [];
	    	var arr = str.split('');
	    	for(var i=0,j=arr.length; i<j; i++) {
	    		if (i < index) {
	    			result.push(arr[i]);
	    		} else if(i >= index + length) {
	    			result.push(arr[i]);
	    		} else{
	    			result.push("*");
	    		}
	    	}
	    	return result.join('');
	    },
	    /**
	     * 脱敏姓名.
	     */
	    desensitiveName : function(name) {
	    	return this.desensitive(name, 1, 1);
	    },
	    /**
	     * 脱敏手机号.
	     */
	    desensitiveMovetel : function(movetel) {
	    	return this.desensitive(movetel, 3, 4);
	    },
	    /**
	     * 脱敏身份证.
	     */
	    desensitiveCardId : function(cardId) {
	    	return this.desensitive(cardId, 10, 6);
	    },
        /**
         * 解析成json对象.
         */
        parseJSON: function(val) {
        	if (null == val) {
        		return null;
        	}
        	var _type = $.type(val);
        	if (_type == "string") {
        		return JSON.parse(val);
        	}
        	
        	return val;
        },
        /**
         * 生成uuid.
         * @param length 字符串长度.
         * @param unit 二进制/十进制/十六进制?
         */
        uuid: function (length, unit) {
            //参数都为空.
            if (this.isEmpty(length) && this.isEmpty(unit)) {
                return Math.uuid();
            }

            //unit为空
            if (!this.isEmpty(length) && this.isEmpty(unit)) {
                //Math.uuid(10);
                return Math.uuid(length);
            }

            //都有值
            if (!this.isEmpty(length) && !this.isEmpty(unit)) {
                //Math.uuid(10, 10);
                return Math.uuid(length, unit);
            }
        },
        /**
         * 是否原始类型（boolean,string,number）
         * @param val
         * @returns
         */
        isPrimitive : function(val) {
        	var _type = $.type(val);
        	if (_type === "boolean") {
        		return true;
        	}
        	if (_type === "number") {
        		return true;
        	}
        	if (_type === "string") {
        		return true;
        	}
        	return false;
        },
        /**
         * 将data对象所有字段统一小写
         */
        field2Lowercase: function (data) {
            if (this.isEmpty(data)) {
                return data;
            }
            var newData = {};
            for (var field in data) {
                newData[field.toLowerCase()] = data[field];
            }
            return newData;
        },
        /**
         * 去掉前后空格
         */
        trim: function (str) {
            if (this.isEmpty(str)) {
                return str;
            }
            str = str.replace(/(^\s*)|(\s*$)/g, '');

            return str;
        },
        /**
         * 编码html特殊字符.
         */
        encodeHtml : function (str) {
        	if (this.isEmpty(str)) {
                return str;
            }
        	return str.replace(REGX_HTML_ENCODE, 
                    function($0){
                        var c = $0.charCodeAt(0), r = ["&#"];
                        c = (c == 0x20) ? 0xA0 : c;
                        r.push(c); 
                        r.push(";");
                        return r.join("");
        	});
        },
        /**
         * 解密html特殊字符.
         */
        decodeHtml : function (str) {
        	if (this.isEmpty(str)) {
                return str;
            }
        	
        	return str.replace(REGX_HTML_DECODE,
                    function($0, $1){
                        var c = HTML_DECODE[$0];
                        if(c == undefined){
                            // Maybe is Entity Number
                            if(!isNaN($1)){
                                c = String.fromCharCode(($1 == 160) ? 32:$1);
                            }else{
                                c = $0;
                            }
                        }
                        return c;
                    });
        },
        
        /**
         * 解密用户VO关键信息.
         *  配合CommonUtil  中的 encodeUserVO方法使用
         */
        decryptUserVO : function(userVO) {
        	// 身份证
        	if (!ecpUtils.isEmpty(userVO.cardId)) {
				userVO.cardId = $des.doDecrypt(userVO.cardId);
			}
        	
        	// email
			if (!ecpUtils.isEmpty(userVO.email)) {
				userVO.email = $des.doDecrypt(userVO.email);
			}
			
			// 电话
        	if (!ecpUtils.isEmpty(userVO.movetel)) {
        		userVO.movetel = $des.doDecrypt(userVO.movetel);
			}
        },
        
        /**
         * 设置下拉框值
         */
        setSelect2Data: function (option) {
            $("#" + option.eleId).append("<option value=''>请选择...</option>");
            if (!ecpUtils.isEmpty(option.data)) {
                var optionElement = "";
                var hideValue = "";
                $.each(option.data, function (i, item) {
                    optionElement = "<option value='" + item[option.id || 'id'];
                    hideValue = "";
                    if (!ecpUtils.isEmpty(option.hideValue)) {
                        // 增加多字段分支
                        if ($.isArray(option.hideValue)) {
                            for (var i = 0, fieldLen = option.hideValue.length; i < fieldLen; i++) {
                                if (i == 0) {
                                    hideValue = hideValue + item[option.hideValue[i]];
                                } else {
                                    hideValue = hideValue + "&&" + item[option.hideValue[i]];
                                }
                            }
                            optionElement = optionElement + "' hideValue='" + hideValue;
                        } else {
                            optionElement = optionElement + "' hideValue='" + item[option.hideValue];
                        }
                    }
                    optionElement = optionElement + "'>" + item[option.text || 'text'] + "</option>";
                    $("#" + option.eleId).append(optionElement);
                });
            }
            $("#" + option.eleId).trigger('change');
        },
        /**
         * 去掉前后空格后为空串
         */
        isTrimEmpty: function (str) {
            if (this.isEmpty(str)) {
                return true;
            }

            str = this.trim(str);
            if (this.isEmpty(str)) {
                return true;
            }

            return false;
        },
        /**
         * $("#id")---未找到--->[]
         * 是否为空jQuery对象（即，空数组）
         */
        isEmptyJQuery: function (jqObj) {
            return jqObj.length == 0;
        },
        /**
         * 删除对象空属性
         */
        deleteEmptyField: function (obj) {
            if (this.isEmpty(obj)) {
                return null;
            }
            for (var key in obj) {
                var value = obj[key];
                if (!value) {
                    delete obj[key];
                }
            }
            return obj;
        },
        /**
         * 是否为【全部】选项
         */
        isAllOpt: function (val) {
            // 【空值】也默认是全部
            if (this.isEmpty(val)) {
                return true;
            }
            if ('-1' == val) {
                return true;
            }
            return false;
        },
        /**
         * 字符串是否包含指定串
         * @param str 原字符串
         * @param search 搜索字符串
         */
        containStr: function (str, search) {
            if (this.isEmpty(str) || this.isEmpty(search)) {
                throw new Error("参数错误：str or search为空。")
            }
            var idx = str.indexOf(search);
            return idx > -1;
        },
        /**
         * 添加数据到Array，并保证唯一
         */
        addSingle2Array: function (arr, val) {
            if (arr == null) {
                throw new Error("参数错误：arr为null。 ");
            }
            // 当前数组中不包含，则添加
            if (!this.inArray(val, arr)) {
                arr.push(val);
            }
        },
        /**
         * 检查指定的值是否在array
         */
        inArray: function (value, arr) {
            if (arr == null) {
                throw new Error("参数错误：arr为null。 ");
            }
            if ($.inArray(value, arr) > -1) {
                return true;
            }
            return false;
        },
        /**
         * 强制转换字符串
         */
        toString: function (param) {
            if (param == null) {
                return '';
            }

            return '' + param;
        },
        /**
         * 参数转换为数组，如果是数组直接返回
         */
        toArray: function (param) {
            if (this.isEmpty(param)) {
                throw new Error("参数错误：param为空。 ");
            }
            if ($.isArray(param)) {
                return param;
            }
            var arr = param.split(',');
            return arr;
        },
        /**
         * 字符串切割成数组返回（trim）
         * @param str 字符串（如:"abc,kdik,ale"）
         * @param filterBlank 是否过滤空串（默认过滤空串）
         */
        str2Array: function (str, filterBlank) {
            var that = this;
            if (this.isEmpty(str)) {
                return [];
            }
            if (filterBlank == null) {
                filterBlank = true;
            }
            var arr = str.split(",");
            var rst = [];
            $.each(arr, function (i, e) {
                e = $.trim(e);
                if (!that.isEmpty(e)) {
                    rst.push(e);
                }
            });

            return rst;
        },
        /**
         * 将数组转换成Map
         * @param arr
         * @param keyField
         * [{id:'01', text:'AAA'},{id:'02', text:'BBB'},{id:'03', text:'CCC'},...]
         * -->
         * {
         * 	'01':{id:'01', text:'AAA'},
         *  '02':{id:'02', text:'BBB'},
         *  '03':{id:'03', text:'CCC'},
         * }
         */
        array2Map: function (arr, keyField) {
            var that = this;
            if (this.isEmpty(keyField)) {
                this.dialog('参数错误：keyField为空。');
                return null;
            }
            if (GldxUtil.isEmpty(arr)) {
                return {};
            }
            var map = {};
            $.each(arr, function (i, e) {
                var key = e[keyField];
                if (that.isEmpty(key)) {
                    this.dialog('数据错误：key为空。');
                    return null;
                }
                map[key] = e;
            });
            return map;
        },
        /**
         * 过滤数组里的空值
         * @param arr 数组（如['12544524','12544523']）
         *
         */
        filterArrayBlank: function (arr) {
            var that = this;
            if (arr == null) {
                this.dialog("参数错误:dxids为空。");
                return;
            }

            var newArr = [];
            $.each(arr, function (i, v) {
                if (!that.isEmpty(v)) {
                    newArr.push(v);
                }
            });

            return newArr;
        },
        /**
         * 将指定列对应的值'null'转换为空串
         * @param datas
         * @param fields 需要检查的字段（数组）
         */
        nullStr2Blank: function (datas, fields) {
            var that = this;
            if (this.isEmpty(datas)) {
                return;
            }
            $.each(datas, function (i, v) {
                // 指定要检查的字段
                $.each(fields, function (j, field) {
                    var val = '' + v[field];
                    if (!that.isEmpty(val)) {
                        if ("NULL" === val.toUpperCase()) {
                            v[field] = '';
                        }
                    }
                });
            });
        },
        /**
         * 计算指定下个天数的日期对象
         * @param date（日期对象）
         * @param days 间隔天数（允许负数）
         */
        nextDay: function (date, days) {
            if (this.isEmpty(date)) {
                throw new Error("参数错误：dateVal为空。 ");
            }
            if (this.isEmpty(days)) {
                throw new Error("参数错误：days为空。 ");
            }

            var that = this;
            var cons = 24 * 60 * 60 * 1000;
            var valType = $.type(date);
            date = this.parseDate(date);
            var time = date.getTime();
            time = time + (days * cons);
            return new Date(time);
        },
        /**
         * 简单日期格式化（yyyy-MM-dd）
         * @param date JS原生Date类
         */
        simpleFormatDate: function (date) {
            return ecpUtils.formatDate(date, 'yyyy-MM-dd');
        },
        /**
         * 解析为EcpDate.
         */
        parseEcpDate: function (dateVal) {
            if (this.isEmpty(dateVal)) {
                throw new Error("参数错误：dateVal为空。 ");
            }
            var date = this.parseDate(dateVal);
            return "/Date(" + date.getTime() + "+0800)/"
        },
        /**
         * 解析为jsDate对象.
         * 1、"/Date(1506960000000+0800)/"
         * 2、yyyy-MM-dd
         * 3、yyyy-MM-dd hh:mm:ss
         */
        parseDate: function (dateVal) {
            var that = this;
            if (this.isEmpty(dateVal)) {
                throw new Error("参数错误：dateVal为空。 ");
            }

            var valType = $.type(dateVal);
            //Date对象直接返回.
            if ('date' === valType) {
                return dateVal;
            }
            var date = null;
            //类型为字符串
            if ('string' === valType) {
                //日期json格式："\/Date(1540915200000+0800)\/"
                if (/^\/Date\(\d+\+0800\)\/$/.test(dateVal)) {
                    date = that.jsonStrToDate(dateVal);
                } else if (/^\\\/Date\(\d+\+0800\)\\\/$/.test(dateVal)) {
                    date = that.jsonStrToDate(dateVal);
                } else if (/^\d{4}-\d{2}-\d{2}$/.test(dateVal)) {
                    //日期格式：yyyy-MM-dd
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                } else if (/^\d{4}-\d{2}-\d{2}\s*\d{2}:\d{2}:\d{2}$/.test(date)) {
                    //日期格式：yyyy-MM-dd hh:mm:ss
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                } else if (/^\d{4}-\d{2}-\d{2}\s*\d{2}:\d{2}$/.test(dateVal)) {
                    //日期格式：yyyy-MM-dd hh:mm
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                }
            } else if ('number' === valType) {
                date = new Date(dateVal)
            }

            return date;
        },
        /**
         * 将 Date 转化为指定格式的String
         * 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
         * 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
         * 例子： formatDate(new Date(),"yyyy-MM-dd hh:mm:ss")
         */
        formatDate: function (date, fmt) {
            return ecpUtils.formatDate(date, fmt);
        },
        /**
         * "/Date(1506960000000+0800)/" -> "2017-10-03"
         * json日期转换成（'yyyy-MM-dd'）格式
         */
        jsonDate2Str: function (jsonDate) {
            return ecpUtils.strToDate(jsonDate);
        },

        /**
         * "/Date(1506960000000+0800)/" -> "2017-10-03"
         * json日期转换成（'yyyy-MM-dd hh:ii'）格式
         */
        jsonDate2abStrWithoutSecond: function (jsonDate) {
            return ecpUtils.strToDate(jsonDate, true, null, false);
        },
        
        /**
         * "/Date(1506960000000+0800)/" -> "2017-10-03"
         * json日期转换成（'yyyy-MM-dd hh:ii:mm'）格式
         */
        jsonDate2abStr: function (jsonDate) {
            return ecpUtils.strToDate(jsonDate, true, null, true);
        },

        /**
         * "/Date(1506960000000+0800)/" -> Fri Feb 03 2012 00:00:00 GMT+0800
         * json日期转换成js Date对象.
         */
        jsonStrToDate: function (jsonDate) {
            return ecpUtils.jsonStrToDate(jsonDate);
        },
        /**
         * 将格式化带千分位的金额转换成数字
         */
        parseNumber: function (p) {
            if (this.isEmpty(p)) {
                return 0;
            }
            if (typeof p === 'string') {
                p = p.replace(/,/g, "");
            }

            return parseFloat(p);
        },
        /**
         * 由于自动带出的金额无法使用numberBox格式化,所以加一个方法格式化数字
         * @param num 待转换数值.
         * @param scale 精度（默认2）
         */
        formatNumber: function (num, scale) {
            if (null == scale) {
                scale = 2;
            }
            if (scale < 0) {
                throw new Error("参数错误：scale必须大于等于0。");
            }
            //小数点占位.
            var decimalPadding = this._buildDecimal(scale);
            if (num === undefined || num == "" || num == 0) {
                return this._addDecimal("0", decimalPadding);
            }
            var result = num;
            num = num + "";
            num = num.replace(new RegExp(",", "g"), "");
            // 正负号处理
            var symble = "";
            if (/^([-+]).*$/.test(num)) {
                symble = num.replace(/^([-+]).*$/, "$1");
                num = num.replace(/^([-+])(.*)$/, "$2");
            }
            if (/^[0-9]+(\.[0-9]+)?$/.test(num)) {
                var num = num.replace(new RegExp("^[0]+", "g"), "");
                if (/^\./.test(num)) {
                    num = "0" + num;
                }
                // 获取小数部分
                var decimal = num.replace(/^[0-9]+(\.[0-9]+)?$/, "$1");
                // 获取整数部分
                var integer = num.replace(/^([0-9]+)(\.[0-9]+)?$/, "$1");
                var re = /(\d+)(\d{3})/;
                // 给传入参数隔三位添加千分位
                while (re.test(integer)) {
                    integer = integer.replace(re, "$1,$2");
                }
                // 拼接
                result = symble + integer + decimal;
            } else {
                result = num;
            }

            return this._addDecimal(result + "", decimalPadding);
        },
        
        /**
         * bit位转换成具体的数字集合.
         * 1,2,4,8... 计数值
         * 3->[1,2]
         * 9->[1,8]
         */
        bitToNumbers : function(n) {
            var r = [];
            var i = 0;
            while (n > 0) {
                if (n & 0x01 === 1) {
                    r.push(Math.pow(2, i));
                }
                i++;
                n = n >> 1;
            }
            return r;
        },
        
        /**
         * 构建小数部分（占位）
         */
        _buildDecimal: function (scale) {
            var arr = [];
            for (var i = 0; i < scale; i++) {
                arr.push("0");
            }
            return arr.join("");
        },
        /**
         * 添加小数部分.
         * @param num 数值.
         * @param decimalPadding 小数填充
         */
        _addDecimal: function (num, decimalPadding) {
            //小数点索引.
            var idx = num.indexOf(".");
            if (idx < 0) {
                if ("" != decimalPadding) {
                    num = num + "." + decimalPadding;
                }
            } else {
                var decimal = num.substring(idx + 1);
                var length = decimal.length;
                //小数位补齐.
                if (length < decimalPadding.length) {
                    num = num + decimalPadding.substring(decimal.length);
                }
            }
            return num;
        },
        /**
         * 检查两个日期控件时，日期大小是否正确
         * @param d1 开始日期
         * @param d2 结算日期
         */
        checkDateRange: function (d1, d2) {
            //两个都有值才检查
            if (!this.isEmpty(d1) && !this.isEmpty(d2)) {
                var date1 = d1;
                var date2 = d2;
                if (typeof d1 == "string") {
                    date1 = Date.parse(d1);
                }
                if (typeof d2 == "string") {
                    date2 = Date.parse(d2);
                }
                return date1 > date2 ? false : true;
            }
            return true;
        },

        /**
         * 忽略DXLX比较两个DXID是否相等
         */
        equalsIgnoreDxlx: function (dxid1, dxid2) {
            //如果同时为null，表示不需要比较，返回true
            if (this.isEmpty(dxid1) &&
                this.isEmpty(dxid2)) {
                return true;
            }
            //其中之一为null，返回false
            if (this.isEmpty(dxid1) ||
                this.isEmpty(dxid2)) {
                return false;
            }
            var onlyid1 = dxid1;
            var onlyid2 = dxid2;
            if (dxid1.indexOf(".") > -1) {
                onlyid1 = dxid1.split(".")[1];
            }
            if (dxid2.indexOf(".") > -1) {
                onlyid2 = dxid2.split(".")[1];
            }
            return onlyid1 === onlyid2;
        },

        /**
         *日志输出函数 .
         *@param {String} str 要输出的内容
         *@param {String} date 日期
         */
        logInfo: function (str, date) {
            if (IS_ENABLELOG && window.console != null) {
                if (date == null) {
                    date = new Date();
                }
                var h = date.getHours();
                var m = date.getMinutes();
                var s = date.getSeconds();
                var ms = date.getMilliseconds();
                date = null;
                var str = "[" + h + ":" + m + ":" + s + "." + ms + "]" + str;
                setTimeout(function () {
                    window.console.info(str);
                }, 0);
            }
        },

        /**
         * 时间统计日志(开始).
         * @param {String} str 要输出的信息
         */
        logBegin: function (str) {
            if (IS_ENABLELOG) {
                this.beginDate = new Date();
                var msg = "标识【$0】耗时统计开始...";
                this.logInfo(msg.smartReplace(str), this.beginDate);
            }
        },
        /**
         * 时间统计日志(结束).
         * @param {String} str 要输出的信息
         */
        logEnd: function (str) {
            if (IS_ENABLELOG && this.beginDate != null) {
                var bh = this.beginDate.getHours();
                var bm = this.beginDate.getMinutes();
                var bs = this.beginDate.getSeconds();
                var bms = this.beginDate.getMilliseconds();
                var date = new Date();
                var eh = date.getHours() - bh;
                var em = date.getMinutes() - bm;
                if (em < 0) {
                    eh--;
                    em += 60;
                }
                var es = date.getSeconds() - bs;
                if (es < 0) {
                    em--;
                    es += 60;
                }
                var ems = date.getMilliseconds() - bms;
                if (ems < 0) {
                    es--;
                    ems += 1000;
                }
                date = null;
                var times = (eh * 3600 + em * 60 + es) * 1000 + ems;
                var msg = "标识【$0】耗时统计结束，耗时：$1毫秒";
                this.logInfo(msg.smartReplace(str, times));
            }
        },

        /**
         * 原生时间统计日志(开始)
         * @param str
         */
        nativelogBegin: function (str) {
            if (IS_ENABLELOG && window.console && $.isFunction(window.console.time)) {
                window.console.time(str);
            }
        },

        /**
         * 原生时间统计日志(结束)
         * @param str
         */
        nativelogEnd: function (str) {
            if (IS_ENABLELOG && window.console && $.isFunction(window.console.timeEnd)) {
                window.console.timeEnd(str);
            }
        },
        /**
         * 根据key获取本地浏览器存储
         * @param key key
         * @returns {*}
         */
        getLocalStorage: function (key) {
            return $.jStorage.get(key) || [];
        },

        /**
         * 设置本地浏览器存储
         * @param key
         * @param value
         * @param liveTime 生命周期（毫秒），可选，
         * 不传默认取LOCAL_STORAGE_TIME：一个星期
         */
        setLocalStorage: function (key, value, liveTime) {
            var liveTime = liveTime || LOCAL_STORAGE_TIME;
            $.jStorage.set(key, value, {TTL: liveTime});
        },
        /**
         * 根据key清楚本地浏览器存储.
         */
        clearLocalStorage: function (key) {
            $.jStorage.deleteKey(key)
        },
        /**
         * 清空缓存
         */
        clearAllLocalStorage: function () {
            $.jStorage.flush();
        },

        /**
         * 触发管理对象控件[更多...]摊出选择窗口
         */
        triggerGldxMore: function (gldxObj, pkgObj) {
            var that = this;
            if (this.isEmpty(gldxObj)) {
                that.dialog("参数错误：gldxObj为空。");
                return;
            }
            if (this.isEmpty(pkgObj)) {
                pkgObj = $("body");
            }
            gldxObj.getComboBox().control.parent().find("input").trigger("click");
            //进入明细页面，table初始化完成后立即执行查询操作。
            var funcObj = {
                'sucFunc': function () {
                    setTimeout(function () {
                        var select2Drop = pkgObj.find("#select2-drop:visible");
                        select2Drop.find("#addMore").trigger("click");
                    }, 100);
                },
                'failFunc': function () {
                    that.dialog("触发管理对象控件[更多]失败。");
                },
                'checkFunc': function () {
                    // 查找当前显示的select2-drop
                    var select2Drop = pkgObj.find("#select2-drop:visible");
                    var addMore = select2Drop.find("#addMore");
                    if (that.isEmpty(addMore)) {
                        return false;
                    }
                    return true;
                }
            };
            this.execFuncByWait(funcObj, 100, 1, 100);
        },
        /***
         * qzz表格渲染完成后立即执行回调。（默认最大等待7秒。）
         * @param callBackFunc qzz渲染完成后执行的回调函数。
         * @param pkgObj 包裹qzz的控件，默认body（一个页面有多个qzz时候，指定判断是哪个qzz渲染完成。）
         */
        afterQzzTableRendered: function (callBackFunc, pkgObj) {
            var that = this;
            if (!$.isFunction(callBackFunc)) {
                this.dialog("参数错误：callBackFunc必须为函数。");
                return;
            }
            if (this.isEmpty(pkgObj)) {
                pkgObj = $("body");
            }
            //进入明细页面，table初始化完成后立即执行查询操作。
            var funcObj = {
                'sucFunc': function () {
                    callBackFunc();
                },
                'failFunc': function () {
                },
                'checkFunc': function () {
                    var tb = pkgObj.find(".component_ui_listview_table");
                    if (that.isEmpty(tb)) {
                        return false;
                    }
                    return true;
                }
            };
            this.execFuncByWait(funcObj, 350, 1, 20);
        },
        /**
         * 等待条件成熟执行回调
         * @param funcObj={sucFunc(成功执行的回调), failFunc(失败的回调), checkFunc(检查回调)} 待执行的函数
         * @param interval 间隔（毫秒）
         * @param curCount 当前执行次数
         * @parma maxCount 最大执行次数
         */
        execFuncByWait: function (funcObj, interval, curCount, maxCount) {
            var that = this;
            setTimeout(function () {
                if (!funcObj.checkFunc()) {
                    //检查不通过
                    if (curCount <= maxCount) {
                        curCount++;
                        that.execFuncByWait(funcObj, interval, curCount, maxCount);
                    } else {
                        //超过最大执行次数，返回。
                        if (funcObj.failFunc) {
                            funcObj.failFunc();
                        }
                        return;
                    }
                } else {
                    //检查通过执行回调
                    funcObj.sucFunc();
                }
            }, interval);
        },
        /**
         * 抛出异常.
         * @param msg 异常提示语句.
         */
        throwException: function (msg) {
            throw new Error(msg);
        },
        /**
         * 从cookie获取系统的token.
         */
        getEcpToken: function() {
        	// 以前的cookie项ecp_token已被弃用
        	return $.cookie("ecpDataContext.tokenId");
        },
        
        /**
         * 页面下载，get方法.
         * @param url 下载地址.
         */
        downloadGet: function(url) {
        	var a = document.createElement('a');
    		a.href = url;
    		document.body.append(a);
    		a.click();
    		a.remove();
        },
        
        /**
         * 页面下载，post方法.
         * @param url 下载地址.
         */
        downloadPost: function(url) {
    		var f = document.createElement('form');
    		f.method = 'post';
        	f.action = url;
        	var s = document.createElement('input');
        	s.type = 'submit';
        	f.append(s);
    		document.body.append(f);
    		s.click();
    		f.remove();
        },
    /**************************************************************常用工具方法-END***************************************************************/


    /**************************************************************页面样式/弹框/窗口等-START***************************************************************/
    /*
	 * notify(msg, hasTrans);
	 * dialog(msg);
	 * openWindow(url);
	 * showMsg(msg);
	 * showDetailMsg(contentTitle,msg);
	 * showSfMsg(contentTitle,callback);
	 * openConfirm(contentTitle, callback);--回调值关注要做的事情，自动关闭（callback:是）
	 * openConfirm2(contentTitle, callback1, callback2);--回调值关注要做的事情，自动关闭（callback1:否, callback2:是）
	 * show2ButtonMsg(contentTitle,buttons,callback1,callback2);
	 * buildPopDiv( opt ); --构建弹框
	 *
	 * showBlockUI();
	 * hideBlockUI();
	 * showMask(target);
	 * hideMask(target);
	 *
	 * throughOldPageInNewWin(url, throughOpt);
     * throughOldPageInModal(throughOpt);
	 * showIframeModal(url, popHtml, width, height, isTransBg);
	 * showNewIframeModal(option,clickCallback,hiddenCallback);
	 * showNoBtnIframeModal(option,hiddenCallback);
	 * openFullScreeIframe(option, exterHtml);
	 *
	 * getEcmjcfjText(attachment) -- 获取ecm附件文本框值
	 * addSerialID(ids, serialID)
	 * clearCellValue(grid, fields)
	 * clearValue(ctrl, ids, container)
	 * bindFocusSelect()
	 * bindTextChange(ids, container, serialID)
	 * bindAddUnderline(ids, container);
	 * addUnderline(ids,container);
	 * addBorderRadius(ids,container);
	 * addSelectClose(ids,container);
	 * clearComboxText(ids,container);
	 * switchClickBtn(id, container); -- 点击按钮-禁用-500ms-开启
	 *
	 * disableElement(ctrl, ids) -- 禁用控件
	 * enableElement(ctrl, ids) -- 启用控件
	 * setBizStatus(ids, sta); -- 设置控件状态（禁用 or 启用）
	 * disabledAll();
	 * parseComponentHtml(template, resp, serialID);
	 *
	 * bindQueryInnerClick(moreFunc, backFunc, container);
     * bindQzzQueryInnerClick(grid, chgHeight, container); -- 绑定[收起/展开]
     * setQzzWrapperHeight(height); -- 设置qzz表格wrapper的高度
     * delQzzRowData(grid, rowIds); -- 删除qzz表格行（单行or多行）
     * getSelectedOnlyOne(grid);--强制选择一条记录
	 *
	 * locateUp(numText, jstreeID, serialID)
     * locateDown(numText, jstreeID, serialID)
     * locateClearStyle(jstreeID, serialID)
     *
     * fullScreenHeight(hasHeader, hasFooter)
     * isAddSingle(opt)
     * isUpdateSingle(opt)
     * isShowSingle(opt)
     * getSingleTitle(opt, title)
	 */
        /**
         * 弹出提示
         * @param msg 提示信息
         * @param hasTrans  是否对msg中的<  >  进行转义，防止xss攻击    传入true转义，传入false或不传不转义
         */
        notify : function(msg, hasTrans){
        	if (hasTrans && hasTrans === true) {
        		ecpUtils.notify(msg);
        	} else {
        		// 以下代码是从平台代码中copy出来的，平台代码中增加了escapeAngleBrackets方法，将< >括号替换掉了，改方法去掉了escapeAngleBrackets方法
        		var e = msg;
        		var notifyMsgEle;
        		if (0 !== $(".alert.alert-info").length && notifyMsgEle && notifyMsgEle.$ele && 0 !== notifyMsgEle.$ele.length) {
        			var t = notifyMsgEle.$ele.find("span")
        			, n = "object" == typeof e ? e.message : e
        					, r = "notifyMsgEle13676010686"
        						, i = $("#" + r);
        			if (0 === i.length && ($("body").append("<div id='" + r + "' style='display:none;'>"),
        					i = $("#" + r)),
        					//i.html(ecpUtils.escapeAngleBrackets(n)),
        					i.html(n),
        					t && 0 !== t.length && t.text() === i.text())
        				return
        		}
        		var o, a, s;
        		"object" == typeof e && (o = e.delay,
        				a = e.container,
        				s = e.message),
        				"string" == typeof e && (s = e),
        				o = o || 5e3,
        				a = a || "body",
        				notifyMsgEle = $.notify({
        					icon: "glyphicon glyphicon-warning-sign",
        					// message: ecpUtils.escapeAngleBrackets(s)
        					message: s
        				}, {
        					element: a,
        					position: null,
        					type: "info",
        					allow_dismiss: !0,
        					newest_on_top: !1,
        					placement: {
        						from: "top",
        						align: "right"
        					},
        					offset: {
        						x: 30,
        						y: 30
        					},
        					spacing: 10,
        					z_index: 999999,
        					delay: o,
        					timer: 1e3,
        					url_target: "_blank",
        					mouse_over: "pause",
        					animate: {
        						enter: "animated fadeInDown",
        						exit: "animated fadeOutUp"
        					},
        					onShow: null,
        					onShown: null,
        					onClose: null,
        					onClosed: null,
        					icon_type: "class",
        					template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert"><button type="button" aria-hidden="true" class="close" data-notify="dismiss">×</button><span data-notify="message">{2}</span></div>'
        				})
        		
        	}
        },
        
        /**
         * 弹出提示
         * @param msg 提示信息
         */
        dialog: function (msg) {
            this.showMsg(msg);
        },
        /**
         * 打开窗口.
         */
        openWindow: function (url) {
            winUtil.openWindow(url, 'ECP');
        },
        /**
         * 弹出提示
         * @param msg 提示信息
         */
        showMsg: function (msg) {
            $dialog.dialog({title: $curLocaleNls.basicUtil.js.tips, content: msg, isTip: true});
        },

        /**
         * 弹出带详细信息的提示框
         * @param msg 提示信息，使用'<br/>'分割行。
         */
        showDetailMsg: function (contentTitle, msg) {
            $dialog.dialog({
                title: "提示",   //模态窗标题
                content: contentTitle, //模态窗内容
                isTip: true, //标准的提示窗口
                showCloseButton: true,  //不显示关闭按钮
                detailedMessage: msg
            });
        },
        /**
         * 弹出带有是否的消息框.
         * @param contentTitle 提示信息
         * @param callback 是的回调函数
         */
        showSfMsg: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: callback
            });
        },

        /**
         * 打开仅有确定按钮并有回调函数的弹框
         */
        openTrue2Confirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['确定'],
                otherButtonStyles: ['btn-primary'],
                clickButton: callback
            });
        },
        /**
         * 打开仅有确定按钮的弹框
         */
        openTrueConfirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['确定'],
                otherButtonStyles: ['btn-primary'],
                clickButton: function (sender, modal) {
                    // 关闭模态窗
                    modal.modal("hide");
                    callback.call();
                }
            });
        },

        /**
         * 打开是否选择的弹框
         */
        openConfirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: $curLocaleNls.basicUtil.js.tips,
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: [$curLocaleNls.basicUtil.js.no, $curLocaleNls.basicUtil.js.yes],
                otherButtonStyles: ['btn-default', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 1) {
                        callback();
                    }
                }
            });
        },
        /**
         * 打开是否选择的弹框
         */
        openDetailConfirm: function (contentTitle, msg, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                detailedMessage: msg,
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 1) {
                        callback();
                    }
                }
            });
        },
        /**
         * 打开是否选择的弹框
         */
        openConfirm2: function (contentTitle, callback1, callback2) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 0) {
                        callback1();
                    }
                    if (index == 1) {
                        callback2();
                    }
                }
            });
        },
        /**
         * 弹出自定义按钮的消息框.
         * @param contentTitle 提示信息
         * @param buttons 提示按钮中文标题集合
         * @param callback1 第一个按钮的回调函数
         * @param callback2 第二个按钮的回调函数
         */
        show2ButtonMsg: function (contentTitle, buttons, callback1, callback2) {
            $dialog.show({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: buttons,
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 0) {
                        $.isFunction(callback1) && callback1();
                    }
                    if (index == 1) {
                        $.isFunction(callback2) && callback2();
                    }
                }
            });
        },
        /**
         * 构建遮罩弹框
         */
        buildPopDiv: function (opt) {
            var that = this;
            if (this.isEmpty(opt)) {
                throw new Error("参数错误：opt为空！无法构建弹框。");
            }
            var defaultOpt = {
                title: '这里显示title', // 弹框title
                showCloseFork: true, // 是否显示右上角×
                maximize: true, // 弹框是否最大化（为true则忽略height,width属性）
                height: 600, // 弹框高度，给定数值（如600）
                width: 1000, // 弹框宽度，给定数值（如1000）
                buttons: [{'id': 'cancelBtn', 'text': '取消'}, {'id': 'saveBtn', 'text': '保存'}],
                buttonStyles: ['btn-default', 'btn-primary']
            };

            var options = $.extend({}, defaultOpt, opt);
            var popHtmls = [];
            popHtmls.push('<div class="modal fade colorModal" id="modal@serialID" role="dialog" aria-labelledby="modalLabel@serialID" data-backdrop="static">');
            // 弹框最大化显示
            if (options['maximize']) {
                popHtmls.push('<div class="modal-dialog" style="width:100%;height:100%">');
            } else {
                // 根据屏幕宽度适应计算宽度
                var _width = that.singleContentWidth(options['width']);
                popHtmls.push('<div class="modal-dialog" style="width:' + _width + 'px">');
            }
            popHtmls.push('<div class="modal-content">');
            popHtmls.push('<div class="modal-header">');
            // 是否显示右上角叉
            if (options['showCloseFork']) {
                popHtmls.push('<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>');
            }
            popHtmls.push('<h4 class="modal-title" id="title">' + options['title'] + '</h4>');
            popHtmls.push('</div>');//modal-header 结束
            if (options['maximize']) {
                var _height = that.fullScreenHeight(true, true);
                popHtmls.push('<div class="modal-body" style="height:' + _height + 'px;overflow:auto;">@respHtml</div>');
            } else {
                var _height = that.singleContentHeight(options['height']);
                popHtmls.push('<div class="modal-body" style="height:' + _height + 'px;overflow:auto;">@respHtml</div>');
            }

            popHtmls.push('<div class="modal-footer">');
            popHtmls.push('<div style="float:right;">');
            // 构建右下角Button
            popHtmls.push(that._buildPopButtons(options));
            popHtmls.push('</div>');
            popHtmls.push('</div>');//modal-footer 结束
            popHtmls.push('</div>');//modal-content 结束
            popHtmls.push('</div>');//modal-dialog 结束
            popHtmls.push('</div>');//modal fade colorModal 结束

            return popHtmls.join('\n');
        },
        /**
         * 构建弹框遮罩右下角Buttons
         */
        _buildPopButtons: function (options) {
            var btnHtmls = [];
            var buttons = options['buttons'];
            var buttonStyles = options['buttonStyles'];
            if (buttons.length != buttonStyles.length) {
                throw new Error("参数错误：buttons定义个数与buttonStyles定义个数不相等。");
            }
            for (var i = 0, j = buttons.length; i < j; i++) {
                var btnStyle = buttonStyles[i];
                var btnId = buttons[i]['id'] + '@serialID';
                var btnText = buttons[i]['text'];
                btnHtmls.push('<button type="button" class="btn ' + btnStyle + '" id="' + btnId + '">' + btnText + '</button>');
            }
            return btnHtmls.join('\n');
        },

        /**
         * 检查页面是否有遮罩
         */
        hasBlockUI: function () {
            var allBlock = $(".overallLoadBox");
            var partBlock = $(".partLoadBox");
            if (this.isEmptyJQuery(allBlock) &&
                this.isEmptyJQuery(partBlock)) {
                return false;
            }

            return true;
        },
        /**
         * 显示BlockUI.
         */
        showBlockUI: function () {
            loading.show();
        },

        /**
         * 隐藏显示BlockUI.
         */
        hideBlockUI: function () {
//    	if( !this.hasBlockUI() ){
//    		return;
//    	}

            loading.hide();
        },
        /**
         * 显示指定ID的遮罩.
         */
        showTargetBlockUI: function (targetID) {
            var opt = {
                container: $('#' + targetID),
                timeout: 10000
            };
            var loading = new PageLoading(opt);
            loading.show();
            return loading;
        },
        /**
         * 隐藏指定ID的遮罩.
         */
        hideTargetBlockUI: function (loading) {
            if (this.isEmpty(loading)) {
                throw new Error("参数错误：target为空。");
            }
            loading.hide();
        },

        /**
         * 显示遮罩层
         */
        showMask: function (target) {
            if (!target) {
                target = $("body");
            }
            var $mask = target.find('.modal-backdrop');
            if ($mask.length) {
                if (!$mask.hasClass('in')) {
                    $mask.addClass('in');
                }
            } else {
                $mask = $('<div class="modal-backdrop in"></div>');
            }
            target.append($mask);
            return $mask;
        },

        /**
         * 隐藏遮罩层
         */
        hideMask: function (target) {
            if (!target) {
                target = $("body");
            }
            var $mask = target.find('.modal-backdrop');
            $mask.length && $mask.remove();
            // 如果有回调函数，则执行
            var callback = arguments[0];
            if (callback && $.isFunction(callback)) {
                callback();
            }
        },
        /**
         * 初始化穿透参数
         * @param throughOpt 穿透参数
         * @returns {string}  穿透URL
         */
        _initThroughOpt: function (throughOpt) {
            var uuid = Math.uuid();
            window["_template_" + uuid] = throughOpt; // 把穿透的参数放到window对象中，在中转页面使用opener获取
            var url = "/grm/account/query/TransferPage.html?ctxuuid=" + uuid; //调用2.0中转页面;
            return url;
        },
        /**
         * 使用新页签方式穿透旧页面（ecp3.0 穿透 ecp2.0 页面）
         * @param url 需要穿透到的2.0页面url
         * @param throughOpt Ecp2.0方式（ecp.ui.layout.Window）打开页面的参数
         */
        throughOldPageInNewWin: function (url, throughOpt) {
            throughOpt.url = url; // 把需要穿透的URL放到穿透参数中
            var throughURL = this._initThroughOpt(throughOpt);
            var title = throughOpt.title || ""; //网页名称，可为空;
            winUtil.openWindow(throughURL, title);
            //window.open(throughURL);
        },
        /**
         * 使用Bootstrap Modal 方式穿透旧页面
         * @param throughOpt Ecp2.0方式（ecp.ui.layout.Window）打开页面的参数
         */
        throughOldPageInModal: function (throughOpt) {
            var throughURL = this._initThroughOpt(throughOpt);
            var modal = this.showIframeModal(throughURL, "", throughOpt.width, throughOpt.height, throughOpt.isTransBg);
            modal.modal({backdrop: "static"});
            if (!throughOpt.onBeforeClose) {
                // 当Ecp2.0旧页面关闭的时候，关闭模态窗口
                throughOpt.onBeforeClose = function () {
                    modal.modal('hide');
                };
            }
            if (throughOpt.isTransBg && !throughOpt.onLoad) {
                throughOpt.onLoad = function () {
                    // 样式修正
                    this.container.append('<style>.panel.window .window-header.panel-header {padding: 4px 0px 4px 10px;} body {background: transparent;} .panel.window {box-shadow: none !important;}</style>');
                };
            }
        },
        /**
         * 传入url，在页面已模态iframe形式打开
         * @param url iframe打开地址
         * @param width 模态窗口宽度
         * @param height 模态窗口高度
         * @param isTransBg 模态窗口是否透明
         * @returns {*} 模态窗口对象
         */
        showIframeModal: function (url, popHtml, width, height, isTransBg) {
            var width = width || 720;
            var height = height || 480;
            var popHtml = popHtml || DEFAULT_POP_HTML;
            popHtml = $(popHtml);
            var popHtmlId = popHtml.attr("id");
            var $pop = $("#" + popHtmlId);
            if (this.isEmpty($pop)) {
                $("body").append(popHtml);
            }
            popHtml.find(".modal-dialog").css("width", width + 30);
            if (isTransBg) {
                // 穿透2.0界面不需要显示边框
                popHtml.find(".modal-content").css({
                    "background": "transparent",
                    "border": "none",
                    "box-shadow": "none"
                });
            }
            popHtml.find("iframe").attr({src: url, width: width, height: height});
            popHtml.off("hidden.bs.modal").on("hidden.bs.modal", function () {
                popHtml.remove();
            });
            return popHtml;
        },
        /**
         * 传入url，在页面已模态iframe形式全屏打开
         * @param url iframe打开地址
         * @param title 标题
         * @param option 参数
         * @param clickCallback 点击事件的回调
         * @param hiddenCallback 窗口销毁事件的回调
         */
        showNewIframeModal: function (option, clickCallback, hiddenCallback) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["取消", "保存"],
                otherButtonStyles: ["btn btn-default", "btn btn-primary"],
                clickButton: clickCallback,
                dialogHidden: hiddenCallback
            };
            opt = $.extend(opt, option || {});
            $dialog.window(opt);
        },
        /**
         * 传入url，打开一个不带按钮的窗口
         * @param url iframe打开地址
         * @param title 标题
         * @param option 参数
         * @param clickCallback 点击事件的回调
         * @param hiddenCallback 窗口销毁事件的回调
         */
        showNoBtnIframeModal: function (option, hiddenCallback) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["取消"],
                otherButtonStyles: ["hidden"],
                dialogHidden: hiddenCallback
            };
            opt = $.extend(opt, option || {});
            $dialog.window(opt);
        },
        /**
         *  打开一个全屏Iframe页面（不用默认的关闭，可用otherButtons代替）<br>
         *  @param option 参数<br>
         *  @param exterHtml 全屏子页面左下脚，额外添加Button<br>
         */
        openFullScreeIframe: function (option, exterHtml) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["关闭"],
                otherButtonStyles: ["btn-primary"],
                //-----建议配置的函数属性------
                title: "",
                iframeMode: {
                    "url": "", //访问的页面地址
                    "options": {}
                },
                //-----建议配置的函数回调------
                dialogHidde: function () {
                    return true;/*对话框即将关闭 */
                },
                dialogHidden: function () {/*对话框已经关闭 */
                },
                clickButton: function (sender, modal, index) {
                    modal.modal('hide');
                }
            };
            opt = $.extend(opt, option || {});
            var win = $dialog.window(opt);
            if (!this.isEmpty(exterHtml)) {
                win.find(".modal-footer").children().first().before(exterHtml);
            }
        },
        /***
         * 获取ecm附件输入框的值。
         * @param attachment 附件对象
         */
        getEcmjcfjText: function (attachment) {
            if (!attachment || !attachment.textControl) {
                throw new Error("参数错误：非ecm附件对象。");
            }
            var ecmText = $(attachment.textControl).val();
            return ecmText;
        },
        /**
         * 为ID添加serialID
         * @param ids
         * @param serialID
         *
         * ("xmlx", 123)-> "xmlx123"
         * (["xmlx", "xmlb"], 123) -> ["xmlx123", "xmlb123"]
         */
        addSerialID: function (ids, serialID) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return null;
            }

            var that = this;
            if ($.isArray(ids)) {
                for (var i = 0, j = ids.length; i < j; i++) {
                    ids[i] = ids[i] + serialID;
                }
                return ids;
            }

            return ids + serialID;
        },
        /**
         * 清除qzz表格选中行的单元格值
         */
        clearCellValue: function (grid, fields) {
            if (grid == null) {
                throw new Error("参数错误：grid为空。");
            }
            if (this.isEmpty(fields)) {
                throw new Error("参数错误：fields为空。");
            }

            // 字符串转换为数组
            if (!$.isArray(fields)) {
                fields = fields.split(',');
            }
            $.each(fields, function (i, field) {
                grid.setValue(field, '');
            });
        },
        /**
         * 清空页面控件值
         * @param ctrl 缓存业务组件的Controller
         * @param ids 需要清空的ids
         * @param container 容器
         */
        clearValue: function (ctrl, ids, container) {
            if (this.isEmpty(ctrl) || this.isEmpty(ids)) {
                throw new Error("参数错误：ctrl or ids为空。");
            }

            var that = this;
            if (this.isEmpty(container)) {
                container = $("body");
            }

            ids = this.toArray(ids);
            $.each(ids, function (i, id) {
                var obj = ctrl[id];
                // 业务组件的清空
                if (obj && obj.setValue) {
                    obj.setValue('');
                    that.clearComboxText(container, [id]);
                } else {
                    // jQuery控件的清空
                    $("#" + id, container).val('');
                }
            });
        },
        /**
         * 获得焦点选中文本.
         */
        bindFocusSelect: function () {
            $("input[type='text']").on("focus", function () {
                this.select();
            });
        },
        /**
         * 输入框绑定change事件
         * @param ids
         * @param container
         * @param serialID
         */
        bindTextChange: function (ids, container, serialID) {
            var that = this;
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            // DOM绑定观察者
            if (!$.isArray(ids)) {
                ids = ids.split(",");
            }
            $.each(ids, function (i, id) {
                var obj = $("#" + id);
                var length = obj.attr("_length");
                if (obj.length > 0) {
                    obj.on("input propertychange", function () {
                        var curVal = obj.val() || '';
                        if (curVal.length > length) {
                            obj.val(curVal.substring(0, length));
                        }
                    });
                }
            });
        },
        /**
         * 管理对象等控件通过[更多]选择后，样式强制加underline<br>
         * 注意： plus_5.1需要使用，5.2不需要控制。<br>
         */
        bindAddUnderline: function (ids, container) {
            var that = this;
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }

            var addUnderlineStyle = function (domID) {
                setTimeout(function () {
                    $("#" + domID, container).addClass('form-control input_underline');
                }, 100);
            };

            // 低版本兼容处理
            var MutationObserver = window.MutationObserver ||
                window.WebKitMutationObserver ||
                window.MozMutationObserver;
            // 新建观察者对象
            var observer = new MutationObserver(function (records, mo) {
                records.forEach(function (record) {
                    addUnderlineStyle(record.target.id);
                });
            });
            // 观察者配置
            var config = {attributes: true, childList: true, characterData: true};
            // DOM绑定观察者
            if (!$.isArray(ids)) {
                ids = ids.split(",");
            }
            $.each(ids, function (i, id) {
                var obj = $("#s2id_" + id + "_render");
                if (obj.length > 0) {
                    observer.observe(obj[0], config);
                }
            });
        },
        /**
         * 业务控件动态添加'input_underline'样式
         *
         * @param container 查找容器
         * @param ids 控件id属性 支持如下参数
         * 1、'xmmc'
         * 2、'xmmc,dxgc'
         * 3、['xmmc','dxgc']
         */
        addUnderline: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                $("#s2id_" + id + "_render", container).addClass('form-control input_underline');
            });
            this.bindAddUnderline(ids, container);
        },
        /**
         * 业务控件动态添加'border-radius: 20px;'样式
         */
        addBorderRadius: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                var pobj = $("#s2id_" + id + "_render");
                pobj.css({"border-radius": "20px"});
                pobj.children("a:first").css({"border-radius": "20px"});
                //业务组件
                pobj.find("ul:first").css({"border-radius":"20px"});
//			//comboBox下来框
//			pobj.children("a:first").css({"border-radius":"20px"});
            });
        },
        /**
         * 业务控件动态添加选中后删除图标'x'
         */
        addSelectClose: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                var pobj = $("#s2id_" + id + "_render", container);
                var str = '<i class="fa fa-times"></i>';
                // comboBox下拉框添加删除图标
                pobj.children("a").children("abbr").html(str);
                // 删除图标添加鼠标悬停事件
                pobj.children("a").bind('mouseover', function () {
                    if (!$(this).hasClass("select2-default")) {
                        $(this).children("abbr").css({"display": "inline-block", "top": "3px", "color": "#aaa"});
                    }
                });
                pobj.children("a").bind('mouseout', function () {
                    $(this).children("abbr").css({"display": "none"});
                });
            });
        },
        /**
         * 清除管理对象多选时显示的提示信息（如：已选择2个）
         */
        clearComboxText: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                var gldxContainer = $("#s2id_" + id + "_render", container);
                gldxContainer.find(".selNumDiv").hide();
                gldxContainer.find(".select2-search-field").show();
            });
        },
        /**
         * 按钮点击后，状态的切换
         */
        switchClickBtn: function (id, container) {
            if (container == null) {
                container = $("body");
            }
            var btnObj = $("#" + id, container);
            btnObj.attr("disabled", true);
            setTimeout(function () {
                btnObj.removeAttr("disabled");
            }, 500);
        },
        /**
         * 禁用附件按钮
         * @param ids 数组或逗号连接的字符串
         * @param serialID 单屏序列号
         */
        disableAttachBtn: function (id, serialID) {
            var that = this;
            if (this.isEmpty(id)) {
                throw new Error("参数错误：id为空。");
            }
            //serialID 默认空串
            if (this.isEmpty(serialID)) {
                serialID = '';
            }

            var realID = id + serialID + "_text";
            // 附件控件是否已经初始化完成
            var funcObj = {
                'checkFunc': function () {
                    var jqObj = $("#" + realID);
                    if (!that.isEmptyJQuery(jqObj)) {
                        return true;
                    }
                    return false;
                },
                'sucFunc': function () {
                    var attachBtn = $("#" + realID).parent().find(".attachBtn");
                    attachBtn.off("click");
                    attachBtn.unbind("click");
                },
                'failFunc': function () {
                }

            };
            this.execFuncByWait(funcObj, 100, 0, 70);
        },
        /**
         * 禁用控件（input & 业务组件）
         * @param ctrl 存储业务组件的对象
         * @param ids 数组或逗号连接的字符串
         * @param serialID 单屏序列号
         */
        disableElement: function (ctrl, ids, serialID) {
            var that = this;
            if (null == ctrl) {
                throw new Error("参数错误：ctrl为空。");
            }
            if (this.isEmpty(ids)) {
                throw new Error("参数错误：ids为空。");
            }
            //serialID 默认空串
            if (this.isEmpty(serialID)) {
                serialID = '';
            }

            ids = this.toArray(ids);
            $.each(ids, function (i, id) {
                var component = ctrl[id];
                if (component) {
                	// input控件
                    if (component.tagName && component.tagName == "INPUT") {
                        $('#' + id + serialID).attr("disabled", true);
                        return;
                    } 
                	
                    // comboBox
                    if (component.disable) {
                        component.disable();
                    } else if (that._isNumberBox(component)) {
                        // 金额控件特殊处理--input控件
                        $('#' + id + serialID).attr("disabled", true);
                    } else {
                        // 业务组件
                        that.setBizStatus(id, '0');
                    }
                } else {
                    // input控件
                    $('#' + id + serialID).attr("disabled", true);
                }
            });
        },
        /**
         * 是否为金额组件
         */
        _isNumberBox: function (component) {
            if (component && component.option) {
                var opt = component.option;
                if (!this.isEmpty(opt['mask'])) {
                    return true;
                }
            }
            return false;
        },
        /**
         * 启用控件（input & 业务组件）
         * @param ctrl 存储业务组件的对象
         * @param ids 数组或逗号连接的字符串
         */
        enableElement: function (ctrl, ids) {
            var that = this;
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            ids = this.toArray(ids);
            $.each(ids, function (i, id) {
                var component = ctrl[id];
                if (component) {
                	// input控件
                    if (component.tagName && component.tagName == "INPUT") {
                    	 $('#' + id).removeAttr("disabled");
                        return;
                    } 
                	
                    // comboBox
                    if (component.enable) {
                        component.enable();
                    } else {
                        // 业务组件
                        that.setBizStatus(id, '1');
                    }
                } else {
                    // input控件
                    $('#' + id).removeAttr("disabled");
                }
            });
        },
        /**
         * 设置业务控件状态（是否可用）
         * @param ids 数组或逗号连接的字符串
         * @param sta （1-可用；0-禁用）
         */
        setBizStatus: function (ids, sta) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            // 字符串转换为数组
            if (!$.isArray(ids)) {
                ids = ids.split(",");
            }
            if ("1" == sta) {
                $.each(ids, function (i, id) {
                    $("#" + id)[0].comboBox.enable();
                });
            } else if ("0" == sta) {
                $.each(ids, function (i, id) {
                    $("#" + id)[0].comboBox.disable();
                });
            } else {
                this.dialog("参数错误：sta必须为（0-1）。");
            }

        },
        /**
         * 禁用页面所有控件
         */
        disabledAll: function () {
            // 普通控件(文本，数值，日期)
            $(".general").each(function (i, n) {
                $("#" + n.id).attr("disabled", true);
            });
            // 基于comboBox封装的控件(ecpgldxselect，ecpfltxselect，ecpunitselect)
            $(".ecp-unit,.ecp-fltx").each(function (i, n) {
                $("#" + n.id)[0].comboBox.control.select2("disable");
            });
            // 基于select2封装的控件(jjgk.common.enum，jjgk.custom.enum,gldxselect)
            $(".ecp-gldx,.jjgk-enum").each(function (i, n) {
                $("#" + n.id).select2("disable");
            });
        },
        /**
         * 解析组件html
         * @param template 模板html
         * @param resp ajax返回的html页面
         * @param serialID 需要替换的序列号
         */
        parseComponentHtml: function (template, resp, serialID) {
            // 当模板为空时
            if (null == template) {
                var html = resp.replace(/@serialID/g, serialID);
            } else {
                var html = template.replace(/@respHtml/g, resp);
                html = html.replace(/@serialID/g, serialID);
            }
            return html;
        },
        /**
         * 查询条件-->更多/收起 绑定事件
         * @param moreFunc 更多时的回调
         * @param backFunc 收起时的回调
         * @param container 容器
         */
        bindQueryInnerClick: function (moreFunc, backFunc, container) {
            var that = this;
            if (this.isEmpty(container)) {
                container = $("body");
            }
            //查询区域内部收缩展开
            var queryInner = $(".query_inner", container);
            queryInner.click(function () {
                var queryInnerZone = $(this).closest("table").find(".query_inner_zone");
                var queryInnerSpan = $(this).find("span");
                if (queryInner.hasClass("shrink")) {
                    queryInnerZone.hide();
                    queryInner.removeClass("shrink").addClass("expand");
                    queryInnerSpan.html("更多");
                    // 显示【更多】，页面额外处理
                    if (!that.isEmpty(moreFunc)) {
                        moreFunc();
                    }
                } else if (queryInner.hasClass("expand")) {
                    queryInnerZone.show();
                    queryInner.removeClass("expand").addClass("shrink");
                    queryInnerSpan.html("收起");
                    // 显示【收起】，页面额外处理
                    if (!that.isEmpty(backFunc)) {
                        backFunc();
                    }
                } else {
                    return;
                }
            });
        },
        /**
         * 针对[查询条件/qzz表格]提供的简化版bindQueryInnerClick
         * @param grid qzz表格
         * @param chgHeight 变化的高度（数字）
         * @param container 容器
         */
        bindQzzQueryInnerClick: function (grid, chgHeight, container) {
            var that = this;
            if (this.isEmpty(container)) {
                container = $("body");
            }

            var moreFunc = function () {
                that._qzzHeightChange(grid, chgHeight, container);
            };
            var backFunc = function () {
                that._qzzHeightChange(grid, -chgHeight, container);
            }
            this.bindQueryInnerClick(moreFunc, backFunc, container);
        },
        /**
         * 改变qzz表格和封装器的高度
         */
        _qzzHeightChange: function (grid, chgHeight, container) {
            var qzzWrapper = $(".qzz-wrapper", container);
            var wrapHeight = qzzWrapper.height();
            var qzzHeight = grid.getHeight();

            grid.setHeight(qzzHeight + chgHeight);
            setTimeout(function () {
                qzzWrapper.css("height", wrapHeight + chgHeight);
            }, 100);
        },
        /**
         * 设置qzz对应的Wrapper的高度
         */
        setQzzWrapperHeight: function (height) {
            //设置qzztable外面div高度
            function windowAlign() {
                var winH = $(window).height();
                $(".qzz-wrapper").css("height", winH - height);
            }

            windowAlign();
            // 当调整窗口的时候动态修正位置
            $(window).resize(function () {
                windowAlign();
            });
        },
        /**
         * 删除qzz表格行数据（delEcpRowData对多条记录删除有问题）
         * @param grid
         * @param rowIds （支持1、"122484877", 2、"245778788,25656566", 3、["245778788","25656566"]）
         */
        delQzzRowData: function (grid, rowIds) {
            if (grid == null || this.isEmpty(rowIds)) {
                throw new Error("参数错误：grid or rowIds为空。");
            }
            rowIds = this.toArray(rowIds);
            $.each(rowIds, function (i, rowId) {
                grid.delEcpRowData(rowId);
            });
        },
        /**
         * 多选表格强制选择一条记录.
         * @param grid 表格对象.
         */
        getSelectedOnlyOne: function(grid) {
        	var that = this;
        	if (grid == null) {
                throw new Error("参数错误：grid为null。");
            }
        	var selDatas = grid.getSelectedRowData();
        	if (that.isEmpty(selDatas) || selDatas.length > 1) {
        		that.notify($curLocaleNls.basicUtil.js.selectone);
        		return null;
        	} 
        	
        	return selDatas[0];
        },
        /**
         * 定位-向上移动
         * @param numText {num:1, count:6}
         * @param jstreeID
         * @param serialID
         *
         * 限制：textNumber、mainContainer这两个id必须固定
         */
        locateUp: function (numText, jstreeID, serialID) {
            if (numText['count'] == 0) {
                return;
            }
            numText['num'] = numText['num'] - 1;
            if (numText['num'] < 1) {
                numText['num'] = numText['count'];
            }

            var num = numText['num'];
            var count = numText['count'];
            // serialID缺失时，默认''
            if (this.isEmpty(serialID)) {
                serialID = '';
            }

            var mainContainer = $("#mainContainer" + serialID);
            var height = Math.ceil(mainContainer.height() * 0.75);
            $('#textNumber' + serialID).text(num + '/' + count);
            var searched = $('#' + jstreeID + serialID).find(".jstree-search");
            searched.each(function (i, v) {
                if ((i + 1) == num) {
                    v.focus();
                    var p = $(v).position();//{top:48, left:72}
                    if (p.top < height) {
                        mainContainer.animate({scrollTop: 0}, "fast");
                    } else {
                        var scroll = p.top - height;
                        mainContainer.animate({scrollTop: scroll}, "fast");
                    }
                    $(v).css("background-color", "#FFCC00");
                } else {
                    $(v).removeAttr("style");
                }

            });
        },
        /**
         * 定位-向下移动
         * @param numText {num:1, count:6}
         * @param jstreeID
         * @param serialID
         *
         * 限制：textNumber、mainContainer这两个id必须固定
         */
        locateDown: function (numText, jstreeID, serialID) {
            if (numText['count'] == 0) {
                return;
            }
            numText['num'] = numText['num'] + 1;
            if (numText['num'] > numText['count']) {
                numText['num'] = 1;
            }

            var num = numText['num'];
            var count = numText['count'];
            // serialID缺失时，默认''
            if (this.isEmpty(serialID)) {
                serialID = '';
            }

            var mainContainer = $("#mainContainer" + serialID);
            var height = Math.ceil(mainContainer.height() * 0.75);
            $('#textNumber' + serialID).text(num + '/' + count);
            var searched = $('#' + jstreeID + serialID).find(".jstree-search");
            searched.each(function (i, v) {
                if ((i + 1) == num) {
                    v.focus();
                    var p = $(v).position();//{top:48, left:72}
                    if (p.top > height) {
                        var scroll = p.top - height;
                        mainContainer.animate({scrollTop: scroll}, "fast");
                    } else {
                        mainContainer.animate({scrollTop: 0}, "fast");
                    }
                    //background-color:#FFCC00;
                    $(v).css("background-color", "#FFCC00");
                } else {
                    $(v).removeAttr("style");
                }

            });
        },
        /**
         * 清除定位样式
         */
        locateClearStyle: function (jstreeID, serialID) {
            $('#' + jstreeID + serialID).find("a").removeAttr("style");
        },
        /**
         * 全屏dialog的width&height.
         */
        fullDialogStyle: function () {
            var win = $(window);
            var height = win.height() - 2;
            var width = win.width() - 2;
            var style = "height:" + height + "px;width:" + width + "px;";
            return style;
        },
        /**
         * 供应链金融新UI-计算单页组件的全屏高度
         * @param hasHeader 是否包含头部
         * @param hasFooter 是否包含底部
         */
        fullDialogHeight: function (hasHeader, hasFooter) {
            var height = $(window).height();
            var headerHeight = 0;
            var footerHeight = 0;
            if (hasHeader) {
                headerHeight = 56;
            }
            if (hasFooter) {
                footerHeight = 65;
            }
            return height - headerHeight - footerHeight - 8;
        },
        /**
         * 计算单页组件的全屏高度
         * @param hasHeader 是否包含头部
         * @param hasFooter 是否包含底部
         */
        fullScreenHeight: function (hasHeader, hasFooter) {
            var height = $(window).height();
            var headerHeight = 0;
            var footerHeight = 0;
            if (hasHeader) {
                headerHeight = 56;
            }
            if (hasFooter) {
                footerHeight = 65;
            }
            return height - headerHeight - footerHeight - 2;
        },
        /**
         * 单页content高度（高度超过webkit，需要处理）
         */
        singleContentHeight: function (height) {
            height = height || 0;
            var winHeight = $(window).height();
            var contentHeight = winHeight - 56 - 65 - 2;
            if (height > contentHeight) {
                return contentHeight;
            }
            return height;
        },
        /**
         * 单页content宽度（高度超过webkit，需要处理）
         */
        singleContentWidth: function (width) {
            width = width || 0;
            var winWidth = $(window).width();
            var contentWidth = winWidth - 10;
            return Math.min(contentWidth, width);
        },
        /**
         * 是否添加单页
         */
        isAddSingle: function (opt) {
            if (null == opt) {
                throw new Error("参数错误：opt为空。");
            }
            var actionType = opt['actionType'];
            if ("Add" === actionType) {
                return true;
            }
            return false;
        },
        /**
         * 是否修改单页
         */
        isUpdateSingle: function (opt) {
            if (null == opt) {
                throw new Error("参数错误：opt为空。");
            }
            var actionType = opt['actionType'];
            if ("Update" === actionType) {
                return true;
            }
            return false;
        },
        /**
         * 是否穿透显示单页
         */
        isShowSingle: function (opt) {
            if (null == opt) {
                throw new Error("参数错误：opt为空。");
            }
            var actionType = opt['actionType'];
            if ("Show" === actionType) {
                return true;
            }
            return false;
        },
        /**
         * 获取单页的title
         */
        getSingleTitle: function (opt, title) {
            if (null == opt || title == null) {
                throw new Error("参数错误：opt or title为空。");
            }
            if (this.isAddSingle(opt)) {
                return "新增" + title;
            } else if (this.isUpdateSingle(opt)) {
                return "修改" + title
            }
            return "查看" + title;
        },

        /**************************************************************页面样式/弹框/窗口等-END***************************************************************/



        /**************************************************************ajax工具方法-START***************************************************************/
        /**
         * 对象转换为URL参数.
         */
        toURLParam: function(obj) {
        	var that = this;
        	if (this.isEmpty(obj)) {
        		return "";
        	}
        	var arr = [];
        	for (var key in obj) {
        		var val = obj[key];
        		if (val == null) {
        			continue;
        		}
        		// 如果为对象，需要转换为字符串.
        		if (!that.isPrimitive(val)) {
        			arr.push(key+"="+encodeURIComponent(JSON.stringify(val)));
        		} else {
        			arr.push(key+"="+encodeURIComponent(obj[key]));
        		}
        	}
        	return arr.join("&");
        },
        /**
         * 分页表格展示.
         * @param grid 表格.
         * @param pageIndex 当前页.
         * @param resp 返回数据.
         */
        drawPageGrid: function(grid, pageIndex, respData) {
        	grid.value(respData['content']);
        	//false:关闭onPageChanged，否则会执行2次查询。
        	grid.setPageIndex(pageIndex, false);
            grid.setTotalRecord(respData["totalElements"], false);
        },
        /**
         * 检查是否错误数据.
         * {status: 200, errCode: "", errMsg: "参数value为空。", moreInfoUrl: "mailto:support@ygsoft.com"}
         */
        isErrorData : function(respData) {
        	if (null == respData) {
        		return false;
        	}
        	var errCode = respData.hasOwnProperty("errCode");
        	var errMsg = respData.hasOwnProperty("errMsg");
        	return errCode && errMsg;
        },
        /**
         * 防止重复操作-根据变量状态.
         * @param controller 调用者.
         * @param func 处理函数.
         */
        preventRepeatWithState: function(controller, func) {
        	return function() {
        		if (controller["_submitState"]) {
        			console.log("preventRepeat!");
        			return;
        		}
        		controller["_submitState"] = true;
        		setTimeout(function() {
        			controller["_submitState"] = false;
            	}, 1000);
        		var args = [];
        		for(var attr in arguments) {
        			args.push(arguments[attr]);
        		}
        		func.apply(controller, args);
        	};
        },
        /**
         * 防止重复提交.
         * @param ids
         * @param container
         * @param serialID
         */
        preventRepeat: function (ids, container, serialID) {
            if (this.isEmpty(ids)) {
                throw new Error("参数错误：ids为空。");
            }

            if (this.isEmpty(container)) {
                container = $("body");
            }

            //serialID 默认空串
            if (this.isEmpty(serialID)) {
                serialID = '';
            }
            ids = this.toArray(ids);
            //禁用按钮
            $.each(ids, function (i, id) {
                $('#' + id + serialID).attr("disabled", true);
            });

            //启用按钮
            setTimeout(function () {
                $.each(ids, function (i, id) {
                    $('#' + id + serialID).attr("disabled", false);
                });
            }, 1000)
        },

        /**
         * 根据ids切分为50个一次，多批次查询返回数据.
         * @param url the url.
         * @param ids the ids.
         */
        synGetByIds: function (url, ids) {
            var that = this;
            if (this.isEmpty(url)) {
                throw new Error("参数错误：url为空。");
            }
            if (this.isEmpty(ids)) {
                throw new Error("参数错误：ids为空。");
            }

            var results = [];
            var idArr = this.toArray(ids);
            var groupArr = this.splitArray2Group(idArr, 50);
            for (var i = 0, j = groupArr.length; i < j; i++) {
                var curArr = groupArr[i];
                var curGids = curArr.join(',');
                var curUrl = url + "?gids=" + curGids;
                var rstArr = that.synGet(curUrl);
                //将查询到的数据合并.
                if (!that.isEmpty(rstArr)) {
                    for (var m = 0, n = rstArr.length; m < n; m++) {
                        results.push(rstArr[m]);
                    }
                }
            }

            return results;
        },

        /**
         * 将数组切割为指定groupSize的多个数组.
         * @param arr 数组.
         * @param groupSize 分组后数组大小.
         */
        splitArray2Group: function (arr, groupSize) {
            var that = this;
            if (this.isEmpty(arr)) {
                throw new Error("参数错误：arr为空。");
            }
            if (this.isEmpty(groupSize)) {
                throw new Error("参数错误：groupSize为空。");
            }
            if (groupSize < 1) {
                throw new Error("参数错误：groupSize必须大于等于1。");
            }

            var rstArr = [];
            for (var i = 0, j = arr.length; i < j; i += groupSize) {
                var lastIndex = Math.min(groupSize + i, j);
                var groupArr = arr.slice(i, lastIndex);
                rstArr.push(groupArr);
            }

            return rstArr;
        },

        /**
         * 同步的Get请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param hasBlockUI 是否显示加载画面
         */
        synGet: function (url, hasBlockUI) {
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            try {
                var result = ecp.RemoteService.doGet(url, null);
            } catch (e) {
                // ajax异常-默认关闭遮罩，避免多次交互下遮罩不关闭。
                this.hideBlockUI();
                throw new Error("程序发生错误：" + e.message);
            } finally {
                if (hasBlockUI) {
                    this.hideBlockUI();
                }
            }

            return result;
        },
        /**
         * 异步的Get请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param callback 返回结果后回调处理
         * @param hasBlockUI 是否显示加载画面
         * @param targetID 遮罩模板ID.
         */
        asynGet: function (url, callback, hasBlockUI, targetID) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                //全屏遮罩.
                if (this.isEmpty(targetID)) {
                    this.showBlockUI();
                } else {
                    var blockObj = this.showTargetBlockUI(targetID);
                }
            }

            // 后台调用
            ecp.RemoteService.doGetAsync(url, null, function (result) {
                if (hasBlockUI) {
                    //全屏遮罩.
                    if (that.isEmpty(targetID)) {
                        that.hideBlockUI();
                    } else {
                        blockObj.hide();
                    }
                }
                if (result.isSuccess()) {
                	if (that.isErrorData(result.data)) {
                		var errInfo = that._parseErrorMsg(result.data);
                		that.dialog(errInfo.errMsg);
                		return;
                	}
                	//---------------正常数据返回处理--------------
                    var respData = {};
                    if (!that.isEmpty(result.data)) {
                        // 初始化主表数据
                        respData = result.data;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    that.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        
        /**
         * 异步的Get请求（分页查询）--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param callback 返回结果后回调处理
         * @param hasBlockUI 是否显示加载画面
         */
        asynGetPage: function (url, callback, hasBlockUI) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            ecp.RemoteService.doGetAsync(url, null, function (result) {
                if (hasBlockUI) {
                    that.hideBlockUI();
                }
                if (result.isSuccess()) {
                    var respData = {};
                    if (result.data != null && !that.isEmpty(result.data.content)) {
                        // 初始化主表数据
                        respData = result.data.content;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    that.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        /**
         * 同步的Post请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param requestParam 请求参数
         * @param hasBlockUI 是否显示加载画面
         */
        synPost: function (url, requestParam, hasBlockUI) {
            var that = this;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
                this.showBlockUI();
            }

            // 后台调用
            try {
                var result = ecp.RemoteService.doPost(url, requestParam);
            } catch (e) {
                // ajax异常-默认关闭遮罩，避免多次交互下遮罩不关闭。
                this.hideBlockUI();
                throw new Error("程序发生错误：" + e.message);
            } finally {
                if (hasBlockUI) {
                    this.hideBlockUI();
                }
            }

            return result;
        },
        /**
         * 异步的Post请求--控制是否遮罩<br>
         *
         * @param url 调用URL
         * @param requestParam 请求参数
         * @param callback 请求完后回调
         * @param hasBlockUI 是否显示加载画面
         */
        asynPost: function (url, requestParam, callback, hasBlockUI) {
            var that = this;
            var util = window.top.abcUtil || that;
            // 没有给定参数值，默认不显示加载等待画面...
            if (!hasBlockUI) {
                hasBlockUI = false;
            }
            var that = this;
            if (hasBlockUI) {
            	util.showBlockUI();
            }

            // 后台调用
            ecp.RemoteService.doPostAsync(url, requestParam, function (result) {
                if (hasBlockUI) {
                	util.hideBlockUI();
                }
                if (result.isSuccess()) {
                    var respData = {};
                    if (!that.isEmpty(result.data)) {
                        // 初始化主表数据
                        respData = result.data;
                    }
                    $.isFunction(callback) && callback.call(this, respData);
                } else {
                    var errInfo = that._parseErrorMsg(result.data);
                    util.dialog(errInfo.errMsg);
                    ecp.Log.error("程序发生错误: " + result.data);
                }
            });
        },
        /**
         * 解析错误信息.
         */
        _parseErrorMsg: function (errInfo) {
            if (typeof (errInfo) == "string") {
            	if (errInfo.startWith("<html>")) {
            		// 可能掉线返回拦截页面.
            		errInfo = {'errMsg': "对不起，您访问的服务不可用，请联系系统管理员。"};
            	} else {
            		errInfo = JSON.parse(errInfo);
            	}
            }
            return errInfo;
        },
        /**
         * 通过cookie参数判断是否设置了关键信息加密.
         */
        _isEncodeKeyInfoByCookie: function() {
        	return $.cookie("_isEncodeUserKeyInformation_Storage") == "true";
        },
        /**
         * 初始化扩展上下文.
         * @param url 扩展上下文请求地址.
         * @param ecpLoginContext ECP原始上下文对象.
         */
        initExtendLoginContext: function(url, ecpLoginContext) {
        	var that = this;
        	if (this.isEmpty(url)) {
                throw new Error("参数错误：url为空。");
            }
        	if (this.isEmpty(ecpLoginContext)) {
                throw new Error("参数错误：ecpLoginContext为空。");
            }
            // 后台调用
            try {
                var result = ecp.RemoteService.doPost(url, ecpLoginContext);
                
                // 判断是否已标记加密
            	if (that._isEncodeKeyInfoByCookie()) {
            		that.decryptUserVO(result); // 假装是userVO
            	}
                
            	// 绑定到jStorage中
            	that.setLoginContext(null, result);
            } catch (e) {
                throw new Error("程序发生错误：" + e.message);
            } 
        },
        /**
         * 检查session是否有效(是否已登录).
         */
        checkSession : function(token) {
        	// 没有超时返回：{}
        	// 超时返回：｛"LOG_DESC", "会话超时。"｝
        	token = token || this.getEcpToken();
        	if (this.isEmpty(token)) {
        		console.info("token为空。");
        		return false;
        	}
        	// 1、如果是session过期.
        	var res = this.synPost("/validsession?tokenid=" + token, []);
        	if (res.LOG_DESC) {
        		console.info(res.LOG_DESC);
        		return false;
        	}
        	
        	// 2、如果是正常退出，而token还有.
        	var cxt = this.getContext();
        	if (cxt == null) {
    			return false;
    		}
    		var userName = cxt.userName;
    		if (userName == null) {
    			return false;
    		}
        	return true;
        },
        
        /**
         * 过期清理token.
         */
        clearToken: function() {
        	var token = this.getEcpToken();
        	if (token) {
        		var res = ecp.RemoteService.doPost("/validsession?tokenid=" + token, []);
        		if (res && res.LOG_DESC) {
        			document.cookie = "ecpDataContext.tokenId=-1;path=/;";
        		}
        	} else {
        		document.cookie = "ecpDataContext.tokenId=-1;path=/;";
        	}
        },
        
        /**
         * 获取平台的上下文.
         */
        getContext : function() {
        	var res = this.synPost("/context", []);
        	return res;
        },
        /**
         * 设置登录上下文.
         * @param url 获取上下文的地址
         * @param loginContextVO 登录上下文
         */
        setLoginContext: function (url, loginContextVO) {
        	if (loginContextVO) {
        		this.setLocalStorage(LOGIN_CONTEXT_KEY, loginContextVO);
        	} else {
	            var respData = this.synGet(url);
	            this.setLocalStorage(LOGIN_CONTEXT_KEY, respData);
        	}
        },

        /**
         * 获取登录上下文.
         * @param url 获取上下文的地址，可选
         */
        getLoginContext: function (url) {
            var contextVO = this.getLocalStorage(LOGIN_CONTEXT_KEY);
            if (contextVO) {
                return contextVO;
            } else if (url) {
                this.setLoginContext(url);
                return this.getLocalStorage(LOGIN_CONTEXT_KEY);
            }
            return null;
        },
		/**
		 * 退出.
		 */
		logout: function (callback) {
			var url = "/logout4";
			$.jStorage.set("cacheKey_jstorage_logout", new Date().valueOf());
			ecp.RemoteService.doPostAsync(url, [], function (result) {
				if (result.isSuccess()) {
					if (result.data != null) {
						// 发送退出消息
						$.jStorage.set("cacheKey_jstorage_logout", new Date().valueOf());
					}
					if (callback) {
						callback();
					}
				} else {
					ecp.Log.error("退出失败");
					ecp.Exception.throwError("TC0001", "退出失败", result.data);
				}
			});
		},
        /**
         * 获取配置参数.
         * @param url 访问配置参数url.
         * @param key 参数key.
         */
        getConfigProperty : function(url, key) {
        	if (this.isEmpty(key)) {
        		throw new Error("参数错误：key为空。");
        	}
        	var val = this.getLocalStorage(key);
        	// GongQiang: this.isEmpty(val)对 true/false 判断异常.
        	if (val != null && val != "") {
        		return val;
        	}
        	//var url = "/abc/mapp/ygec/query/sysconfig/get-property?key=" + key;
        	url = url + "?key=" + key;
        	var val = this.synGet(url);
        	this.setLocalStorage(key, val);
        	return val;
        },
        
        /**
         * 是否压力测试.
         * @param url 访问配置参数url.
         */
        isStressTest : function(url) {
        	var value = this.getConfigProperty(url, 'abc.stress.test');
        	if (value == null && value == "") {
        		return false;
        	}
        	// 如果是boolean类型直接返回.
        	if (typeof(value) == "boolean") {
        		return value;
        	}
        	return 'true' == value;
        },
        /**************************************************************ajax工具方法-END***************************************************************/


        /**************************************************************控件辅助工具方法-START***************************************************************/
        /**
         * 根据枚举[OPTION]构造id2mc.
         */
        buildId2mcByOption: function (enumOption) {
            if (this.isEmpty(enumOption)) {
                throw new Error("参数错误：enumOption为空。");
            }

            var id2mc = {};
            for (var i = 0, j = enumOption.length; i < j; i++) {
                var op = enumOption[i];
                id2mc[op.id] = op.text;
            }

            return id2mc;
        },
        /**
         * 根据枚举[RESOURCE]构造id2Url.
         */
        buildId2UrlByResource: function (enumResource) {
            if (this.isEmpty(enumResource)) {
                throw new Error("参数错误：enumResource为空。");
            }

            var id2Url = {};
            for (var i = 0, j = enumResource.length; i < j; i++) {
                var op = enumResource[i];
                id2Url[op.id] = op['url'];
            }

            return id2Url;
        },
        /**
         * 过滤枚举
         * @param enumDatas
         * @param filters
         */
        filterEnum: function (enumDatas, filters) {
            var that = this;
            // 过滤枚举
            if (!this.isEmpty(filters)) {
                if (!$.isArray(filters)) {
                    filters = this.filterArrayBlank(filters.split(","));
                }
                var datas = [];
                $.each(enumDatas, function (i, v) {
                    if (that.inArray(v['id'], filters)) {
                        datas.push(v);
                    }
                });
                enumDatas = datas;
            }
            return enumDatas;
        },
        /**
         * 根据map值构造枚举option.
         * @param enumMap 枚举map数据
         * @param addAllOpt 是否添加【全部】选项
         * @param filters 过滤枚举 支持1、字符串；2、数组。
         */
        buildEnumOptionByMap: function(enumMap, addAllOpt, filters) {
            if (enumMap == null) {
                throw new Error("枚举map为null。");
            }
        	var option = [];
			for (var key in enumMap) {
				option.push({
					id: key,
					text: enumMap[key]
				});
			}
			return this.buildEnumOption(option, addAllOpt, filters);
        },
        /**
         * 构造枚举option
         * @param enumDatas 枚举项数据
         * @param addAllOpt 是否添加【全部】选项
         * @param filters 过滤枚举 支持1、字符串；2、数组。
         */
        buildEnumOption: function (enumDatas, addAllOpt, filters) {
            var that = this;
            var ALL_OPT = {"id": "-1", "text": "全部"};
            //copy
            var resultDatas = [];
            $.each(enumDatas, function (i, v) {
                resultDatas.push(v);
            });

            // 过滤枚举
            if (!this.isEmpty(filters)) {
                if (!$.isArray(filters)) {
                    filters = this.filterArrayBlank(filters.split(","));
                }
                var datas = [];
                $.each(enumDatas, function (i, v) {
                    if (that.inArray(v['id'], filters)) {
                        datas.push(v);
                    }
                });
                resultDatas = datas;
            }

            // 默认不添加【全部】
            if (null == addAllOpt) {
                addAllOpt = false;
            }
            if (addAllOpt) {
                resultDatas.unshift(ALL_OPT);
            }

            var option = {
                'data': resultDatas,
                'allowClear': false
            }
            return option;
        },
        /**
         * 初始化日期控件.
         * @param ids 日期控件ids.
         * @param container dom容器.
         * @param serialID the serialID.
         */
        initDatePicker: function (ids, container, serialID) {
            var that = this;
            if (this.isEmpty(ids)) {
                throw new Error("日期控件初始化失败：ids为空。");
            }
            //dom容器.
            if (this.isEmpty(container)) {
                container = $("body");
            }
            if (this.isEmpty(serialID)) {
                serialID = "";
            }

            var idArr = this.toArray(ids);
            $.each(idArr, function (idx, id) {
                $('#' + id + serialID, container).datetimepicker({
                    format: 'yyyy-mm-dd',
                    autoclose: true,
                    todayBtn: false,
                    minView: 'year',
                    maxView: 'decade',
                    language: 'zh-CN'
                });
            });
        },
        /**************************************************************控件辅助工具方法-END***************************************************************/




        /**************************************************************DataModel工具方法-START***************************************************************/
        /*
	 * isChange(model);
	 * isNewState(obj)
	 * isModifyState(obj)
	 * isNewOrModifyState(obj)
	 * hasOldValueOf(obj, field)
	 * trimDataModel(dm, fields)
	 * trimOnSetModel(dataSource, evt, fields) -- onSetModel时trim字段的值
	 * hasRowChange(rowDatas, fields)
	 */

        /**
         * 判断是否值发生改变（基于双向绑定）
         */
        isChange: function (model) {
            if (this.isEmpty(model._oldValue)) {
                return false;
            } else {
                return true;
            }
        },
        /**
         * 检查modelState状态
         */
        isNewState: function (obj) {
            if (obj && obj.modelState) {
                if ((obj.modelState & 4) === 4) {
                    return true;
                }
                return false;
            } else {
                this.dialog("参数错误：obj或obj.modelState为空。");
                return false;
            }
        },
        /**
         * 检查modelState状态
         */
        isModifyState: function (obj) {
            if (obj && obj.modelState) {
                if ((obj.modelState & 8) === 8 || (obj.modelState & 64) === 64) {
                    return true;
                }
                return false;
            } else {
                this.dialog("参数错误：obj或obj.modelState为空。");
                return false;
            }
        },
        /**
         * 检查modelState状态
         */
        isNewOrModifyState: function (obj) {
            return this.isNewState(obj) ||
                this.isModifyState(obj);
        },
        /**
         * 指定字段是否拥有旧值
         * @obj 用于检测的对象
         * @field 检测的字段
         */
        hasOldValueOf: function (obj, field) {
            //没有旧值
            if (!obj._oldValue) {
                return false;
            }

            //旧值指定属性名称的值为空
            if (this.isEmpty(obj._oldValue[field])) {
                return false;
            }

            return true;
        },
        /**
         * trim指定DataModel内属性的值
         * @param dm DataModel变量
         * @param fields 需要trim的属性（1、函数2、数组3、字符串4、空值）
         */
        trimDataModel: function (dm, fields) {
            var that = this;
            if (this.isEmpty(dm)) {
                this.dialog("参数错误：dm为空。");
                return;
            }
            //4-fields为空，trim所有属性
            if (this.isEmpty(fields)) {
                for (var fld in dm) {
                    dm[fld] = $.trim(dm[fld]);
                }
            }
            var arr = [];
            //1-fields为函数
            if ($.isFunction(fields)) {
                var fs = fields();
                if (!$.isArray(fs)) {
                    arr = fs.split(",");
                } else {
                    arr = fs;
                }
            } else if (!$.isArray(fields)) {
                //3-fields为字符串
                arr = fields.split(",");
            } else {
                //2-fields为数组
                arr = fields;
            }
            //trim指定的属性
            $.each(arr, function (i, f) {
                if (dm[f] != null) {
                    dm[f] = $.trim(dm[f]);
                }
            });
        },
        /**
         * trim指定字段的值--当发生onSetModel事件时
         * @param dataSource
         * @param evt
         * @param fields 需要trim的字段
         */
        trimOnSetModel: function (dataSource, evt, fields) {
            var that = this;
            if (this.isEmpty(fields)) {
                throw new Error("参数错误：fields为空。 ");
            }
            fields = this.toArray(fields);
            var curField = evt.attr;
            if (this.inArray(curField, fields)) {
                dataSource.dataModel[curField] = $.trim(evt.value);
                dataSource.sync([curField]);
            }
        },
        /**
         * table数据是否有【新增】或【修改】
         * @param rowDatas table的数据集
         * @param fileds 1、为空（只要变动操作就算改动，即使又还原了）；2、用于检测的字段（如:['qtyy','bz']），必须是值改动。
         */
        hasRowChange: function (rowDatas, fields) {
            var that = this;
            if (this.isEmpty(rowDatas)) {
                return false;
            }

            //依次检查每行数据.
            for (var i = 0; i < rowDatas.length; i++) {
                var row = rowDatas[i];
                //有【新增】行
                if (that.isNewState(row)) {
                    return true;
                }
                //有【修改】行
                if (row._oldValue) {
                    if (that.isEmpty(fields)) {
                        return true;
                    } else {
                        var oldValue = rowDatas[i]._oldValue;
                        for (var j = 0; j < fields.length; j++) {
                            var field = fields[j];
                            if ((field in oldValue) && oldValue[field] != row[field]) {
                                return true;
                            }
                        }
                    }
                }
            }

            return false;
        },
        /**
         * qzz表格是否改变--
         * 1、新增/删除行记录；
         * 2、字段值改变
         */
        qzzChanged: function (grid) {
            var cs = grid.getChangeSet();
            if (cs.length > 0) {
                return true;
            }
            return false;
        },
        /**
         * 绑定模态框.
         * @param id
         * @param url
         * @param hasBlockUI
         * @param callBack
         */
        bindModal: function (id, url, hasBlockUI, callBack) {
            var that = this;
            var callBackFunc = function (data) {
                $("#" + id).find("input,select").each(function (index, element) {
                    var dataType = element.getAttribute("ng-datatype");
                    var property = element.getAttribute("_datamember");
                    var controlType = element.getAttribute("_controlType");
                    var value = data[property];
                    if (dataType === "date") {
                        value = that.jsonDate2Str(data[property]);
                    }
                    if (controlType === "combo") {
                        var combo = $('#' + id + " [_datamember=" + property + "]").comboBox(true);
                        combo.value(value);
                    } else {
                        $("#" + id + " [_datamember=" + property + "]").val(value);
                    }

                });
            };
            if (typeof (callBack) != "undefined" && !!callBack && $.isFunction(callBack)) {
                callBackFunc = callBack;
            }
            that.asynGet(url, callBackFunc, hasBlockUI);
        },
        /**
         * readonly元素动态绑定title.
         * @param id
         */
        bindMouseOver: function (id) {
            $("#" + id).find("input").each(function(index, element){
                $(element).live('mouseover', function () {
                    $(element).attr('title', $(element).val())
                });
            });
        },

        /**************************************************************DataModel工具方法-END***************************************************************/


        /**************************************************************校验工具方法-START***************************************************************/

        /*
        validateChineseName(chineseName);
        validateCardNo(cardNo);
        */

        /**
         * 校验中文名称.
         *
         * @param chineseName 中文姓名.
         * @returns {boolean}
         */
        validateChineseName: function (chineseName) {
            return /^[\u4e00-\u9fa5]{2,10}$/.test(chineseName);
        },
        /**
         * 校验身份证号码.
         *
         * @param cardNo 身份证号码
         * @returns {boolean}
         */
        validateCardNo: function (cardNo) {
            var length = cardNo.length;
            if (18 === length) {
                if (!/^[1-9]\d{5}(18|19|20)\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$/.test(cardNo)) {
                    return false;
                } else {
                    var arr = cardNo.split("");
                    var code = cardNo.substring(17).toUpperCase();
                    var sum = 0;
                    for (var i = 0; i < 17; i++) {
                        var current = parseInt(arr[i]);
                        sum += current * CARD_FACTOR[i];
                    }
                    var realCode = CARD_PARITY[sum % 11];
                    if (code !== realCode) {
                        return false;
                    }
                }
                // 生日格式
                var date = cardNo.substring(6, 14);
                if (!/^(18|19|20)\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)$/.test(date)) {
                    return false;
                }
                // 省份编号
                var provinceCode = cardNo.substring(0, 2);
                return (PROVINCE_CODE.indexOf(provinceCode) >= 0);
            } else if (15 === length) {
                return /^[1-9]\d{5}\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{2}$/.test(cardNo);
            }
            return false;
        },
        /**
         * 构造查询条件.
         * @param id 控件ID.
         * @param thatObj that对象.
         * @param otherCondition 其他条件对象.
         * @returns {string}
         */
        getQueryCondition: function (id, thatObj, otherCondition) {
            var condition = {};
            var ME = this;
            $("#" + id).find("input").each(function (index, element) {
                var value;
                var datamember = element.getAttribute("_datamember");
                if (ME.isEmpty(datamember)) {
                    datamember = element.id;
                }
                if (element.getAttribute("_controlType") == "combo") {
                    value = thatObj[element.id].getValue();
                } else {
                    value = $(element).val();
                }
                if (!ME.isEmpty(value)) {
                    condition[datamember] = value;
                }
            });
            if(!ME.isEmpty(otherCondition)) {
                condition = $.extend(true,condition, otherCondition);
            }
            return 'filter=' + encodeURIComponent(JSON.stringify(condition)) + '&';
        },
        
        /**
		 * URL参数加密.
		 * @param URL参数. 
		 */  
		encodeURLParam : function(str) {
			/*GongQiang:后台的非空检查不通过了.
			if (this.isEmpty(str) || "{}" === str) {
				return "";
			}*/
			var val = encodeURIComponent(str);
			// return base64Util.base64encode(val);
			// 升级到6.7.0之后，由于不能开启security.check，需要再加一次encodeURIComponent
			return encodeURIComponent(base64Util.base64encode(val));
		},
		/**
		 * Url参数16进制编码.
		 */
		encodeHexUrlParam : function(str) {
			/*
			if (this.isEmpty(str) || "{}" === str) {
				return "";
			}*/
			return this.toHexString(str);
		},
		/**
		 * 字符串转16进制编码字符串.
		 */
		toHexString: function (utf8Str) {
			var latin1Str = unescape(encodeURIComponent(utf8Str));
			var wordArray = this._toWordArray(latin1Str);
			// Shortcuts
			var words = wordArray.words;
			var sigBytes = wordArray.sigBytes;
			
			// Convert
			var hexChars = [];
			for (var i = 0; i < sigBytes; i++) {
				var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
				hexChars.push((bite >>> 4).toString(16));
				hexChars.push((bite & 0x0f).toString(16));
			}
			var hexStr = hexChars.join('');
			return hexStr.toUpperCase();
		},
		/**
		 * base64编码的字符串转WordArray.
		 */
		_toWordArray : function(latin1Str) {
            // Shortcut
            var latin1StrLength = latin1Str.length;

            // Convert
            var words = [];
            for (var i = 0; i < latin1StrLength; i++) {
                words[i >>> 2] |= (latin1Str.charCodeAt(i) & 0xff) << (24 - (i % 4) * 8);
            }
			var wordArray = {
				'words': words,
				'sigBytes': latin1StrLength
			};
			return wordArray;
		},
		
        /**
         * 构建范围日期控件.
         * @param start 起始ID.
         * @param end 截止ID.
         * @param otherOptions 覆盖选项.
         */
        buildDateRange: function(start, end, otherOptions) {
            var startId = "#" + start;
            var endId = "#" + end;
            var options = {
                format: 'yyyy-mm-dd',
                pickerPosition: "bottom-right",
                autoclose: true,
                todayBtn: true,
                startView: 'month',
                minView: 'month',
                maxView: 'decade',
                language: 'zh'
            }
            options = $.extend(true,options, otherOptions);
            $(startId).datetimepicker(options);
            $(endId).datetimepicker(options);

            $(startId).on("change", function () {
                $(endId).data("datetimepicker").setStartDate($(startId).val());
            });

            $(endId).on("change", function () {
                $(startId).data("datetimepicker").setEndDate($(endId).val());
            });
        },
        /**
         * 重置时间范围控件.
         * @param start 起始ID.
         * @param end 截止ID.
         */
        resetDateRange: function(start, end) {
            var startId = "#" + start;
            var endId = "#" + end;
            $(startId).val('');
            $(endId).val('');
            $(endId).data("datetimepicker").setStartDate('');
            $(startId).data("datetimepicker").setEndDate('');
        },
        
        /**
         * 检测脚本攻击.
         * @content 检测内容
         * @return 例：{success: false, msg: "<>&"}.
         */
        checkScriptAttack: function(content) {
        	var ret = { success: true };
        	if (ecpUtils.isEmpty(content)) {
        		return ret;
        	}
        	var msg = "";
        	var arr = ["<", ">", "&"];
        	for (var i = 0, len = arr.length; i < len; i ++) {
        		msg += arr[i];
        		if (content.indexOf(arr[i]) > -1) {
        			ret.success = false;
        		}
        	}
        	if (!ret.success) {
        		ret.msg = msg;
        	}
        	return ret;
        }
        /**************************************************************校验工具方法-END***************************************************************/
    };

    return new CommUtil();
});