/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.VoucherFileInfo;
import api.loader.OFDLoader;
import api.tools.PDFTool;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.convert.DomToJson;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import com.pansoft.xbrl.xbrljson.util.PropUtil;

public class VoucherFileUtil {
    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath) throws Exception {
        return VoucherFileUtil.extractXBRLFromOFD(ofdFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFile) throws Exception {
        return new OFDLoader().extractAttach(ofdFilePath, outputFile);
    }

    @Deprecated
    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath) {
        return VoucherFileUtil.extractXBRLFromPDF(pdfFilePath, "");
    }

    @Deprecated
    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFile) {
        String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";
        return PDFTool.extractXBRLFileFromPDF(pdfFilePath, DEFAULT_ISSUER_XBRL_FILENAME, outputFile);
    }

    public static void extractAttachFromPDF(String pdfFilePath, String outputPath) {
        PDFTool.extractAttachFromPDF(pdfFilePath, outputPath);
    }

    public static String extractXMLFromPDF(String pdfFilePath) throws Exception {
        return PDFTool.extractEmbeddedStringFromPDF(pdfFilePath);
    }

    public static String extractXMLFromCEBPDF(String pdfFilePath) throws Exception {
        return PDFTool.extractCEBPDFFileFromPDF(pdfFilePath);
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return new XbrlToJson().convertXbrlJsonData(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return new JsonToXbrl().convertXbrlXml(jsonValue, configId);
    }

    public static JSONObject xml2Json(String xmlValue) {
        return new DomToJson().convertXmlJsonData(xmlValue);
    }

    static {
        PropUtil.initFileMap("VoucherType");
    }
}

