/*
 * Decompiled with CFR 0.152.
 */
package api.tools;

import api.VoucherFileInfo;
import com.bosssoft.tool.util.PdfExtractor;
import com.pansoft.xbrl.xbrljson.util.CleanPathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PDFTool {
    private static final Logger log = Logger.getLogger(PDFTool.class.toString());

    public static String extractCEBPDFFileFromPDF(String pdfPath) throws Exception {
        File file = new File(pdfPath);
        byte[] xmlBytes = PdfExtractor.mainXml((byte[])Files.readAllBytes(file.toPath()));
        return new String(xmlBytes, "UTF-8");
    }

    public static String extractEmbeddedStringFromPDF(String pdfPath) throws Exception {
        File file = new File(pdfPath);
        PDDocument document = PDDocument.load((File)file);
        COSDocument cosDocument = document.getDocument();
        COSDictionary trailer = cosDocument.getTrailer();
        COSObject cosObject = trailer.getCOSObject(COSName.getPDFName((String)"Root"));
        COSBase base = cosObject.getDictionaryObject(COSName.getPDFName((String)"Attachment"));
        String attachmentData = ((COSDictionary)base).getString("AttachmentData");
        byte[] decodedBytes = Base64.decodeBase64((byte[])attachmentData.getBytes());
        String decodedString = new String(decodedBytes);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fac.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(decodedString));
        Document xmlDocument = builder.parse(is);
        String voucherString = xmlDocument.getDocumentElement().getElementsByTagName("Voucher").item(0).getTextContent();
        byte[] decodedVoucherBytes = Base64.decodeBase64((byte[])voucherString.getBytes());
        return new String(decodedVoucherBytes, "GBK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoucherFileInfo extractXBRLFileFromPDF(String pdfPath, String xbrlFileName, String outputFile) {
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(pdfPath));
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Map names = efTree.getNames();
                if (names != null) {
                    VoucherFileInfo voucherFileInfo = PDFTool.extractFiles(names, xbrlFileName, outputFile);
                    return voucherFileInfo;
                }
                List kids = efTree.getKids();
                Iterator iterator = kids.iterator();
                if (iterator.hasNext()) {
                    PDNameTreeNode node = (PDNameTreeNode)iterator.next();
                    names = node.getNames();
                    VoucherFileInfo voucherFileInfo = PDFTool.extractFiles(names, xbrlFileName, outputFile);
                    return voucherFileInfo;
                }
            }
        }
        catch (IOException e) {
            log.info("Exception while trying to read pdf document - " + e);
        }
        finally {
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractAttachFromPDF(String pdfPath, String outputPath) {
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(pdfPath));
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Map names = efTree.getNames();
                if (names != null) {
                    PDFTool.extractFiles(names, outputPath);
                } else {
                    List kids = efTree.getKids();
                    for (PDNameTreeNode node : kids) {
                        names = node.getNames();
                        PDFTool.extractFiles(names, outputPath);
                    }
                }
            }
        }
        catch (IOException e) {
            log.info("Exception while trying to read pdf document - " + e);
        }
        finally {
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFiles(Map<String, PDComplexFileSpecification> names, String outputPath) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            String filename = fileSpec.getFile();
            PDEmbeddedFile embeddedFile = PDFTool.getEmbeddedFile(fileSpec);
            String outFile = outputPath == null || "".equals(outputPath) ? System.getProperty("java.io.tmpdir") + File.separator + filename : outputPath + File.separator + filename;
            outFile = CleanPathUtil.cleanString(outFile);
            File file = new File(outFile);
            log.info("Writing " + outFile);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(embeddedFile.toByteArray());
            }
            catch (IOException e) {
                log.info("Exception while trying to read pdf document - " + e);
            }
            finally {
                if (null == fos) continue;
                fos.close();
            }
        }
    }

    private static VoucherFileInfo extractFiles(Map<String, PDComplexFileSpecification> names, String attachName, String outputFile) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            String filename = fileSpec.getFile();
            if (!attachName.equals(filename)) continue;
            PDEmbeddedFile embeddedFile = PDFTool.getEmbeddedFile(fileSpec);
            return PDFTool.extractFile(filename, embeddedFile, outputFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VoucherFileInfo extractFile(String attachFilename, PDEmbeddedFile embeddedFile, String outputFile) throws IOException {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        voucherFileInfo.setVoucherType("ntrev_gpm_issuer");
        String outFilePath = outputFile;
        if (outFilePath == null || "".equals(outFilePath)) {
            outFilePath = System.getProperty("java.io.tmpdir") + File.separator + attachFilename;
        }
        outFilePath = CleanPathUtil.cleanString(outFilePath);
        File file = new File(outFilePath);
        log.info("Writing " + outFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(embeddedFile.toByteArray());
        }
        catch (IOException e) {
            log.info("Exception while trying to read pdf document - " + e);
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
        voucherFileInfo.setXbrlFilePath(outFilePath);
        return voucherFileInfo;
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }
}

