/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.pl.xbrl.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dianju.cz.pl.xbrl.util.StringUtil;
import java.util.List;
import java.util.logging.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DomToJson {
    private static Logger log = Logger.getLogger(DomToJson.class.toString());

    public JSONObject convertXmlJsonData(String xmlValue) {
        if (StringUtil.isBlank(xmlValue)) {
            return null;
        }
        Document document = null;
        JSONObject resultJSON = new JSONObject();
        try {
            document = DocumentHelper.parseText((String)xmlValue);
            Element rootNode = document.getRootElement();
            if (rootNode == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            this.readJsonData(rootNode, jsonObject);
            resultJSON.put(rootNode.getName(), (Object)jsonObject);
        }
        catch (DocumentException e) {
            log.info(e.toString());
        }
        return resultJSON;
    }

    private void readJsonData(Element element, JSONObject jsonObject) {
        if (element == null || jsonObject == null) {
            return;
        }
        List attrList = element.attributes();
        if (attrList != null && attrList.size() > 0) {
            String attrValue = null;
            for (Attribute attr : attrList) {
                attrValue = attr.getValue();
                if (StringUtil.isBlank(attrValue)) continue;
                jsonObject.put("@" + attr.getName(), (Object)attrValue);
            }
        }
        List childList = element.elements();
        String textValue = element.getText();
        if (!StringUtil.isBlank(textValue)) {
            jsonObject.put(element.getName(), (Object)textValue);
        }
        if (childList == null || childList.size() == 0) {
            return;
        }
        String itemName = null;
        List childNodeList = null;
        for (Element item : childList) {
            itemName = item.getName();
            childNodeList = item.elements();
            attrList = item.attributes();
            if (childNodeList == null || childNodeList.size() == 0) {
                textValue = item.getText();
                if (!StringUtil.isBlank(textValue)) {
                    jsonObject.put(itemName, (Object)textValue);
                }
                if (attrList == null) continue;
                String attrValue = null;
                for (Attribute attr : attrList) {
                    attrValue = attr.getValue();
                    if (StringUtil.isBlank(attrValue)) continue;
                    jsonObject.put("@" + attr.getName(), (Object)attrValue);
                }
                continue;
            }
            JSONObject childJson = new JSONObject();
            this.readJsonData(item, childJson);
            Object o = jsonObject.get((Object)itemName);
            if (o != null) {
                JSONArray jsonArray = null;
                if (o instanceof JSONObject) {
                    JSONObject jsonObj = (JSONObject)o;
                    jsonObject.remove((Object)itemName);
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)jsonObj);
                    jsonArray.add((Object)childJson);
                    jsonObject.put(itemName, (Object)jsonArray);
                }
                if (!(o instanceof JSONArray)) continue;
                jsonArray = (JSONArray)o;
                jsonArray.add((Object)childJson);
                continue;
            }
            if (childJson == null || childJson.isEmpty()) continue;
            jsonObject.put(itemName, (Object)childJson);
        }
    }
}

