/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.pl.xbrl.config;

import com.dianju.cz.pl.xbrl.config.XbrlJsonConfigReader;
import com.dianju.cz.pl.xbrl.config.model.XbrlJsonConfig;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class XbrlJsonConfigMgr {
    private static volatile XbrlJsonConfigMgr configMgr;
    private static Logger log;
    private HashMap<String, XbrlJsonConfig> xbrlJsonConfigMap;

    public XbrlJsonConfigMgr() {
        this.initConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XbrlJsonConfigMgr getInstance() {
        if (configMgr != null) return configMgr;
        Class<XbrlJsonConfigMgr> clazz = XbrlJsonConfigMgr.class;
        synchronized (XbrlJsonConfigMgr.class) {
            if (configMgr != null) return configMgr;
            configMgr = new XbrlJsonConfigMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configMgr;
        }
    }

    public XbrlJsonConfig getConfigObject(String configId) {
        if (this.xbrlJsonConfigMap == null) {
            this.initConfig();
        }
        return this.xbrlJsonConfigMap.get(configId);
    }

    private void initConfig() {
        if (this.xbrlJsonConfigMap == null) {
            this.xbrlJsonConfigMap = new HashMap();
        }
        File[] files = null;
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> resources = null;
        try {
            resources = this.getClass().getClassLoader().getResources("xbrlJsonConfig");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (url.getProtocol().equals("jar")) {
                    JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = urlConnection.getJarFile();
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        if (jarEntry.isDirectory() || !jarEntry.getName().startsWith("xbrlJsonConfig")) continue;
                        String name = jarEntry.getName();
                        Enumeration<URL> enums = this.getClass().getClassLoader().getResources(name);
                        URL fileUrl = null;
                        while (enums.hasMoreElements()) {
                            fileUrl = enums.nextElement();
                            if (fileUrl == null) continue;
                            urls.add(fileUrl);
                        }
                    }
                    continue;
                }
                if (!url.getProtocol().equals("file")) continue;
                URL resource = this.getClass().getClassLoader().getResource("xbrlJsonConfig");
                files = new File(resource.getPath()).listFiles();
            }
        }
        catch (IOException e) {
            log.info(e.toString());
        }
        if (files != null) {
            for (Iterator iterator : files) {
                XbrlJsonConfig configObject = this.createConfigObject((File)((Object)iterator));
                if (configObject == null) continue;
                this.xbrlJsonConfigMap.put(configObject.getConfigId(), configObject);
            }
        } else {
            for (URL url : urls) {
                XbrlJsonConfig configObject = this.createConfigObject(url);
                if (configObject == null) continue;
                this.xbrlJsonConfigMap.put(configObject.getConfigId(), configObject);
            }
        }
    }

    private XbrlJsonConfig createConfigObject(File configFile) {
        if (configFile == null || !configFile.exists()) {
            return null;
        }
        XbrlJsonConfigReader configReader = new XbrlJsonConfigReader();
        return configReader.reafFile(configFile);
    }

    private XbrlJsonConfig createConfigObject(URL fileUrl) {
        XbrlJsonConfigReader configReader = new XbrlJsonConfigReader();
        return configReader.reafFile(fileUrl);
    }

    static {
        log = Logger.getLogger(XbrlJsonConfigMgr.class.toString());
    }
}

