/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.util;

import com.dianju.cz.base.DJCommonResponseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.util.CollectionStore;

public class SM2Util {
    private static final Logger log = Logger.getLogger(SM2Util.class.toString());
    private static final SM2P256V1Curve CURVE = new SM2P256V1Curve();
    private static final BigInteger SM2_ECC_N = CURVE.getOrder();
    private static final BigInteger SM2_ECC_H = CURVE.getCofactor();
    private static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);

    private static BCECPublicKey getBCECPublicKey(X509Certificate sm2Cert) {
        ECPublicKey pubKey = (ECPublicKey)sm2Cert.getPublicKey();
        ECPoint q = pubKey.getQ();
        ECParameterSpec parameterSpec = new ECParameterSpec(CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(q, parameterSpec);
        return new BCECPublicKey(pubKey.getAlgorithm(), pubKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static boolean verify(BCECPublicKey pubKey, byte[] withId, byte[] srcData, byte[] sign) {
        ECPublicKeyParameters pubKeyParameters = SM2Util.convertPublicKeyToParameters(pubKey);
        return SM2Util.verify(pubKeyParameters, withId, srcData, sign);
    }

    private static ECPublicKeyParameters convertPublicKeyToParameters(BCECPublicKey ecPubKey) {
        ECParameterSpec parameterSpec = ecPubKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPublicKeyParameters(ecPubKey.getQ(), domainParameters);
    }

    private static boolean verify(ECPublicKeyParameters pubKeyParameters, byte[] withId, byte[] srcData, byte[] sign) {
        SM2Signer signer = new SM2Signer();
        CipherParameters param = withId != null ? new ParametersWithID(pubKeyParameters, withId) : pubKeyParameters;
        signer.init(false, param);
        signer.update(srcData, 0, srcData.length);
        return signer.verifySignature(sign);
    }

    public static boolean verifyP7(byte[] srcData, byte[] signedData) throws CertificateException, CMSException, IOException {
        return SM2Util.verifyP7(null, srcData, signedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyP7(byte[] withId, byte[] srcData, byte[] signedData) throws CMSException, IOException, CertificateException {
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(signedData);
            CMSSignedData cmsSingedData = new CMSSignedData(inStream);
            byte[] signed = null;
            X509Certificate cert = null;
            CollectionStore x509s = (CollectionStore)cmsSingedData.getCertificates();
            X509CertificateHolder holder = (X509CertificateHolder)x509s.iterator().next();
            cert = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(holder);
            SignerInformationStore signers = cmsSingedData.getSignerInfos();
            Collection<SignerInformation> c = signers.getSigners();
            for (SignerInformation signer : c) {
                signed = signer.getSignature();
            }
            if (srcData == null) {
                srcData = (byte[])cmsSingedData.getSignedContent().getContent();
                signed = SM2Util.hnSubSignatureEx(signed);
            }
            BCECPublicKey pubKey = SM2Util.getBCECPublicKey(cert);
            boolean bl = SM2Util.verify(pubKey, withId, srcData, signed);
            return bl;
        }
        catch (Exception e) {
            log.warning("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u9a8c\u7b7e\u5931\u8d25:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private static byte[] hnSubSignatureEx(byte[] signature) {
        try {
            byte[] si;
            if (signature == null) {
                return null;
            }
            byte[] s = signature;
            if (signature.length != 70) {
                si = new byte[70];
                if (s[4] == 0 && s[39] == 0) {
                    System.arraycopy(s, 0, si, 0, 4);
                    System.arraycopy(s, 5, si, 4, 34);
                    System.arraycopy(s, 40, si, 38, 32);
                } else if (s[4] == 0 && s[39] != 0) {
                    System.arraycopy(s, 0, si, 0, 4);
                    System.arraycopy(s, 5, si, 4, 66);
                } else if (s[4] != 0 && s[38] == 0) {
                    System.arraycopy(s, 0, si, 0, 38);
                    System.arraycopy(s, 39, si, 38, 32);
                } else if (s[2] == 2 && s[3] == 32 && s[36] == 2 && s[37] == 32) {
                    System.arraycopy(s, 0, si, 0, 70);
                }
                signature = si;
            }
            si = new byte[32];
            byte[] bs = new byte[32];
            System.arraycopy(signature, 4, si, 0, 32);
            System.arraycopy(signature, 38, bs, 0, 32);
            BigInteger bir = new BigInteger(1, si);
            BigInteger bis = new BigInteger(1, bs);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(bir));
            v.add(new ASN1Integer(bis));
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            log.warning("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u4fee\u590dDER\u5931\u8d25" + e.getMessage());
            throw new DJCommonResponseException("\u4fee\u590dDER\u5931\u8d25");
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

