/*
 * Decompiled with CFR 0.152.
 */
package org.djdom4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.djdom4j.Attribute;
import org.djdom4j.CDATA;
import org.djdom4j.Comment;
import org.djdom4j.Document;
import org.djdom4j.DocumentType;
import org.djdom4j.Element;
import org.djdom4j.Entity;
import org.djdom4j.InvalidXPathException;
import org.djdom4j.Namespace;
import org.djdom4j.NodeFilter;
import org.djdom4j.ProcessingInstruction;
import org.djdom4j.QName;
import org.djdom4j.Text;
import org.djdom4j.XPath;
import org.djdom4j.rule.Pattern;
import org.djdom4j.tree.AbstractDocument;
import org.djdom4j.tree.DefaultAttribute;
import org.djdom4j.tree.DefaultCDATA;
import org.djdom4j.tree.DefaultComment;
import org.djdom4j.tree.DefaultDocument;
import org.djdom4j.tree.DefaultDocumentType;
import org.djdom4j.tree.DefaultElement;
import org.djdom4j.tree.DefaultEntity;
import org.djdom4j.tree.DefaultProcessingInstruction;
import org.djdom4j.tree.DefaultText;
import org.djdom4j.tree.QNameCache;
import org.djdom4j.util.SimpleSingleton;
import org.djdom4j.util.SingletonStrategy;
import org.djdom4j.xpath.DefaultXPath;
import org.djdom4j.xpath.XPathPattern;
import org.jaxen.VariableContext;

public class DocumentFactory
implements Serializable {
    private static SingletonStrategy singleton = null;
    protected transient QNameCache cache;
    private Map xpathNamespaceURIs;

    public DocumentFactory() {
        this.init();
    }

    private static SingletonStrategy createSingleton() {
        String documentFactoryClassName;
        SingletonStrategy result = null;
        try {
            documentFactoryClassName = System.getProperty("org.djdom4j.factory", "org.djdom4j.DocumentFactory");
        }
        catch (Exception e) {
            documentFactoryClassName = "org.djdom4j.DocumentFactory";
        }
        try {
            String singletonClass = System.getProperty("org.djdom4j.DocumentFactory.singleton.strategy", "org.djdom4j.util.SimpleSingleton");
            Class<?> clazz = Class.forName(singletonClass);
            result = (SingletonStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            result = new SimpleSingleton();
        }
        result.setSingletonClassName(documentFactoryClassName);
        return result;
    }

    public static synchronized DocumentFactory getInstance() {
        if (singleton == null) {
            singleton = DocumentFactory.createSingleton();
        }
        return (DocumentFactory)singleton.instance();
    }

    protected static DocumentFactory createSingleton(String className) {
        try {
            Class<?> theClass = Class.forName(className, true, DocumentFactory.class.getClassLoader());
            return (DocumentFactory)theClass.newInstance();
        }
        catch (Throwable e) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + className);
            return new DocumentFactory();
        }
    }

    public Document createDocument() {
        DefaultDocument answer = new DefaultDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public Document createDocument(String encoding) {
        Document answer = this.createDocument();
        if (answer instanceof AbstractDocument) {
            ((AbstractDocument)answer).setXMLEncoding(encoding);
        }
        return answer;
    }

    public Document createDocument(Element rootElement) {
        Document answer = this.createDocument();
        answer.setRootElement(rootElement);
        return answer;
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DefaultDocumentType(name, publicId, systemId);
    }

    public Element createElement(QName qname) {
        return new DefaultElement(qname);
    }

    public Element createElement(String name) {
        return this.createElement(this.createQName(name));
    }

    public Element createElement(String qualifiedName, String namespaceURI) {
        return this.createElement(this.createQName(qualifiedName, namespaceURI));
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        return new DefaultAttribute(qname, value);
    }

    public Attribute createAttribute(Element owner, String name, String value) {
        return this.createAttribute(owner, this.createQName(name), value);
    }

    public CDATA createCDATA(String text) {
        return new DefaultCDATA(text);
    }

    public Comment createComment(String text) {
        return new DefaultComment(text);
    }

    public Text createText(String text) {
        if (text == null) {
            String msg = "Adding text to an XML document must not be null";
            throw new IllegalArgumentException(msg);
        }
        return new DefaultText(text);
    }

    public Entity createEntity(String name, String text) {
        return new DefaultEntity(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return Namespace.get(prefix, uri);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public QName createQName(String localName, Namespace namespace) {
        return this.cache.get(localName, namespace);
    }

    public QName createQName(String localName) {
        return this.cache.get(localName);
    }

    public QName createQName(String name, String prefix, String uri) {
        return this.cache.get(name, Namespace.get(prefix, uri));
    }

    public QName createQName(String qualifiedName, String uri) {
        return this.cache.get(qualifiedName, uri);
    }

    public XPath createXPath(String xpathExpression) throws InvalidXPathException {
        DefaultXPath xpath = new DefaultXPath(xpathExpression);
        if (this.xpathNamespaceURIs != null) {
            xpath.setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return xpath;
    }

    public XPath createXPath(String xpathExpression, VariableContext variableContext) {
        XPath xpath = this.createXPath(xpathExpression);
        xpath.setVariableContext(variableContext);
        return xpath;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression, VariableContext variableContext) {
        XPath answer = this.createXPath(xpathFilterExpression);
        answer.setVariableContext(variableContext);
        return answer;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression) {
        return this.createXPath(xpathFilterExpression);
    }

    public Pattern createPattern(String xpathPattern) {
        return new XPathPattern(xpathPattern);
    }

    public List getQNames() {
        return this.cache.getQNames();
    }

    public Map getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    public void setXPathNamespaceURIs(Map namespaceURIs) {
        this.xpathNamespaceURIs = namespaceURIs;
    }

    protected QName intern(QName qname) {
        return this.cache.intern(qname);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }
}

