/*
 * Decompiled with CFR 0.152.
 */
package org.djdom4j.swing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.djdom4j.Branch;
import org.djdom4j.CharacterData;
import org.djdom4j.Node;
import org.djdom4j.swing.LeafTreeNode;

public class BranchTreeNode
extends LeafTreeNode {
    protected List children;

    public BranchTreeNode() {
    }

    public BranchTreeNode(Branch xmlNode) {
        super(xmlNode);
    }

    public BranchTreeNode(TreeNode parent, Branch xmlNode) {
        super(parent, xmlNode);
    }

    @Override
    public Enumeration children() {
        return new Enumeration(){
            private int index = -1;

            @Override
            public boolean hasMoreElements() {
                return this.index + 1 < BranchTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return BranchTreeNode.this.getChildAt(++this.index);
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildList().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildList().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildList().indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getXmlBranch().nodeCount() <= 0;
    }

    @Override
    public String toString() {
        return this.xmlNode.getName();
    }

    protected List getChildList() {
        if (this.children == null) {
            this.children = this.createChildList();
        }
        return this.children;
    }

    protected List createChildList() {
        Branch branch = this.getXmlBranch();
        int size = branch.nodeCount();
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>(size);
        for (int i = 0; i < size; ++i) {
            String text;
            Node node = branch.node(i);
            if (node instanceof CharacterData && ((text = node.getText()) == null || (text = text.trim()).length() <= 0)) continue;
            childList.add(this.createChildTreeNode(node));
        }
        return childList;
    }

    protected TreeNode createChildTreeNode(Node xmlNode) {
        if (xmlNode instanceof Branch) {
            return new BranchTreeNode((TreeNode)this, (Branch)xmlNode);
        }
        return new LeafTreeNode(this, xmlNode);
    }

    protected Branch getXmlBranch() {
        return (Branch)this.xmlNode;
    }
}

