/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EISImageCommonUtil {
    private static Logger log = LoggerFactory.getLogger(EISImageCommonUtil.class);

    public static byte[] bufImg2Bytes(BufferedImage original) {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)original, "jpeg", bStream);
        }
        catch (IOException e) {
            throw new RuntimeException("bugImg\u8bfb\u53d6\u5931\u8d25:" + e.getMessage(), e);
        }
        return bStream.toByteArray();
    }

    public static BufferedImage bytes2bufImg(byte[] imgBytes) {
        BufferedImage tagImg = null;
        try {
            tagImg = ImageIO.read(new ByteArrayInputStream(imgBytes));
            return tagImg;
        }
        catch (IOException e) {
            throw new RuntimeException("bugImg\u5199\u5165\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    public static byte[] InputStreamtoByteArray(InputStream input) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(input);
        BufferedOutputStream byteArrayOutputStream = new BufferedOutputStream(output);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = bufferedInputStream.read(buffer))) {
            byteArrayOutputStream.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static byte[] InputStreamtoByte(InputStream input) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(input);
            BufferedOutputStream byteArrayOutputStream = new BufferedOutputStream(baos);
            byte[] bytes = new byte[1024];
            int len = -1;
            while ((len = bufferedInputStream.read(bytes)) > -1) {
                byteArrayOutputStream.write(bytes, 0, len);
            }
            byteArrayOutputStream.flush();
            return baos;
        }
        catch (Exception e) {
            log.error("ByteArrayOutputStream err:" + e.toString());
            return null;
        }
    }

    public static InputStream outputStreamToInputStream(ByteArrayOutputStream outputStream) throws Exception {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception e) {
            log.error("outputStreamToInputStream err:" + e.toString());
            throw new Exception(e);
        }
        return is;
    }

    public static InputStream byteToInputStream(byte[] bytes) {
        ByteArrayInputStream ins = new ByteArrayInputStream(bytes);
        return ins;
    }

    public static InputStream converToStream(String imgcontentStr) {
        imgcontentStr = imgcontentStr.replace(" ", "+");
        byte[] stringToByte = DatatypeConverter.parseBase64Binary((String)imgcontentStr);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringToByte);
        return inputStream;
    }

    public static byte[] pgm2jpg(InputStream srcInput) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedImage img = ImageIO.read(srcInput);
        BufferedImage tag = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
        tag.getGraphics().drawImage(img.getScaledInstance(((Image)img).getWidth(null), ((Image)img).getHeight(null), 4), 0, 0, null);
        ImageIO.write((RenderedImage)tag, "jpg", output);
        byte[] filedata = output.toByteArray();
        output.close();
        return filedata;
    }

    public static InputStream pgm2jpgIs(InputStream srcInput) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedImage img = ImageIO.read(srcInput);
        BufferedImage tag = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
        tag.getGraphics().drawImage(img.getScaledInstance(((Image)img).getWidth(null), ((Image)img).getHeight(null), 4), 0, 0, null);
        ImageIO.write((RenderedImage)tag, "jpg", output);
        InputStream inputStream = EISImageCommonUtil.outputStreamToInputStream(output);
        output.close();
        return inputStream;
    }
}

