/*
 * Decompiled with CFR 0.152.
 */
package com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate;

import com.inspur.gs.xbrl.tools.webapi.EISFolder.EISValidate.MySES_SealInfo;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class MySESeal
extends ASN1Object {
    private MySES_SealInfo eSealInfo;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signAlgID;
    private ASN1BitString signedValue;

    public MySESeal() {
    }

    public MySESeal(MySES_SealInfo eSealInfo, ASN1OctetString cert, ASN1ObjectIdentifier signAlgID, ASN1BitString signedValue) {
        this.eSealInfo = eSealInfo;
        this.cert = cert;
        this.signAlgID = signAlgID;
        this.signedValue = signedValue;
    }

    public MySESeal(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.eSealInfo = MySES_SealInfo.getInstance(e.nextElement());
        this.cert = ASN1OctetString.getInstance(e.nextElement());
        this.signAlgID = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.signedValue = DERBitString.getInstance(e.nextElement());
    }

    public static MySESeal getInstance(Object o) {
        if (o instanceof MySESeal) {
            return (MySESeal)((Object)o);
        }
        if (o instanceof byte[]) {
            ASN1InputStream aIn = new ASN1InputStream((byte[])o);
            try {
                ASN1Primitive obj = aIn.readObject();
                return new MySESeal(ASN1Sequence.getInstance((Object)obj));
            }
            catch (IOException var3) {
                throw new IllegalArgumentException("\u7535\u5b50\u5370\u7ae0\u6570\u636ev4 \u65e0\u6cd5\u89e3\u6790", var3);
            }
        }
        return o != null ? new MySESeal(ASN1Sequence.getInstance((Object)o)) : null;
    }

    public MySES_SealInfo geteSealInfo() {
        return this.eSealInfo;
    }

    public MySESeal seteSealInfo(MySES_SealInfo eSealInfo) {
        this.eSealInfo = eSealInfo;
        return this;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public MySESeal setCert(ASN1OctetString cert) {
        this.cert = cert;
        return this;
    }

    public MySESeal setCert(Certificate cert) throws CertificateEncodingException {
        this.cert = new DEROctetString(cert.getEncoded());
        return this;
    }

    public ASN1ObjectIdentifier getSignAlgID() {
        return this.signAlgID;
    }

    public MySESeal setSignAlgID(ASN1ObjectIdentifier signAlgID) {
        this.signAlgID = signAlgID;
        return this;
    }

    public ASN1BitString getSignedValue() {
        return this.signedValue;
    }

    public MySESeal setSignedValue(ASN1BitString signedValue) {
        this.signedValue = signedValue;
        return this;
    }

    public MySESeal setSignedValue(byte[] signedValue) {
        this.signedValue = new DERBitString(signedValue);
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(4);
        v.add((ASN1Encodable)this.eSealInfo);
        v.add((ASN1Encodable)this.cert);
        v.add((ASN1Encodable)this.signAlgID);
        v.add((ASN1Encodable)this.signedValue);
        return new DERSequence(v);
    }
}

