/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.VoucherFileInfo;
import api.loader.OFDLoader;
import api.tools.PDFTool;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.convert.DomToJson;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import com.pansoft.xbrl.xbrljson.domain.EntityDto;
import com.pansoft.xbrl.xbrljson.domain.ResultDto;
import com.pansoft.xbrl.xbrljson.domain.atr.AtrIssuer;
import com.pansoft.xbrl.xbrljson.domain.atr.AtrReceive;
import com.pansoft.xbrl.xbrljson.domain.bker.BankIssuer;
import com.pansoft.xbrl.xbrljson.domain.bker.BankReceive;
import com.pansoft.xbrl.xbrljson.domain.bkrs.Bkrs;
import com.pansoft.xbrl.xbrljson.domain.ctp.CtpReceive;
import com.pansoft.xbrl.xbrljson.domain.inv.InvOrdIssuer;
import com.pansoft.xbrl.xbrljson.domain.inv.InvOrdReceive;
import com.pansoft.xbrl.xbrljson.domain.inv.InvSpclIssuer;
import com.pansoft.xbrl.xbrljson.domain.inv.InvSpclReceive;
import com.pansoft.xbrl.xbrljson.domain.inv.InvTlfIssuer;
import com.pansoft.xbrl.xbrljson.domain.inv.InvTlfReceive;
import com.pansoft.xbrl.xbrljson.domain.ntrev.NtrevGpmIssuer;
import com.pansoft.xbrl.xbrljson.domain.ntrev.NtrevGpmReceive;
import com.pansoft.xbrl.xbrljson.domain.rai.RaiIssuer;
import com.pansoft.xbrl.xbrljson.domain.rai.RaiReceive;
import com.pansoft.xbrl.xbrljson.enums.TicketSourceEnum;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import java.io.File;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VoucherFileUtil {
    private static Log log = LogFactory.getLog(VoucherFileUtil.class);
    private static String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";
    private static final String numberOfGpOrder = "numberOfGpOrder";
    private static final String NumberOfGpOrder = "NumberOfGpOrder";
    private static final String electronicInvoiceAirTransportReceiptNumber = "electronicInvoiceAirTransportReceiptNumber";
    private static final String ElectronicInvoiceAirTransportReceiptNumber = "ElectronicInvoiceAirTransportReceiptNumber";
    private static final String trainNumber = "trainNumber";
    private static final String TrainNumber = "TrainNumber";
    private static final String electronicInvoiceRailwayETicketNumber = "electronicInvoiceRailwayETicketNumber";
    private static final String ElectronicInvoiceRailwayETicketNumber = "ElectronicInvoiceRailwayETicketNumber";
    private static final String accountNumberOfRecipient = "accountNumberOfRecipient";
    private static final String AccountNumberOfRecipient = "AccountNumberOfRecipient";
    private static final String whetherInvoiceHasBeenClaimed = "whetherInvoiceHasBeenClaimed";
    private static final String WhetherInvoiceHasBeenClaimed = "WhetherInvoiceHasBeenClaimed";
    private static final String informationOfReconcileDetailsTuple = "informationOfReconcileDetailsTuple";
    private static final String InformationOfReconcileDetailsTuple = "InformationOfReconcileDetailsTuple";
    private static final String inv_ord_issuer = "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968";
    private static final String inv_spcl_issuer = "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968";
    private static final String inv_tlf_issuer = "\u6536\u8d39\u516c\u8def\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968";
    private static final String whetherInputVatHasBeenTransferredOut = "whetherInputVatHasBeenTransferredOut";
    private static final String WhetherInputVatHasBeenTransferredOut = "WhetherInputVatHasBeenTransferredOut";
    private static final String nameOfSeller = "nameOfSeller";
    private static final String NameOfSeller = "NameOfSeller";
    private static final String requestTime = "requestTime";
    private static final String RequestTime = "RequestTime";
    private static final String whetherEinvoiceUsageHasBeenConfirmed = "whetherEinvoiceUsageHasBeenConfirmed";
    private static final String WhetherEinvoiceUsageHasBeenConfirmed = "WhetherEinvoiceUsageHasBeenConfirmed";
    private static final String HEADER = "HEADER";
    private static final String BILL_DATE = "BILL_DATE";

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath) throws Exception {
        return VoucherFileUtil.extractXBRLFromOFD(ofdFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFile) throws Exception {
        VoucherFileInfo voucherFileInfo = new OFDLoader().extractAttach(ofdFilePath, outputFile);
        return voucherFileInfo;
    }

    @Deprecated
    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath) {
        return VoucherFileUtil.extractXBRLFromPDF(pdfFilePath, "");
    }

    @Deprecated
    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFile) {
        return PDFTool.extractXBRLFileFromPDF(pdfFilePath, DEFAULT_ISSUER_XBRL_FILENAME, outputFile);
    }

    public static void extractAttachFromPDF(String pdfFilePath, String outputPath) {
        PDFTool.extractAttachFromPDF(pdfFilePath, outputPath);
    }

    public static JSONObject extractJSONFromOFD(String ofdFilePath) throws Exception {
        String xmlValue = null;
        xmlValue = new OFDLoader().extractOriginalXML(ofdFilePath);
        return VoucherFileUtil.xml2Json(xmlValue);
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return new XbrlToJson().convertXbrlJsonData(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return new JsonToXbrl().convertXbrlXml(jsonValue, configId);
    }

    public static JSONObject xml2Json(String xmlValue) {
        return new DomToJson().convertXmlJsonData(xmlValue);
    }

    public static byte[] extractXbrlFromOFDBytes(byte[] bytes) throws IllegalArgumentException {
        try {
            File file = FileUtil.writeBytes(bytes, System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID() + ".ofd");
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromOFD(file.getPath());
            String xbrlString = FileUtil.readUtf8String(voucherFileInfo.getXbrlFilePath());
            return xbrlString.getBytes();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException("\u4eceOFD\u6587\u4ef6\u4e2d\u8bfb\u53d6 XBRL \u6587\u4ef6\u5185\u5bb9\u5e76\u8fd4\u56de Json \u5f02\u5e38");
        }
    }

    public static ResultDto xbrl2JsonString(String xbrlXml) {
        ResultDto resultDto = new ResultDto();
        String configId = VoucherFileUtil.getConfigId(xbrlXml);
        JSONObject jsonObject = VoucherFileUtil.xbrl2Json(xbrlXml, configId);
        EntityDto entityDto = VoucherFileUtil.parse(jsonObject.toJSONString(), configId);
        resultDto.setEntityDto(entityDto);
        resultDto.setType(configId);
        return resultDto;
    }

    public static byte[] extractXbrlFromPDFBytes(byte[] bytes) throws IllegalArgumentException {
        try {
            File file = FileUtil.writeBytes(bytes, System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID() + ".pdf");
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromPDF(file.getPath());
            String xbrlString = FileUtil.readUtf8String(voucherFileInfo.getXbrlFilePath());
            return xbrlString.getBytes();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException("\u4eceOFD\u6587\u4ef6\u4e2d\u8bfb\u53d6 XBRL \u6587\u4ef6\u5185\u5bb9\u5e76\u8fd4\u56de Json \u5f02\u5e38");
        }
    }

    public static ResultDto extractJsonStringFromOFDBytes(byte[] bytes) throws IllegalArgumentException {
        try {
            ResultDto resultDto = new ResultDto();
            File file = FileUtil.writeBytes(bytes, System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID() + ".ofd");
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromOFD(file.getPath());
            String s = FileUtil.readUtf8String(voucherFileInfo.getXbrlFilePath());
            String configId = VoucherFileUtil.getConfigId(s);
            JSONObject jsonObject = VoucherFileUtil.xbrl2Json(s, configId);
            EntityDto entityDto = VoucherFileUtil.parse(jsonObject.toJSONString(), configId);
            FileUtil.del(file.getPath());
            FileUtil.del(voucherFileInfo.getXbrlFilePath());
            resultDto.setEntityDto(entityDto);
            resultDto.setType(configId);
            return resultDto;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException("\u4eceOFD\u6587\u4ef6\u4e2d\u8bfb\u53d6 XBRL \u6587\u4ef6\u5185\u5bb9\u5e76\u8fd4\u56de Json \u5f02\u5e38");
        }
    }

    public static ResultDto extractJsonStringFromPDFBytes(byte[] bytes) throws IllegalArgumentException {
        try {
            ResultDto resultDto = new ResultDto();
            File file = FileUtil.writeBytes(bytes, System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID() + ".pdf");
            VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromPDF(file.getPath());
            String s = FileUtil.readUtf8String(voucherFileInfo.getXbrlFilePath());
            JSONObject jsonObject = VoucherFileUtil.xbrl2Json(s, voucherFileInfo.getVoucherType());
            EntityDto entityDto = VoucherFileUtil.parse(jsonObject.toJSONString(), voucherFileInfo.getVoucherType());
            FileUtil.del(file.getPath());
            FileUtil.del(voucherFileInfo.getXbrlFilePath());
            resultDto.setEntityDto(entityDto);
            resultDto.setType(voucherFileInfo.getVoucherType());
            return resultDto;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException("\u4eceOFD\u6587\u4ef6\u4e2d\u8bfb\u53d6 XBRL \u6587\u4ef6\u5185\u5bb9\u5e76\u8fd4\u56de Json \u5f02\u5e38");
        }
    }

    private static ResultDto parse(VoucherFileInfo voucherFileInfo, String configId) {
        ResultDto resultDto = new ResultDto();
        String xbrlXml = FileUtil.readUtf8String(voucherFileInfo.getXbrlFilePath());
        JSONObject jsonObject = VoucherFileUtil.xbrl2Json(xbrlXml, configId);
        FileUtil.del(voucherFileInfo.getXbrlFilePath());
        EntityDto entityDto = VoucherFileUtil.parse(jsonObject.toJSONString(), configId);
        resultDto.setEntityDto(entityDto);
        resultDto.setType(configId);
        return resultDto;
    }

    private static EntityDto parse(String jsonString, String configId) {
        if (TicketSourceEnum.inv_ord_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvOrdIssuer.class);
        }
        if (TicketSourceEnum.inv_ord_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvOrdReceive.class);
        }
        if (TicketSourceEnum.inv_spcl_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvSpclIssuer.class);
        }
        if (TicketSourceEnum.inv_spcl_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvSpclReceive.class);
        }
        if (TicketSourceEnum.inv_tlf_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvTlfIssuer.class);
        }
        if (TicketSourceEnum.inv_tlf_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, InvTlfReceive.class);
        }
        if (TicketSourceEnum.ntrev_gpm_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, NtrevGpmIssuer.class);
        }
        if (TicketSourceEnum.ntrev_gpm_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, NtrevGpmReceive.class);
        }
        if (TicketSourceEnum.rai_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, RaiIssuer.class);
        }
        if (TicketSourceEnum.rai_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, RaiReceive.class);
        }
        if (TicketSourceEnum.atr_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, AtrIssuer.class);
        }
        if (TicketSourceEnum.atr_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, AtrReceive.class);
        }
        if (TicketSourceEnum.bker_issuer.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, BankIssuer.class);
        }
        if (TicketSourceEnum.bker_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, BankReceive.class);
        }
        if (TicketSourceEnum.bkrs.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, Bkrs.class);
        }
        if (TicketSourceEnum.ctp_receiver.getSourceCode().equals(configId)) {
            return JSONObject.parseObject(jsonString, CtpReceive.class);
        }
        return null;
    }

    private static String getConfigId(String string) {
        String configId = "";
        if (string.contains(NumberOfGpOrder) || string.contains(numberOfGpOrder)) {
            configId = TicketSourceEnum.atr_issuer.getSourceCode();
        } else if ((string.contains(ElectronicInvoiceAirTransportReceiptNumber) || string.contains(electronicInvoiceAirTransportReceiptNumber)) && !string.contains(NumberOfGpOrder) && !string.contains(NumberOfGpOrder)) {
            configId = TicketSourceEnum.atr_receiver.getSourceCode();
        } else if (string.contains(TrainNumber) || string.contains(trainNumber)) {
            configId = TicketSourceEnum.rai_issuer.getSourceCode();
        } else if ((string.contains(ElectronicInvoiceRailwayETicketNumber) || string.contains(electronicInvoiceRailwayETicketNumber)) && !string.contains(TrainNumber) && !string.contains(trainNumber)) {
            configId = TicketSourceEnum.rai_receiver.getSourceCode();
        } else if (string.contains(InformationOfReconcileDetailsTuple) || string.contains(informationOfReconcileDetailsTuple)) {
            configId = TicketSourceEnum.bkrs.getSourceCode();
        } else if (string.contains(AccountNumberOfRecipient) || string.contains(accountNumberOfRecipient)) {
            configId = TicketSourceEnum.bker_issuer.getSourceCode();
        } else if (string.contains(WhetherInvoiceHasBeenClaimed) || string.contains(whetherInvoiceHasBeenClaimed)) {
            configId = TicketSourceEnum.bker_receiver.getSourceCode();
        } else if (string.contains(inv_ord_issuer)) {
            configId = TicketSourceEnum.inv_ord_issuer.getSourceCode();
        } else if (string.contains(inv_spcl_issuer)) {
            configId = TicketSourceEnum.inv_spcl_issuer.getSourceCode();
        } else if (string.contains(inv_tlf_issuer)) {
            configId = TicketSourceEnum.inv_tlf_issuer.getSourceCode();
        } else if ((string.contains(WhetherInputVatHasBeenTransferredOut) || string.contains(whetherInputVatHasBeenTransferredOut)) && !string.contains(NameOfSeller) && !string.contains(nameOfSeller)) {
            configId = TicketSourceEnum.inv_spcl_receiver.getSourceCode();
        } else if ((string.contains(RequestTime) || string.contains(requestTime)) && (string.contains(WhetherEinvoiceUsageHasBeenConfirmed) || string.contains(whetherEinvoiceUsageHasBeenConfirmed))) {
            configId = TicketSourceEnum.einv_spcl_receiver.getSourceCode();
        } else if ((string.contains(RequestTime) || string.contains(requestTime)) && !string.contains(WhetherEinvoiceUsageHasBeenConfirmed) && !string.contains(whetherEinvoiceUsageHasBeenConfirmed)) {
            configId = TicketSourceEnum.einv_ord_receiver.getSourceCode();
        } else if (string.contains(HEADER)) {
            configId = TicketSourceEnum.ntrev_gpm_issuer.getSourceCode();
        } else {
            if (!string.contains(BILL_DATE) || string.contains(HEADER)) {
                throw new IllegalArgumentException("\u65e0\u6b64\u7968\u636e\u7c7b\u578b");
            }
            configId = TicketSourceEnum.ntrev_gpm_receiver.getSourceCode();
        }
        return configId;
    }

    private static String getConfigId(Object T) {
        String configId = "";
        if (T.getClass().equals(InvOrdIssuer.class)) {
            configId = TicketSourceEnum.inv_ord_issuer.getSourceCode();
        }
        if (T.getClass().equals(InvOrdReceive.class)) {
            configId = TicketSourceEnum.inv_ord_receiver.getSourceCode();
        }
        if (T.getClass().equals(InvSpclIssuer.class)) {
            configId = TicketSourceEnum.inv_spcl_issuer.getSourceCode();
        }
        if (T.getClass().equals(InvSpclReceive.class)) {
            configId = TicketSourceEnum.inv_spcl_receiver.getSourceCode();
        }
        if (T.getClass().equals(InvTlfIssuer.class)) {
            configId = TicketSourceEnum.inv_tlf_issuer.getSourceCode();
        }
        if (T.getClass().equals(InvTlfReceive.class)) {
            configId = TicketSourceEnum.inv_tlf_receiver.getSourceCode();
        }
        if (T.getClass().equals(NtrevGpmIssuer.class)) {
            configId = TicketSourceEnum.ntrev_gpm_issuer.getSourceCode();
        }
        if (T.getClass().equals(NtrevGpmReceive.class)) {
            configId = TicketSourceEnum.ntrev_gpm_receiver.getSourceCode();
        }
        return configId;
    }

    public static String sortJsonProperties(String jsonValue, String configId) {
        if (TicketSourceEnum.bker_receiver.getSourceCode().equals(configId)) {
            BankReceive bankReceive = JSONObject.parseObject(jsonValue, BankReceive.class);
            if (bankReceive.getInformationOfAccountingDocumentsTuple() != null && bankReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                bankReceive.setTemp(bankReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(bankReceive);
        }
        if (TicketSourceEnum.atr_receiver.getSourceCode().equals(configId)) {
            AtrReceive atrReceive = JSONObject.parseObject(jsonValue, AtrReceive.class);
            if (atrReceive.getInformationOfAccountingDocumentsTuple() != null && atrReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                atrReceive.setTemp(atrReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(atrReceive);
        }
        if (TicketSourceEnum.rai_receiver.getSourceCode().equals(configId)) {
            RaiReceive raiReceive = JSONObject.parseObject(jsonValue, RaiReceive.class);
            if (raiReceive.getInformationOfAccountingDocumentsTuple() != null && raiReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                raiReceive.setTemp(raiReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(raiReceive);
        }
        if (TicketSourceEnum.bkrs.getSourceCode().equals(configId)) {
            jsonValue = JSONObject.toJSONString(JSONObject.parseObject(jsonValue, Bkrs.class));
        }
        if (TicketSourceEnum.inv_ord_receiver.getSourceCode().equals(configId)) {
            InvOrdReceive invOrdReceive = JSONObject.parseObject(jsonValue, InvOrdReceive.class);
            if (invOrdReceive.getInformationOfAccountingDocumentsTuple() != null && invOrdReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                invOrdReceive.setTemp(invOrdReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(invOrdReceive);
        }
        if (TicketSourceEnum.inv_spcl_receiver.getSourceCode().equals(configId)) {
            InvSpclReceive invSpclReceive = JSONObject.parseObject(jsonValue, InvSpclReceive.class);
            if (invSpclReceive.getInformationOfAccountingDocumentsTuple() != null && invSpclReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                invSpclReceive.setTemp(invSpclReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(invSpclReceive);
        }
        if (TicketSourceEnum.inv_tlf_receiver.getSourceCode().equals(configId)) {
            InvTlfReceive invTlfReceive = JSONObject.parseObject(jsonValue, InvTlfReceive.class);
            if (invTlfReceive.getInformationOfAccountingDocumentsTuple() != null && invTlfReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                invTlfReceive.setTemp(invTlfReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(invTlfReceive);
        }
        if (TicketSourceEnum.ntrev_gpm_receiver.getSourceCode().equals(configId)) {
            NtrevGpmReceive ntrevGpmReceive = JSONObject.parseObject(jsonValue, NtrevGpmReceive.class);
            if (ntrevGpmReceive.getInformationOfAccountingDocumentsTuple() != null && ntrevGpmReceive.getInformationOfAccountingDocumentsTuple().size() > 0) {
                ntrevGpmReceive.setTemp(ntrevGpmReceive.getInformationOfAccountingDocumentsTuple().get(0));
            }
            jsonValue = JSONObject.toJSONString(ntrevGpmReceive);
        }
        return jsonValue;
    }

    static {
        PropUtil.initFileMap("VoucherType");
    }
}

