/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1;

import cn.org.bjca.gaia.asn1.ASN1Choice;
import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1Exception;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1OutputStream;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.ASN1TaggedObjectParser;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.DLTaggedObject;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    ASN1Encodable obj = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            return (ASN1TaggedObject)obj.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public ASN1TaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        this.explicit = obj instanceof ASN1Choice ? true : explicit;
        this.tagNo = tagNo;
        if (this.explicit) {
            this.obj = obj;
        } else {
            ASN1Primitive prim = obj.toASN1Primitive();
            if (prim instanceof ASN1Set) {
                Object var5_5 = null;
            }
            this.obj = obj;
        }
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject other = (ASN1TaggedObject)o;
        if (this.tagNo != other.tagNo || this.empty != other.empty || this.explicit != other.explicit) {
            return false;
        }
        return !(this.obj == null ? other.obj != null : !this.obj.toASN1Primitive().equals(other.obj.toASN1Primitive()));
    }

    @Override
    public int hashCode() {
        int code = this.tagNo;
        if (this.obj != null) {
            code ^= this.obj.hashCode();
        }
        return code;
    }

    @Override
    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public ASN1Primitive getObject() {
        if (this.obj != null) {
            return this.obj.toASN1Primitive();
        }
        return null;
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        switch (tag) {
            case 17: {
                return ASN1Set.getInstance(this, isExplicit).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, isExplicit).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, isExplicit).parser();
            }
        }
        if (isExplicit) {
            return this.getObject();
        }
        throw new ASN1Exception("implicit tagging not implemented for tag: " + tag);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

