/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.pkcs;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.pkcs.CertificationRequestInfo;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;

public class CertificationRequest
extends ASN1Object {
    protected CertificationRequestInfo reqInfo = null;
    protected AlgorithmIdentifier sigAlgId = null;
    protected DERBitString sigBits = null;

    public static CertificationRequest getInstance(Object o) {
        if (o instanceof CertificationRequest) {
            return (CertificationRequest)o;
        }
        if (o != null) {
            return new CertificationRequest(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    protected CertificationRequest() {
    }

    public CertificationRequest(CertificationRequestInfo requestInfo, AlgorithmIdentifier algorithm, DERBitString signature) {
        this.reqInfo = requestInfo;
        this.sigAlgId = algorithm;
        this.sigBits = signature;
    }

    public CertificationRequest(ASN1Sequence seq) {
        this.reqInfo = CertificationRequestInfo.getInstance(seq.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.sigBits = (DERBitString)seq.getObjectAt(2);
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.reqInfo;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sigBits;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.reqInfo);
        v.add(this.sigAlgId);
        v.add(this.sigBits);
        return new DERSequence(v);
    }
}

