/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.tsp;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.util.Arrays;

public class PartialHashtree
extends ASN1Object {
    private ASN1Sequence values;

    public static PartialHashtree getInstance(Object obj) {
        if (obj instanceof PartialHashtree) {
            return (PartialHashtree)obj;
        }
        if (obj != null) {
            return new PartialHashtree(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence values) {
        for (int i = 0; i != values.size(); ++i) {
            if (values.getObjectAt(i) instanceof DEROctetString) continue;
            throw new IllegalArgumentException("unknown object in constructor: " + values.getObjectAt(i).getClass().getName());
        }
        this.values = values;
    }

    public PartialHashtree(byte[] values) {
        this(new byte[][]{values});
    }

    public PartialHashtree(byte[][] values) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != values.length; ++i) {
            v.add(new DEROctetString(Arrays.clone(values[i])));
        }
        this.values = new DERSequence(v);
    }

    public byte[][] getValues() {
        byte[][] rv = new byte[this.values.size()][];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Arrays.clone(ASN1OctetString.getInstance(this.values.getObjectAt(i)).getOctets());
        }
        return rv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

