/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.ua;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1TaggedObject;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.ua.DSTU4145BinaryField;
import cn.org.bjca.gaia.asn1.ua.DSTU4145PointEncoder;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.math.ec.ECAlgorithms;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.field.PolynomialExtensionField;
import cn.org.bjca.gaia.util.Arrays;
import java.math.BigInteger;

public class DSTU4145ECBinary
extends ASN1Object {
    BigInteger version = BigInteger.valueOf(0L);
    DSTU4145BinaryField f;
    ASN1Integer a;
    ASN1OctetString b;
    ASN1Integer n;
    ASN1OctetString bp;

    public DSTU4145ECBinary(ECDomainParameters params) {
        ECCurve curve = params.getCurve();
        if (!ECAlgorithms.isF2mCurve(curve)) {
            throw new IllegalArgumentException("only binary domain is possible");
        }
        PolynomialExtensionField field = (PolynomialExtensionField)curve.getField();
        int[] exponents = field.getMinimalPolynomial().getExponentsPresent();
        if (exponents.length == 3) {
            this.f = new DSTU4145BinaryField(exponents[2], exponents[1]);
        } else if (exponents.length == 5) {
            this.f = new DSTU4145BinaryField(exponents[4], exponents[1], exponents[2], exponents[3]);
        } else {
            throw new IllegalArgumentException("curve must have a trinomial or pentanomial basis");
        }
        this.a = new ASN1Integer(curve.getA().toBigInteger());
        this.b = new DEROctetString(curve.getB().getEncoded());
        this.n = new ASN1Integer(params.getN());
        this.bp = new DEROctetString(DSTU4145PointEncoder.encodePoint(params.getG()));
    }

    private DSTU4145ECBinary(ASN1Sequence seq) {
        int index = 0;
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedVersion = (ASN1TaggedObject)seq.getObjectAt(index);
            if (taggedVersion.isExplicit() && 0 == taggedVersion.getTagNo()) {
                this.version = ASN1Integer.getInstance(taggedVersion.getLoadedObject()).getValue();
                ++index;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.f = DSTU4145BinaryField.getInstance(seq.getObjectAt(index));
        this.a = ASN1Integer.getInstance(seq.getObjectAt(++index));
        this.b = ASN1OctetString.getInstance(seq.getObjectAt(++index));
        this.n = ASN1Integer.getInstance(seq.getObjectAt(++index));
        this.bp = ASN1OctetString.getInstance(seq.getObjectAt(++index));
    }

    public static DSTU4145ECBinary getInstance(Object obj) {
        if (obj instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)obj;
        }
        if (obj != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.f;
    }

    public BigInteger getA() {
        return this.a.getValue();
    }

    public byte[] getB() {
        return Arrays.clone(this.b.getOctets());
    }

    public BigInteger getN() {
        return this.n.getValue();
    }

    public byte[] getG() {
        return Arrays.clone(this.bp.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (0 != this.version.compareTo(BigInteger.valueOf(0L))) {
            v.add(new DERTaggedObject(true, 0, new ASN1Integer(this.version)));
        }
        v.add(this.f);
        v.add(this.a);
        v.add(this.b);
        v.add(this.n);
        v.add(this.bp);
        return new DERSequence(v);
    }
}

