/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.cert.BjcaCert;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.ASN1Util;

public class CertificateUtil {
    private GaiaProvider provider = null;

    public CertificateUtil(GaiaProvider provider) {
        this.provider = provider;
    }

    public static BjcaCert createCert(byte[] usrCert) throws PkiException {
        BjcaCert bjcaCert = new BjcaCert(usrCert);
        return bjcaCert;
    }

    public static Certificate convertToCertificate(byte[] usrCert) throws PkiException {
        ASN1Object pkcs = ASN1Util.checkAndGetASN1Object(usrCert);
        return Certificate.getInstance(pkcs);
    }

    public boolean validateCert(byte[] usrCert, byte[] fatherCert) throws PkiException {
        boolean ret = false;
        try {
            BjcaCert fatherCertOb = new BjcaCert(fatherCert);
            byte[] pubKey = fatherCertOb.getPublicKeyData();
            ASN1Object pkcs = ASN1Util.checkAndGetASN1Object(usrCert);
            Certificate uCert = Certificate.getInstance(pkcs);
            byte[] toBeSignCert = uCert.getTBSCertificate().getEncoded();
            byte[] signedData = uCert.getSignature().getBytes();
            AlgorithmIdentifier signAlgIdentifier = uCert.getSignatureAlgorithm();
            String algId = signAlgIdentifier.getAlgorithm().getId();
            AlgPolicy hashAlg = null;
            AlgPolicy signAlg = null;
            BjcaKey bjcaKey = null;
            if (algId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
                hashAlg = new AlgPolicy("SHA1");
                signAlg = new AlgPolicy("SHA1WithRSA");
                bjcaKey = new BjcaKey("RSA_Public", pubKey);
            } else if (algId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
                hashAlg = new AlgPolicy("SHA256");
                signAlg = new AlgPolicy("SHA256WithRSA");
                bjcaKey = new BjcaKey("RSA_Public", pubKey);
            } else if (algId.equals(GMObjectIdentifiers.sm2sign_with_sm3.getId())) {
                SM3Param sm3Param = new SM3Param(pubKey);
                hashAlg = new AlgPolicy("SM3", sm3Param);
                signAlg = new AlgPolicy("SM3WithSM2");
                bjcaKey = new BjcaKey("SM2_Public", pubKey);
            } else {
                throw new PkiException("11006003", "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25 \u8bc1\u4e66\u7c7b\u578b\u4e0d\u652f\u6301");
            }
            byte[] hash = this.provider.hash(hashAlg, toBeSignCert);
            ret = this.provider.verifySignHashedData(signAlg, hash, signedData, bjcaKey);
        }
        catch (Exception e) {
            throw new PkiException("11006003", "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25", e);
        }
        return ret;
    }
}

