/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1GeneralizedTime;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.Extension;
import cn.org.bjca.gaia.asn1.x509.Extensions;
import cn.org.bjca.gaia.asn1.x509.ExtensionsGenerator;
import cn.org.bjca.gaia.asn1.x509.TBSCertList;
import cn.org.bjca.gaia.asn1.x509.Time;
import cn.org.bjca.gaia.asn1.x509.V2TBSCertListGenerator;
import cn.org.bjca.gaia.cert.CertIOException;
import cn.org.bjca.gaia.cert.CertUtils;
import cn.org.bjca.gaia.cert.X509CRLHolder;
import cn.org.bjca.gaia.operator.ContentSigner;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;

public class X509v2CRLBuilder {
    private V2TBSCertListGenerator tbsGen = new V2TBSCertListGenerator();
    private ExtensionsGenerator extGenerator;

    public X509v2CRLBuilder(X500Name issuer, Date thisUpdate) {
        this.extGenerator = new ExtensionsGenerator();
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setThisUpdate(new Time(thisUpdate));
    }

    public X509v2CRLBuilder(X500Name issuer, Date thisUpdate, Locale dateLocale) {
        this.extGenerator = new ExtensionsGenerator();
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setThisUpdate(new Time(thisUpdate, dateLocale));
    }

    public X509v2CRLBuilder(X500Name issuer, Time thisUpdate) {
        this.extGenerator = new ExtensionsGenerator();
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setThisUpdate(thisUpdate);
    }

    public X509v2CRLBuilder(X509CRLHolder template) {
        this.tbsGen.setIssuer(template.getIssuer());
        this.tbsGen.setThisUpdate(new Time(template.getThisUpdate()));
        Date nextUpdate = template.getNextUpdate();
        if (nextUpdate != null) {
            this.tbsGen.setNextUpdate(new Time(nextUpdate));
        }
        this.addCRL(template);
        this.extGenerator = new ExtensionsGenerator();
        Extensions exts = template.getExtensions();
        Enumeration en = exts.oids();
        while (en.hasMoreElements()) {
            this.extGenerator.addExtension(exts.getExtension((ASN1ObjectIdentifier)en.nextElement()));
        }
    }

    public boolean hasExtension(ASN1ObjectIdentifier oid) {
        return this.doGetExtension(oid) != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        return this.doGetExtension(oid);
    }

    private Extension doGetExtension(ASN1ObjectIdentifier oid) {
        Extensions exts = this.extGenerator.generate();
        return exts.getExtension(oid);
    }

    public X509v2CRLBuilder setNextUpdate(Date date) {
        return this.setNextUpdate(new Time(date));
    }

    public X509v2CRLBuilder setNextUpdate(Date date, Locale dateLocale) {
        return this.setNextUpdate(new Time(date, dateLocale));
    }

    public X509v2CRLBuilder setNextUpdate(Time date) {
        this.tbsGen.setNextUpdate(date);
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger userCertificateSerial, Date revocationDate, int reason) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificateSerial), new Time(revocationDate), reason);
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger userCertificateSerial, Date revocationDate, int reason, Date invalidityDate) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificateSerial), new Time(revocationDate), reason, new ASN1GeneralizedTime(invalidityDate));
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger userCertificateSerial, Date revocationDate, Extensions extensions) {
        this.tbsGen.addCRLEntry(new ASN1Integer(userCertificateSerial), new Time(revocationDate), extensions);
        return this;
    }

    public X509v2CRLBuilder addCRL(X509CRLHolder other) {
        TBSCertList revocations = other.toASN1Structure().getTBSCertList();
        if (revocations != null) {
            Enumeration en = revocations.getRevokedCertificateEnumeration();
            while (en.hasMoreElements()) {
                this.tbsGen.addCRLEntry(ASN1Sequence.getInstance(((ASN1Encodable)en.nextElement()).toASN1Primitive()));
            }
        }
        return this;
    }

    public X509v2CRLBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        CertUtils.addExtension(this.extGenerator, oid, isCritical, value);
        return this;
    }

    public X509v2CRLBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, byte[] encodedValue) throws CertIOException {
        this.extGenerator.addExtension(oid, isCritical, encodedValue);
        return this;
    }

    public X509v2CRLBuilder addExtension(Extension extension) throws CertIOException {
        this.extGenerator.addExtension(extension);
        return this;
    }

    public X509v2CRLBuilder replaceExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        try {
            this.extGenerator = CertUtils.doReplaceExtension(this.extGenerator, new Extension(oid, isCritical, value.toASN1Primitive().getEncoded("DER")));
        }
        catch (IOException e) {
            throw new CertIOException("cannot encode extension: " + e.getMessage(), e);
        }
        return this;
    }

    public X509v2CRLBuilder replaceExtension(Extension extension) throws CertIOException {
        this.extGenerator = CertUtils.doReplaceExtension(this.extGenerator, extension);
        return this;
    }

    public X509v2CRLBuilder replaceExtension(ASN1ObjectIdentifier oid, boolean isCritical, byte[] encodedValue) throws CertIOException {
        this.extGenerator = CertUtils.doReplaceExtension(this.extGenerator, new Extension(oid, isCritical, encodedValue));
        return this;
    }

    public X509v2CRLBuilder removeExtension(ASN1ObjectIdentifier oid) {
        this.extGenerator = CertUtils.doRemoveExtension(this.extGenerator, oid);
        return this;
    }

    public X509CRLHolder build(ContentSigner signer) {
        this.tbsGen.setSignature(signer.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return CertUtils.generateFullCRL(signer, this.tbsGen.generateTBSCertList());
    }
}

