/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.AsymmetricBlockCipher;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoException;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.Signer;
import cn.org.bjca.gaia.crypto.digests.NullDigest;
import cn.org.bjca.gaia.crypto.encodings.PKCS1Encoding;
import cn.org.bjca.gaia.crypto.engines.RSABlindedEngine;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.params.RSAKeyParameters;
import cn.org.bjca.gaia.crypto.signers.GenericSigner;
import cn.org.bjca.gaia.crypto.signers.RSADigestSigner;
import cn.org.bjca.gaia.crypto.tls.AbstractTlsSigner;
import cn.org.bjca.gaia.crypto.tls.CombinedHash;
import cn.org.bjca.gaia.crypto.tls.SignatureAndHashAlgorithm;
import cn.org.bjca.gaia.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Digest d = raw ? new NullDigest() : (algorithm == null ? new CombinedHash() : TlsUtils.createHash(algorithm.getHash()));
        Signer s = algorithm != null ? new RSADigestSigner(d, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash())) : new GenericSigner(this.createRSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

