/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.util;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.kisa.KISAObjectIdentifiers;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.ntt.NTTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.crypto.CipherKeyGenerator;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.crypto.generators.DESKeyGenerator;
import cn.org.bjca.gaia.crypto.generators.DESedeKeyGenerator;
import cn.org.bjca.gaia.crypto.util.AlgorithmIdentifierFactory;
import java.security.SecureRandom;

public class CipherKeyGeneratorFactory {
    private CipherKeyGeneratorFactory() {
    }

    public static CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier algorithm, SecureRandom random) throws IllegalArgumentException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 256);
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            DESedeKeyGenerator keyGen = new DESedeKeyGenerator();
            keyGen.init(new KeyGenerationParameters(random, 192));
            return keyGen;
        }
        if (NTTObjectIdentifiers.id_camellia128_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        if (NTTObjectIdentifiers.id_camellia192_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 192);
        }
        if (NTTObjectIdentifiers.id_camellia256_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 256);
        }
        if (KISAObjectIdentifiers.id_seedCBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        if (AlgorithmIdentifierFactory.CAST5_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            DESKeyGenerator keyGen = new DESKeyGenerator();
            keyGen.init(new KeyGenerationParameters(random, 64));
            return keyGen;
        }
        if (PKCSObjectIdentifiers.rc4.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(random, 128);
        }
        throw new IllegalArgumentException("cannot recognise cipher: " + algorithm);
    }

    private static CipherKeyGenerator createCipherKeyGenerator(SecureRandom random, int keySize) {
        CipherKeyGenerator keyGen = new CipherKeyGenerator();
        keyGen.init(new KeyGenerationParameters(random, keySize));
        return keyGen;
    }
}

