/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.openssl.jcajce;

import cn.org.bjca.gaia.jcajce.util.DefaultJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.JcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.NamedJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.ProviderJcaJceHelper;
import cn.org.bjca.gaia.openssl.PEMDecryptor;
import cn.org.bjca.gaia.openssl.PEMDecryptorProvider;
import cn.org.bjca.gaia.openssl.PEMException;
import cn.org.bjca.gaia.openssl.PasswordException;
import cn.org.bjca.gaia.openssl.jcajce.PEMUtilities;
import java.security.Provider;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PEMDecryptorProvider build(final char[] password) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String dekAlgName) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                        if (password == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, keyBytes, password, dekAlgName, iv);
                    }
                };
            }
        };
    }
}

