/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.bc;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.pkcs.PKCS12PBEParams;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.BlockCipher;
import cn.org.bjca.gaia.crypto.BufferedBlockCipher;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.ExtendedDigest;
import cn.org.bjca.gaia.crypto.digests.SHA1Digest;
import cn.org.bjca.gaia.crypto.generators.PKCS12ParametersGenerator;
import cn.org.bjca.gaia.crypto.io.CipherOutputStream;
import cn.org.bjca.gaia.crypto.paddings.PKCS7Padding;
import cn.org.bjca.gaia.crypto.paddings.PaddedBufferedBlockCipher;
import cn.org.bjca.gaia.operator.GenericKey;
import cn.org.bjca.gaia.operator.OutputEncryptor;
import cn.org.bjca.gaia.pkcs.bc.PKCS12PBEUtils;
import java.io.OutputStream;
import java.security.SecureRandom;

public class BcPKCS12PBEOutputEncryptorBuilder {
    private ExtendedDigest digest;
    private BufferedBlockCipher engine;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int iterationCount = 1024;

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine) {
        this(algorithm, engine, new SHA1Digest());
    }

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine, ExtendedDigest pbeDigest) {
        this.algorithm = algorithm;
        this.engine = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
        this.digest = pbeDigest;
    }

    public BcPKCS12PBEOutputEncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public OutputEncryptor build(final char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        this.random.nextBytes(salt);
        final PKCS12PBEParams pbeParams = new PKCS12PBEParams(salt, this.iterationCount);
        CipherParameters params = PKCS12PBEUtils.createCipherParameters(this.algorithm, this.digest, this.engine.getBlockSize(), pbeParams, password);
        this.engine.init(true, params);
        return new OutputEncryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pbeParams);
            }

            @Override
            public OutputStream getOutputStream(OutputStream out) {
                return new CipherOutputStream(out, BcPKCS12PBEOutputEncryptorBuilder.this.engine);
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pbeParams), PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
            }
        };
    }
}

