/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.jcajce.provider.sphincs;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.digests.SHA3Digest;
import cn.org.bjca.gaia.crypto.digests.SHA512tDigest;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCS256KeyPairGenerator;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import cn.org.bjca.gaia.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import cn.org.bjca.gaia.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import cn.org.bjca.gaia.pqc.jcajce.spec.SPHINCS256KeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class Sphincs256KeyPairGeneratorSpi
extends KeyPairGenerator {
    ASN1ObjectIdentifier treeDigest = NISTObjectIdentifiers.id_sha512_256;
    SPHINCS256KeyGenerationParameters param;
    SPHINCS256KeyPairGenerator engine = new SPHINCS256KeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public Sphincs256KeyPairGeneratorSpi() {
        super("SPHINCS256");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof SPHINCS256KeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a SPHINCS256KeyGenParameterSpec");
        }
        SPHINCS256KeyGenParameterSpec sphincsParams = (SPHINCS256KeyGenParameterSpec)params;
        if (sphincsParams.getTreeDigest().equals("SHA512-256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha512_256;
            this.param = new SPHINCS256KeyGenerationParameters(random, new SHA512tDigest(256));
        } else if (sphincsParams.getTreeDigest().equals("SHA3-256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha3_256;
            this.param = new SPHINCS256KeyGenerationParameters(random, new SHA3Digest(256));
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new SPHINCS256KeyGenerationParameters(this.random, new SHA512tDigest(256));
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        SPHINCSPublicKeyParameters pub = (SPHINCSPublicKeyParameters)pair.getPublic();
        SPHINCSPrivateKeyParameters priv = (SPHINCSPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCSphincs256PublicKey(this.treeDigest, pub), new BCSphincs256PrivateKey(this.treeDigest, priv));
    }
}

