/*
 * Decompiled with CFR 0.152.
 */
package com.hc.pojo;

import com.hc.util.ByteTrans;
import com.hc.util.GMUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.encoders.Base64;

public class CertParser {
    private final X509Certificate cert;
    private final byte[] publickeyEncode;
    private final String certSn;
    private final String subject;
    private final String issuer;
    private final String algorithm;
    private final Date startDate;
    private final Date endDate;
    private final String tbsCertificateBase64;
    private final byte[] tbsCertificate;
    private final byte[] signature;
    private final String signatureBase64;
    private final String rootCertFP;

    public byte[] getpublickeyEncode() {
        return this.publickeyEncode;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public String getCertSn() {
        return this.certSn;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getTbsCertificateBase64() {
        return this.tbsCertificateBase64;
    }

    public byte[] getTbsCertificate() {
        return this.tbsCertificate;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSignatureBase64() {
        return this.signatureBase64;
    }

    public String getRootCertFP() {
        return this.rootCertFP;
    }

    public CertParser(X509Certificate cert, String certSn, String subject, String issuer, String algorithm, Date startDate, Date endDate, String tbsCertificateBase64, byte[] tbsCertificate, byte[] signature, String signatureBase64, String rootCertFP, byte[] publickeyEncode) {
        this.cert = cert;
        this.certSn = certSn;
        this.subject = subject;
        this.issuer = issuer;
        this.algorithm = algorithm;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tbsCertificateBase64 = tbsCertificateBase64;
        this.tbsCertificate = tbsCertificate;
        this.signature = signature;
        this.signatureBase64 = signatureBase64;
        this.rootCertFP = rootCertFP;
        this.publickeyEncode = publickeyEncode;
    }

    public static CertParser getInstance(String publicCert) {
        byte[] certBuf = Base64.decode(publicCert);
        return CertParser.getInstance(certBuf);
    }

    public String toString() {
        return "\u8bc1\u4e66\u5e8f\u5217\u53f7\ufffd??" + this.certSn + "\ufffd? " + "\u8bc1\u4e66\u4e3b\u9898\ufffd?" + this.subject + "\ufffd? " + "\u5bc6\u94a5\u4f7f\u7528\u8005\u6807\u8bc6\u7b26\ufffd?" + this.rootCertFP + "\ufffd? " + "\u8bc1\u4e66\u7b97\u6cd5\ufffd?" + this.algorithm + "\ufffd? " + "\u8bc1\u4e66\u53d1\u884c\u4eba\ufffd??" + this.subject + "\ufffd? ";
    }

    private static boolean isBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    private static int CheckCertType(byte[] certbuf) {
        block5: {
            Provider _provider = Security.getProvider("BC");
            if (_provider == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            try {
                byte[] firstline = Arrays.copyOfRange(certbuf, 0, 27);
                byte[] array2 = "-----BEGIN CERTIFICATE-----".getBytes();
                boolean retval = Arrays.equals(firstline, array2);
                if (!retval) break block5;
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (CertParser.isBase64(new String(certbuf))) {
            return 2;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertParser getInstance(byte[] certBuf) {
        Object dercertBuf;
        X509CertificateHolder certHolder;
        block25: {
            certHolder = null;
            try {
                int certTye = CertParser.CheckCertType(certBuf);
                if (certTye == 1) {
                    ByteArrayInputStream is = new ByteArrayInputStream(certBuf);
                    PEMParser pemParser = new PEMParser(new InputStreamReader(is));
                    certHolder = (X509CertificateHolder)pemParser.readObject();
                    pemParser.close();
                    break block25;
                }
                if (certTye == 2) {
                    dercertBuf = Base64.decode(certBuf);
                    certHolder = new X509CertificateHolder((byte[])dercertBuf);
                } else {
                    if (certTye != 0) return null;
                    certHolder = new X509CertificateHolder(certBuf);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CertificateFactory cf = null;
        try {
            dercertBuf = null;
            Object var4_10 = null;
            try {
                ByteArrayInputStream fis = new ByteArrayInputStream(certBuf);
                try {
                    block26: {
                        block27: {
                            BufferedInputStream bis = new BufferedInputStream(fis);
                            cf = CertificateFactory.getInstance("x.509", "BC");
                            if (bis.available() <= 0) break block26;
                            byte[] publickeyEncode = null;
                            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                            if (cert == null) {
                            }
                            ASN1Primitive asn1Sequence = ASN1Primitive.fromByteArray(certBuf);
                            Certificate instance = Certificate.getInstance(asn1Sequence);
                            ASN1Integer serialNumber = instance.getSerialNumber();
                            byte[] encoded = serialNumber.getValue().toByteArray();
                            String certSn = ByteTrans.Bytes2HexString(encoded).toUpperCase();
                            String subject = GMUtils.BuilderDN(cert.getSubjectDN().getName());
                            String issuer = GMUtils.BuilderDN(cert.getIssuerDN().getName());
                            String algorithm = GMUtils.oidToName(cert.getSigAlgOID());
                            Date startDate = cert.getNotBefore();
                            Date endDate = cert.getNotAfter();
                            byte[] tbsCertificate = cert.getTBSCertificate();
                            String tbsCertificateBase64 = Base64.toBase64String(tbsCertificate);
                            byte[] signature = cert.getSignature();
                            String signatureBase64 = Base64.toBase64String(signature);
                            String rootCertFP = "";
                            byte[] extbuf = cert.getExtensionValue("2.5.29.35");
                            if (extbuf == null) return new CertParser(cert, certSn, subject, issuer, algorithm, startDate, endDate, tbsCertificateBase64, tbsCertificate, signature, signatureBase64, rootCertFP, publickeyEncode);
                            if (extbuf.length <= 0) return new CertParser(cert, certSn, subject, issuer, algorithm, startDate, endDate, tbsCertificateBase64, tbsCertificate, signature, signatureBase64, rootCertFP, publickeyEncode);
                            byte[] octets = ASN1OctetString.getInstance(extbuf).getOctets();
                            ASN1Sequence derseq = DERSequence.getInstance(octets);
                            ASN1Encodable[] derseqObjs = derseq.toArray();
                            if (derseqObjs.length <= 0) return new CertParser(cert, certSn, subject, issuer, algorithm, startDate, endDate, tbsCertificateBase64, tbsCertificate, signature, signatureBase64, rootCertFP, publickeyEncode);
                            DERTaggedObject ddd = (DERTaggedObject)derseqObjs[0];
                            byte[] testbuf = ddd.getObject().getEncoded();
                            DEROctetString derOStr = (DEROctetString)DEROctetString.fromByteArray(testbuf);
                            testbuf = derOStr.getOctets();
                            rootCertFP = GMUtils.bytesToHex(testbuf);
                            return new CertParser(cert, certSn, subject, issuer, algorithm, startDate, endDate, tbsCertificateBase64, tbsCertificate, signature, signatureBase64, rootCertFP, publickeyEncode);
                            finally {
                                if (bis == null) break block27;
                                bis.close();
                            }
                        }
                        if (fis == null) return null;
                        fis.close();
                        return null;
                    }
                    if (fis == null) return null;
                }
                catch (Throwable throwable) {
                    if (dercertBuf == null) {
                        dercertBuf = throwable;
                    } else if (dercertBuf != throwable) {
                        ((Throwable)dercertBuf).addSuppressed(throwable);
                    }
                    if (fis == null) throw dercertBuf;
                    fis.close();
                    throw dercertBuf;
                }
                fis.close();
                return null;
            }
            catch (Throwable throwable) {
                if (dercertBuf == null) {
                    dercertBuf = throwable;
                    throw dercertBuf;
                }
                if (dercertBuf == throwable) throw dercertBuf;
                ((Throwable)dercertBuf).addSuppressed(throwable);
                throw dercertBuf;
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String GetDNInfo(String DN, String type) {
        String strCN = "";
        String strDN = DN;
        int index_cn = strDN.indexOf(type);
        if (index_cn < 0) {
            return strCN;
        }
        strCN = strDN.substring(index_cn + type.length(), strDN.length());
        int index_comma = strCN.indexOf(",");
        if (index_comma != -1) {
            strCN = strCN.substring(0, index_comma);
        }
        return strCN;
    }

    public String getCertInfo(long infoType) {
        if (this.cert == null) {
            return null;
        }
        String strRes = "";
        switch ((int)infoType) {
            case 1: {
                strRes = Integer.toString(this.cert.getVersion());
                break;
            }
            case 2: {
                strRes = this.certSn;
                break;
            }
            case 5: {
                strRes = this.issuer;
                break;
            }
            case 6: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                strRes = String.valueOf(df.format(this.startDate)) + " to " + df.format(this.endDate);
                break;
            }
            case 7: {
                strRes = this.subject;
                break;
            }
            case 8: {
                strRes = Base64.toBase64String(this.cert.getPublicKey().getEncoded());
                break;
            }
            case 9: {
                strRes = "";
                break;
            }
            case 17: {
                byte[] mark = this.cert.getExtensionValue("2.5.29.35");
                if (mark.length > 6) {
                    byte[] temp = new byte[mark.length - 6];
                    int i = 0;
                    while (i < mark.length - 6) {
                        temp[i] = mark[i + 6];
                        ++i;
                    }
                    strRes = GMUtils.bytesToHex(temp);
                    break;
                }
                strRes = "";
                break;
            }
            case 18: {
                byte[] mark = this.cert.getExtensionValue("2.5.29.14");
                if (mark.length > 6) {
                    byte[] temp = new byte[mark.length - 6];
                    int i = 0;
                    while (i < mark.length - 6) {
                        temp[i] = mark[i + 6];
                        ++i;
                    }
                    strRes = GMUtils.bytesToHex(temp);
                    break;
                }
                strRes = "";
                break;
            }
            case 19: {
                byte[] mark = this.cert.getExtensionValue("2.5.29.15");
                if (mark.length == 6) {
                    byte[] temp = new byte[mark.length - 5];
                    int i = 0;
                    while (i < mark.length - 5) {
                        temp[i] = mark[i + 5];
                        ++i;
                    }
                    String strtemp = GMUtils.bytesToHex(temp);
                    if (strtemp.equals("38")) {
                        strRes = "Key Encipherment, Data Encipherment, Key Agreement";
                        break;
                    }
                    if (strtemp.equals("C0")) {
                        strRes = "Digital Signature, Non-Repudiation";
                        break;
                    }
                    strRes = "Unknow";
                    break;
                }
                strRes = "";
                break;
            }
            case 20: {
                strRes = "";
                break;
            }
            case 21: {
                strRes = "";
                break;
            }
            case 22: {
                strRes = "";
                break;
            }
            case 23: {
                strRes = "";
                break;
            }
            case 24: {
                strRes = "";
                break;
            }
            case 25: {
                strRes = "";
                break;
            }
            case 26: {
                byte[] mark = this.cert.getExtensionValue("2.5.29.31");
                if (mark.length > 0) {
                    try {
                        ASN1Sequence _rootSequence1;
                        ASN1Encodable[] _rootarray1;
                        byte[] temp = new byte[mark.length - 3];
                        int i = 0;
                        while (i < mark.length - 3) {
                            temp[i] = mark[i + 3];
                            ++i;
                        }
                        ASN1Sequence _rootSequence = (ASN1Sequence)ASN1Sequence.fromByteArray(temp);
                        ASN1Encodable[] _rootarray = _rootSequence.toArray();
                        if (_rootarray.length != 2 || !(_rootarray[0] instanceof ASN1Sequence) && !(_rootarray[1] instanceof ASN1Sequence) || (_rootarray1 = (_rootSequence1 = (ASN1Sequence)_rootarray[1]).toArray()).length != 1) break;
                        DERTaggedObject derobject = (DERTaggedObject)_rootarray1[0];
                        DERTaggedObject derobject1 = (DERTaggedObject)derobject.getObject().toASN1Object();
                        DERTaggedObject derobject2 = (DERTaggedObject)derobject1.getObject().toASN1Object();
                        DEROctetString strCrl = (DEROctetString)derobject2.getObject().toASN1Object();
                        strRes = new String(strCrl.getOctets());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        strRes = "";
                    }
                    break;
                }
                strRes = "";
                break;
            }
            case 27: {
                strRes = "";
                break;
            }
            case 28: {
                strRes = "";
                break;
            }
            case 33: {
                strRes = this.GetDNInfo(this.issuer, "CN=");
                break;
            }
            case 34: {
                strRes = this.GetDNInfo(this.issuer, "O=");
                break;
            }
            case 35: {
                strRes = this.GetDNInfo(this.issuer, "OU=");
                break;
            }
            case 49: {
                strRes = this.GetDNInfo(this.subject, "CN=");
                break;
            }
            case 50: {
                strRes = this.GetDNInfo(this.subject, "O=");
                break;
            }
            case 51: {
                strRes = this.GetDNInfo(this.subject, "OU=");
            }
        }
        return strRes;
    }
}

