/*
 * Decompiled with CFR 0.152.
 */
package com.hc.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.util.encoders.Base64;

public class GMUtils {
    public static final String HNCASM2RootCert = "MIICujCCAl6gAwIBAgIQTH8N39siWijpxaBrVMPQ+jAMBggqgRzPVQGDdQUAMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEPMA0GA1UEAwwGUk9PVENBMB4XDTEzMDEyMDAyMjMyM1oXDTMzMDExNTAyMjMyM1owZjELMAkGA1UEBhMCQ04xDjAMBgNVBAgMBUhlTmFuMRIwEAYDVQQHDAlaaGVuZ1pob3UxJDAiBgNVBAoMG0hlTmFuIENlcnRpZmljYXRlIEF1dGhvcml0eTENMAsGA1UEAwwESE5DQTBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABEobkq+7L8gZ6VxIrMp92LoXX8a+WGXIm7yDpwSwBfFLOOZyEF/51lijyszCgJSOwYEHHzBAhmUhEIX86gXfFH2jggEiMIIBHjAfBgNVHSMEGDAWgBRMMrGX2TMbxKYFwcbli2Jb8Jd2WDAPBgNVHRMBAf8EBTADAQH/MIG6BgNVHR8EgbIwga8wQaA/oD2kOzA5MQswCQYDVQQGEwJDTjEOMAwGA1UECgwFTlJDQUMxDDAKBgNVBAsMA0FSTDEMMAoGA1UEAwwDYXJsMCqgKKAmhiRodHRwOi8vd3d3LnJvb3RjYS5nb3YuY24vYXJsL2FybC5jcmwwPqA8oDqGOGxkYXA6Ly9sZGFwLnJvb3RjYS5nb3YuY246Mzg5L0NOPWFybCxPVT1BUkwsTz1OUkNBQyxDPUNOMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUhekiQo5iGdsElgMSMdwRkN8OxrUwDAYIKoEcz1UBg3UFAANIADBFAiEA1x5QKzptmleXXwlPbNEMHPkiTO58TQSBvzl3Uht3RF8CIH0/53wGT0M0+rIEJNw3K137xDjRP7estRzh81l0BGMF";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final char[] HNCAArray = "01234ABCDEF56789".toCharArray();
    public static final String curve_p = "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF";
    public static final String curve_a = "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC";
    public static final String curve_b = "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93";
    public static final String curve_n = "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123";
    public static final String curve_gx = "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7";
    public static final String curve_gy = "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0";
    public static final ASN1ObjectIdentifier SM2_OID = new ASN1ObjectIdentifier("1.2.156.10197.1.501");
    public static final ASN1ObjectIdentifier RSA_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5");

    public static String replaceAllBlank(String str) {
        String s = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            s = m.replaceAll("");
        }
        return s;
    }

    public static String makeQueryStringAllRegExp(String str) {
        if (GMUtils.isEmpty(str)) {
            return str;
        }
        return str.replace("\\", "\\\\").replace("*", "\\*").replace("+", "\\+").replace("|", "\\|").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("^", "\\^").replace("$", "\\$").replace("[", "\\[").replace("]", "\\]").replace("?", "\\?").replace(",", "\\,").replace(".", "\\.").replace("&", "\\&");
    }

    public static String makeQueryCharAllRegExp(char str) {
        String res = "";
        res = str == '\\' ? "\\\\" : (str == '*' ? "\\*" : (str == '+' ? "\\+" : (str == '|' ? "\\|" : (str == '{' ? "\\{" : (str == '}' ? "\\}" : (str == '(' ? "\\(" : (str == ')' ? "\\)" : (str == '^' ? "\\^" : (str == '$' ? "\\$" : (str == '[' ? "\\[" : (str == ']' ? "\\]" : (str == '?' ? "\\?" : (str == ',' ? "\\," : (str == '.' ? "\\." : (str == '&' ? "\\&" : String.valueOf(res) + str)))))))))))))));
        return res;
    }

    public static List<String> findKeyhasblank(String str, String key) {
        ArrayList<String> strs = new ArrayList<String>();
        try {
            if (!GMUtils.isEmpty(str) && !GMUtils.isEmpty(key)) {
                String tempkey = "";
                if (key.length() >= 2) {
                    char[] ckey = key.toCharArray();
                    tempkey = String.valueOf(tempkey) + GMUtils.makeQueryCharAllRegExp(ckey[0]);
                    int i = 1;
                    while (i < ckey.length - 1) {
                        tempkey = String.valueOf(tempkey) + GMUtils.makeQueryCharAllRegExp(ckey[i]);
                        ++i;
                    }
                    tempkey = String.valueOf(tempkey) + GMUtils.makeQueryCharAllRegExp(ckey[ckey.length - 1]);
                } else {
                    tempkey = key;
                }
                Pattern p = Pattern.compile(tempkey);
                Matcher m = p.matcher(str);
                while (m.find()) {
                    strs.add(m.group());
                }
            }
        }
        catch (Exception e) {
            strs.clear();
            strs.add(key);
        }
        return strs;
    }

    public static byte[] checksig(byte[] orisigbuf) {
        try {
            int length = orisigbuf.length;
            byte lastbyte = orisigbuf[length - 1];
            if (lastbyte == 0) {
                Byte s_lengthbyte;
                int s_length;
                Byte r_lengthbyte;
                int r_length;
                Byte siglengthbyte = orisigbuf[1];
                int siglength = siglengthbyte.intValue();
                if (siglength == (r_length = (r_lengthbyte = Byte.valueOf(orisigbuf[3])).intValue()) + (s_length = (s_lengthbyte = Byte.valueOf(orisigbuf[5 + r_length])).intValue()) + 4) {
                    return orisigbuf;
                }
                byte[] newsig = new byte[length - 1];
                System.arraycopy(orisigbuf, 0, newsig, 0, length - 1);
                newsig[1] = (byte)(siglength - 1);
                return newsig;
            }
            return orisigbuf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return orisigbuf;
        }
    }

    public static byte[] GetSM2PubkeyFromAns1Data(byte[] source) {
        block22: {
            ASN1InputStream input;
            block19: {
                block20: {
                    byte[] byArray;
                    block21: {
                        Throwable throwable = null;
                        Object var2_5 = null;
                        input = new ASN1InputStream(source);
                        try {
                            ASN1Primitive p = input.readObject();
                            ASN1Sequence asn1 = ASN1Sequence.getInstance(p);
                            if (asn1.size() <= 1) break block19;
                            DERBitString _derbitstring = (DERBitString)asn1.getObjectAt(1);
                            byte[] buffer = _derbitstring.getOctets();
                            byte b = buffer[0];
                            if (buffer.length != 65 || b != 4) break block20;
                            byte[] keybuf = new byte[64];
                            System.arraycopy(buffer, 1, keybuf, 0, 64);
                            byArray = keybuf;
                            if (input == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            try {
                                try {
                                    if (input != null) {
                                        input.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        return null;
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return null;
                            }
                        }
                        input.close();
                    }
                    return byArray;
                }
                if (input != null) {
                    input.close();
                }
                return null;
            }
            if (input == null) break block22;
            input.close();
        }
        return null;
    }

    public static String getCertBase64(String certPath) throws Exception {
        byte[] buf = null;
        int fLength = 0;
        String base = "";
        try (FileInputStream fis = null;){
            try {
                fis = new FileInputStream(certPath);
                fLength = fis.available();
                buf = new byte[fLength];
                fis.read(buf, 0, fLength);
                base = Base64.toBase64String(buf);
                fis.close();
            }
            catch (Exception ex) {
                System.out.println("\u8bfb\u8bc1\u4e66\u6587\u4ef6\u51fa\ufffd?!");
                throw ex;
            }
        }
        return base;
    }

    public static String GetSignatureAns1Data(byte[] source) {
        ASN1InputStream input;
        String signdatastr;
        block5: {
            byte[] data = source;
            signdatastr = "";
            input = new ASN1InputStream(data);
            ASN1Primitive p = input.readObject();
            if (p == null) break block5;
            ASN1Sequence asn1 = ASN1Sequence.getInstance(p);
            ASN1Encodable[] o1 = asn1.toArray();
            byte[] ss = o1[0].toASN1Primitive().getEncoded();
            byte[] ss2 = o1[1].toASN1Primitive().getEncoded();
            byte[] smsig = new byte[64];
            Arrays.fill(smsig, 0, 63, (byte)0);
            if (ss.length >= 32 && ss2.length >= 32) {
                System.arraycopy(ss, ss.length - 32, smsig, 0, 32);
                System.arraycopy(ss2, ss2.length - 32, smsig, 32, 32);
                signdatastr = Base64.toBase64String(smsig);
                input.close();
                return signdatastr;
            }
            input.close();
            return "-3";
        }
        try {
            input.close();
            return signdatastr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "-1";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-2";
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static Object getAttributeByName(String keyword) {
        try {
            InitialContext ic = new InitialContext();
            Object s = ic.lookup("java:comp/env/" + keyword);
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String BuilderDN(String m_strCertDN) {
        String strDN = "";
        if (GMUtils.isEmpty(m_strCertDN)) {
            return "";
        }
        if (m_strCertDN.startsWith("C=CN")) {
            String[] slist = m_strCertDN.split(",");
            int i = slist.length - 1;
            while (i > -1) {
                strDN = i == 0 ? String.valueOf(strDN) + slist[i] : String.valueOf(strDN) + slist[i] + ",";
                --i;
            }
        } else {
            String cn = "";
            String o = "";
            String l = "";
            String st = "";
            String dc = "";
            String[] ouList = null;
            cn = GMUtils.getContentFromDN(m_strCertDN, "CN=");
            o = GMUtils.getContentFromDN(m_strCertDN, "O=");
            l = GMUtils.getContentFromDN(m_strCertDN, "L=");
            st = GMUtils.getContentFromDN(m_strCertDN, "ST=");
            dc = GMUtils.getContentFromDN(m_strCertDN, "DC=");
            if (GMUtils.isEmpty(st)) {
                st = GMUtils.getContentFromDN(m_strCertDN, "S=");
            }
            if (cn.equals("")) {
                return "";
            }
            strDN = "CN=" + cn;
            if (m_strCertDN.contains("OU=")) {
                String[] stringArray = ouList = StringUtils.substringsBetween(m_strCertDN, "OU=", ",");
                int n = ouList.length;
                int n2 = 0;
                while (n2 < n) {
                    String ou = stringArray[n2];
                    strDN = String.valueOf(strDN) + ",OU=" + ou;
                    ++n2;
                }
            }
            if (!dc.equals("")) {
                strDN = String.valueOf(strDN) + ",DC=" + dc;
            }
            if (!o.equals("")) {
                strDN = String.valueOf(strDN) + ",O=" + o;
            }
            if (!l.equals("")) {
                strDN = String.valueOf(strDN) + ",L=" + l;
            }
            if (!st.equals("")) {
                strDN = String.valueOf(strDN) + ",ST=" + st;
            }
            strDN = String.valueOf(strDN) + ",C=CN";
        }
        return strDN;
    }

    public static String getContentFromDN(String dn, String dnselect) {
        int ouCount = StringUtils.countMatches((CharSequence)dn, dnselect);
        if (ouCount > 0) {
            String[] ouList = StringUtils.substringsBetween(dn, dnselect, ",");
            if (ouList == null) {
                String res = StringUtils.substringAfter(dn, dnselect);
                return res;
            }
            return ouList[0];
        }
        return "";
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static byte[] compressData(byte[] source) {
        try {
            try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(source.length);
                 GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
                zipStream.write(source);
            }
            byte[] compressedData = byteStream.toByteArray();
            return compressedData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String ProcessDateToString(Date date, String format) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            String dateStr = dateFormat.format(date);
            return dateStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String ProcessDateToString(LocalDateTime date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            String dateStr = date.format(formatter);
            return dateStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocalDateTime ProcessStringToDate(String date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            LocalDateTime formatDateTime = LocalDateTime.parse(date, formatter);
            return formatDateTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LocalDateTime.MIN;
        }
    }

    public static String bytesTohnca(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HNCAArray[v >>> 4];
            hexChars[j * 2 + 1] = HNCAArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static byte[] hncaStringToByte(String hex) {
        if (GMUtils.isEmpty(hex)) {
            return null;
        }
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(GMUtils.charToByte(achar[pos]) << 4 | GMUtils.charToByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }

    private static byte charToByte(char c) {
        return (byte)"01234ABCDEF56789".indexOf(c);
    }

    public static String oidToName(String oid) {
        String name = "";
        switch (oid) {
            case "1.2.156.10197.1.501": {
                name = "SM2";
                break;
            }
            case "1.2.840.113549.1.1.5": {
                name = "SHA1WithRSA";
                break;
            }
            case "1.2.840.113549.1.1.11": {
                name = "sha256WithRSAEncryption";
                break;
            }
            case "1.2.86.11.7.1": {
                name = "\u4e2a\u4eba\u8eab\u4efd\u6807\u8bc6\ufffd?";
                break;
            }
            case "1.2.156.10260.4.1.1": {
                name = "\u4e2a\u4eba\u8eab\u4efd\u6807\u8bc6\ufffd?";
                break;
            }
            case "1.2.86.11.7.2": {
                name = "\u4e2a\u4eba\u793e\u4f1a\u4fdd\u9669\ufffd?";
                break;
            }
            case "1.2.156.10260.4.1.2": {
                name = "\u4e2a\u4eba\u793e\u4f1a\u4fdd\u9669\ufffd?";
                break;
            }
            case "1.2.86.11.7.3": {
                name = "\u4f01\u4e1a\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801";
                break;
            }
            case "1.2.156.10260.4.1.3": {
                name = "\u4f01\u4e1a\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801";
                break;
            }
            case "1.2.86.11.7.4": {
                name = "\u4f01\u4e1a\u5de5\u5546\u6ce8\u518c\ufffd?";
                break;
            }
            case "1.2.156.10260.4.1.4": {
                name = "\u4f01\u4e1a\u5de5\u5546\u6ce8\u518c\ufffd?";
                break;
            }
            case "1.2.86.11.7.5": {
                name = "\u4f01\u4e1a\u7a0e\u53f7";
                break;
            }
            case "1.2.156.10260.4.1.5": {
                name = "\u4f01\u4e1a\u7a0e\u53f7";
                break;
            }
            case "1.2.86.11.7.11": {
                name = "\u6269\u5c55\ufffd?";
                break;
            }
            case "1.2.86.11.7.12": {
                name = "\u6269\u5c55\ufffd?";
                break;
            }
            case "1.2.86.11.7.13": {
                name = "\u6269\u5c55\ufffd?";
                break;
            }
            case "1.2.86.11.7.14": {
                name = "\u6cb3\u5357\u7701\u6295\u8d44\u96c6\u56e2\u552f\ufffd?\u6807\u8bc6\ufffd?";
                break;
            }
            case "1.2.86.11.7.15": {
                name = "\u536b\u751f\u7cfb\u7edf\u552f\u4e00\u6807\u8bc6\ufffd?";
            }
        }
        return name;
    }
}

