/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.uccs.AbstractBusinessHandler;
import com.uccs.PreRouteUtils;
import com.uccs.RouteConfig;
import com.xjyb.config.Constants;
import com.xjyb.exception.InvalidArgumentException;
import com.xjyb.util.SecureCommonUtil;
import java.util.regex.Pattern;
import xjyb.com.alibaba.fastjson.JSONObject;

public class CertserviceImpl
extends AbstractBusinessHandler {
    private CertserviceImpl() {
    }

    public static final CertserviceImpl getInstance() {
        return Holder.INSTANCE;
    }

    public String makePerCert(String transId, String serviceCode, String p10, String userName, String userAdditionalField1, String userAdditionalField2, String userSurname, String userEmail, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userName, "userName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("p10", (Object)p10);
        busJson.put("userName", (Object)userName);
        if (userSurname != null) {
            busJson.put("userSurname", (Object)userSurname);
        }
        if (userEmail != null) {
            busJson.put("userEmail", (Object)userEmail);
        }
        if (userAdditionalField1 != null) {
            busJson.put("userAdditionalField1", (Object)userAdditionalField1);
        }
        if (userAdditionalField2 != null) {
            busJson.put("userAdditionalField2", (Object)userAdditionalField2);
        }
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.MAKECERT_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String makeEntCert(String transId, String serviceCode, String p10, String userName, String userAdditionalField1, String userAdditionalField2, String userSurname, String userEmail, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userName, "userName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("p10", (Object)p10);
        busJson.put("userName", (Object)userName);
        if (userSurname != null) {
            busJson.put("userSurname", (Object)userSurname);
        }
        if (userEmail != null) {
            busJson.put("userEmail", (Object)userEmail);
        }
        if (userAdditionalField1 != null) {
            busJson.put("userAdditionalField1", (Object)userAdditionalField1);
        }
        if (userAdditionalField2 != null) {
            busJson.put("userAdditionalField2", (Object)userAdditionalField2);
        }
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.MAKE_ENT_CERT_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String updateCert(String transId, String serviceCode, String cst, String certSn, String newP10, String pkcs7, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cst, "cst\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(certSn, "certSn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(newP10, "newP10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(pkcs7, "pkcs7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("cst", (Object)cst);
        busJson.put("certSn", (Object)certSn);
        busJson.put("newP10", (Object)newP10);
        busJson.put("pkcs7", (Object)pkcs7);
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.UPDATECERT_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String revokeCert(String transId, String serviceCode, String certSn, String revokeReason, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(certSn, "certSn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(revokeReason, "revokeReason\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("certSn", (Object)certSn);
        busJson.put("revokeReason", (Object)revokeReason);
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.REVOKECERT_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sealImgUpload(String transId, String sealImgName, String sealImg, String orgCertNum, String serviceCode, String sealType) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(sealImgName, "sealImgName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(sealImg, "sealImg\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("sealImgName", (Object)sealImgName);
        busJson.put("sealImg", (Object)sealImg);
        busJson.put("orgCertNum", (Object)orgCertNum);
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        if (serviceCode != null) {
            busJson.put("sealType", (Object)sealType);
        }
        return this.dealBussiness(RouteConfig.UPLOADSEAL_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sealImgDownload(String transId, String sealImgNum, String serviceCode) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(sealImgNum, "sealImgNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("sealImgNum", (Object)sealImgNum);
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        return this.dealBussiness(RouteConfig.cert_sealImgDownload_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String makeCert(String transId, String orgName, String serviceCode, String account, String cardType, String cardNumber, String realName) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(orgName, "orgName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("orgName", (Object)orgName);
        busJson.put("serviceCode", (Object)serviceCode);
        if (account != null) {
            busJson.put("account", (Object)account);
        }
        if (cardType != null) {
            busJson.put("cardType", (Object)cardType);
        }
        if (cardNumber != null) {
            busJson.put("cardNumber", (Object)cardNumber);
        }
        if (realName != null) {
            busJson.put("realName", (Object)realName);
        }
        return this.dealBussiness(RouteConfig.SIGNMULTICA_URL, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signature(String transId, String reqDocHash, String orgCertNum, String sealImgNum, String serviceCode, String account, String uuid, String signTitle, String endFlag, String signWithTimeStamp) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("orgCertNum", (Object)orgCertNum);
        if (sealImgNum != null) {
            busJson.put("sealImgNum", (Object)sealImgNum);
        }
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        if (account != null) {
            busJson.put("account", (Object)account);
        }
        if (uuid != null) {
            busJson.put("uuid", (Object)uuid);
        }
        if (signTitle != null) {
            busJson.put("signTitle", (Object)signTitle);
        }
        if (endFlag != null) {
            busJson.put("endFlag", (Object)endFlag);
        }
        if (signWithTimeStamp != null) {
            busJson.put("signWithTimeStamp", (Object)signWithTimeStamp);
        }
        return this.dealBussiness(RouteConfig.cert_enterpriseSeal_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signatureP1(String transId, String reqDocHash, String orgCertNum, String sealImgNum, String serviceCode, String account, String uuid, String signTitle, String endFlag) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("orgCertNum", (Object)orgCertNum);
        if (sealImgNum != null) {
            busJson.put("sealImgNum", (Object)sealImgNum);
        }
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        if (account != null) {
            busJson.put("account", (Object)account);
        }
        if (uuid != null) {
            busJson.put("uuid", (Object)uuid);
        }
        if (signTitle != null) {
            busJson.put("signTitle", (Object)signTitle);
        }
        if (endFlag != null) {
            busJson.put("endFlag", (Object)endFlag);
        }
        return this.dealBussiness(RouteConfig.cert_enterpriseSealP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String hashSignVerify(String transId, String serviceCode, String reqDocHash, String signValue, String signCert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signValue, "signValue\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("signValue", (Object)signValue);
        if (signCert != null) {
            busJson.put("signCert", (Object)signCert);
        }
        String str = null;
        try {
            str = this.dealBussiness(RouteConfig.cert_hashSignVerify_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
            System.out.println("------------P7hash\u503c\u7b7e\u540d\u5bc6\u670d\u9a8c\u7b7e------------");
        }
        catch (Exception e) {
            boolean hashSignVerify = this.secureService.hashSignVerify(reqDocHash, signValue);
            JSONObject dataJson = new JSONObject();
            dataJson.put("state", (Object)(hashSignVerify ? "00" : "01"));
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0");
            reJson.put("message", (Object)"success");
            reJson.put("transId", (Object)transId);
            reJson.put("data", (Object)dataJson.toJSONString());
            System.out.println(reJson);
            System.out.println("------------P7hash\u503c\u7b7e\u540d\u672c\u5730\u9a8c\u7b7e------------");
            return reJson.toJSONString();
        }
        return str;
    }

    public String hashSignVerifyP1(String transId, String serviceCode, String reqDocHash, String signValue, String signCert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signValue, "signValue\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signCert, "signCert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("signValue", (Object)signValue);
        busJson.put("signCert", (Object)signCert);
        String str = null;
        try {
            str = this.dealBussiness(RouteConfig.cert_hashSignVerifyP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
            System.out.println("------------P1hash\u503c\u7b7e\u540d\u5bc6\u670d\u9a8c\u7b7e------------");
        }
        catch (Exception e) {
            boolean hashSignVerifyP1 = this.secureService.hashSignVerifyP1(serviceCode, reqDocHash, signValue, signCert);
            JSONObject dataJson = new JSONObject();
            dataJson.put("state", (Object)(hashSignVerifyP1 ? "00" : "01"));
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0");
            reJson.put("message", (Object)"success");
            reJson.put("transId", (Object)transId);
            reJson.put("data", (Object)dataJson.toJSONString());
            System.out.println(reJson);
            System.out.println("------------P1hash\u503c\u7b7e\u540d\u672c\u5730\u9a8c\u7b7e------------");
            return reJson.toJSONString();
        }
        return str;
    }

    public String incidentCert(String transId, String encData, String attachmentType, String attachmentHash) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(encData, "encData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("encData", (Object)encData);
        if (attachmentType != null) {
            busJson.put("attachmentType", (Object)attachmentType);
        }
        if (attachmentHash != null) {
            busJson.put("attachmentHash", (Object)attachmentHash);
        }
        return this.dealBussiness(RouteConfig.cert_incidentCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String incidenSignature(String transId, String reqDocHash, String incidentId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(incidentId, "incidentId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("incidentId", (Object)incidentId);
        return this.dealBussiness(RouteConfig.cert_incidenSignature_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String incidenSignatureP1(String transId, String reqDocHash, String incidentId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(incidentId, "incidentId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("incidentId", (Object)incidentId);
        return this.dealBussiness(RouteConfig.cert_incidenSignatureP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String random(String transId, String ranLen) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(ranLen, "ranLen\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("ranLen", (Object)ranLen);
        return this.dealBussiness(RouteConfig.cert_random_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String equipmentCert(String transId, String serviceCode, String p10, String templatePolicyID, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(templatePolicyID, "templatePolicyID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("p10", (Object)p10);
        busJson.put("templatePolicyID", (Object)templatePolicyID);
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.cert_equipmentCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String httpsCert(String transId, String serviceCode, String dn, String templatePolicyID, String raId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(dn, "dn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(templatePolicyID, "templatePolicyID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("dn", (Object)dn);
        busJson.put("templatePolicyID", (Object)templatePolicyID);
        if (raId != null) {
            busJson.put("raId", (Object)raId);
        }
        if (Constants.raId != null) {
            busJson.put("raId", (Object)Constants.raId);
        }
        return this.dealBussiness(RouteConfig.cert_httpsCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String makeDoubleCert(String transId, String serviceCode, String p10, String templatePolicyID) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(templatePolicyID, "templatePolicyID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("p10", (Object)p10);
        busJson.put("templatePolicyID", (Object)templatePolicyID);
        return this.dealBussiness(RouteConfig.cert_makeDoubleCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String downloadCRL(String transId, String serviceCode, String templatePolicyID, String provinceID) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(templatePolicyID, "templatePolicyID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(provinceID, "provinceID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("templatePolicyID", (Object)templatePolicyID);
        busJson.put("provinceID", (Object)provinceID);
        return this.dealBussiness(RouteConfig.cert_downloadCRL_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String queryCertState(String transId, String serviceCode, String cert, String provinceID) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(serviceCode, "serviceCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cert, "cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(provinceID, "provinceID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("cert", (Object)cert);
        busJson.put("provinceID", (Object)provinceID);
        return this.dealBussiness(RouteConfig.cert_queryCertState_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String queryCert(String transId, String certSn) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(certSn, "certSn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("certSn", (Object)certSn);
        return this.dealBussiness(RouteConfig.cert_queryCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signVerify(String transId, String serviceCode, String reqDoc, String signValue, String signCert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDoc, "reqDoc\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signValue, "signValue\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, reqDoc);
        if (reqDoc.length() >= 2000) {
            throw new InvalidArgumentException("reqDoc\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc72k\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6:" + reqDoc.length());
        }
        if (!boo) {
            throw new InvalidArgumentException("reqDoc\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("reqDoc", (Object)reqDoc);
        busJson.put("signValue", (Object)signValue);
        if (signCert != null) {
            busJson.put("signCert", (Object)signCert);
        }
        String str = null;
        try {
            str = this.dealBussiness(RouteConfig.cert_signVerify_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
            System.out.println("------------P7\u539f\u6587\u7b7e\u540d\u5bc6\u670d\u9a8c\u7b7e------------");
        }
        catch (Exception e) {
            boolean signVerify = this.secureService.signVerify(reqDoc, signValue);
            JSONObject dataJson = new JSONObject();
            dataJson.put("state", (Object)(signVerify ? "00" : "01"));
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0");
            reJson.put("message", (Object)"success");
            reJson.put("transId", (Object)transId);
            reJson.put("data", (Object)dataJson.toJSONString());
            System.out.println(reJson);
            System.out.println("------------P7\u539f\u6587\u7b7e\u540d\u672c\u5730\u9a8c\u7b7e------------");
            return reJson.toJSONString();
        }
        return str;
    }

    public String signVerifyP1(String transId, String serviceCode, String reqDoc, String signValue, String signCert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDoc, "reqDoc\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signValue, "signValue\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signCert, "signCert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, reqDoc);
        if (reqDoc.length() >= 2000) {
            throw new InvalidArgumentException("reqDoc\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc72k\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6:" + reqDoc.length());
        }
        if (!boo) {
            throw new InvalidArgumentException("reqDoc\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("serviceCode", (Object)serviceCode);
        busJson.put("reqDoc", (Object)reqDoc);
        busJson.put("signValue", (Object)signValue);
        busJson.put("signCert", (Object)signCert);
        String str = null;
        try {
            str = this.dealBussiness(RouteConfig.cert_signVerifyP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
            System.out.println("------------P1\u539f\u6587\u7b7e\u540d\u5bc6\u670d\u9a8c\u7b7e------------");
        }
        catch (Exception e) {
            boolean signVerifyP1 = this.secureService.signVerifyP1(serviceCode, reqDoc, signValue, signCert);
            JSONObject dataJson = new JSONObject();
            dataJson.put("state", (Object)(signVerifyP1 ? "00" : "01"));
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0");
            reJson.put("message", (Object)"success");
            reJson.put("transId", (Object)transId);
            reJson.put("data", (Object)dataJson.toJSONString());
            System.out.println(reJson);
            System.out.println("------------P1\u539f\u6587\u7b7e\u540d\u672c\u5730\u9a8c\u7b7e------------");
            return reJson.toJSONString();
        }
        return str;
    }

    public String incidentCertMake(String transId, String p10, String ext, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(ext, "ext\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, ext);
        if (!boo) {
            throw new InvalidArgumentException("ext\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("p10", (Object)p10);
        busJson.put("ext", (Object)ext);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.cert_incidentCertMake_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String certAuth(String transId, String orgCertNum, String type, String phone, String sign, String certSn, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(type, "type\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(phone, "phone\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("orgCertNum", (Object)orgCertNum);
        busJson.put("type", (Object)type);
        busJson.put("phone", (Object)phone);
        if (sign != null) {
            busJson.put("sign", (Object)sign);
        }
        if (certSn != null) {
            busJson.put("certSn", (Object)certSn);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.cert_certAuth_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sealsRevoked(String transId, String sealNum, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(sealNum, "sealNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("sealNum", (Object)sealNum);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.cert_sealsRevoked_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sealQuery(String transId, String sealNum, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(sealNum, "sealNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("sealNum", (Object)sealNum);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.cert_sealQuery_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String smsCode(String transId, String orgCertNum, String phone, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(phone, "phone\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("orgCertNum", (Object)orgCertNum);
        busJson.put("phone", (Object)phone);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.cert_smsCode_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signP7WithAuth(String transId, String reqDocHash, String orgCertNum, String authCode, String certSn, String default1, String default2, String default3, String default4, String signWithTimeStamp) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(authCode, "authCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("orgCertNum", (Object)orgCertNum);
        busJson.put("authCode", (Object)authCode);
        if (certSn != null) {
            busJson.put("certSn", (Object)certSn);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        if (signWithTimeStamp != null) {
            busJson.put("signWithTimeStamp", (Object)signWithTimeStamp);
        }
        return this.dealBussiness(RouteConfig.cert_signP7WithAuth_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signP1WithAuth(String transId, String reqDocHash, String orgCertNum, String authCode, String certSn, String serviceCode, String default1, String default2, String default3) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDocHash, "reqDocHash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(authCode, "authCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDocHash", (Object)reqDocHash);
        busJson.put("orgCertNum", (Object)orgCertNum);
        busJson.put("authCode", (Object)authCode);
        if (certSn != null) {
            busJson.put("certSn", (Object)certSn);
        }
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        return this.dealBussiness(RouteConfig.cert_signP1WithAuth_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String symmetricGenerate(String transId, String bussType, String keyUsage, String genMode, String cryptographGroup, String keyIndex, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String distributeFlag, String encCryptographGroup, String lmk, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(bussType, "bussType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(keyUsage, "keyUsage\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(encCryptographGroup, "encCryptographGroup\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(lmk, "lmk\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkGenMode(genMode, cryptographGroup, keyIndex);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        JSONObject busJson = new JSONObject();
        busJson.put("bussType", (Object)bussType);
        busJson.put("keyUsage", (Object)keyUsage);
        busJson.put("genMode", (Object)genMode);
        int gMode = Integer.parseInt(genMode);
        switch (gMode) {
            case 0: {
                break;
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
                break;
            }
        }
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        busJson.put("encCryptographGroup", (Object)encCryptographGroup);
        busJson.put("lmk", (Object)lmk);
        if (distributeFlag != null) {
            busJson.put("distributeFlag", (Object)distributeFlag);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmSymmetric, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String symmetricDistribute(String transId, String keyId, String encType, String encKeyId, String encKeyVersion, String pubKey, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkEncType(encType, encKeyId, pubKey);
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        busJson.put("encType", (Object)encType);
        int eType = Integer.parseInt(encType);
        switch (eType) {
            case 1: {
                busJson.put("encKeyId", (Object)encKeyId);
                break;
            }
            case 2: {
                busJson.put("pubKey", (Object)pubKey);
                break;
            }
        }
        if (encKeyVersion != null) {
            busJson.put("encKeyVersion", (Object)encKeyVersion);
        }
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmDistribute, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String symmetricQuery(String transId, String keyId, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmQuery, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String symmetricUpdate(String transId, String keyId, String genMode, String cryptographGroup, String keyIndex, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String encCryptographGroup, String lmk, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkGenMode(genMode, cryptographGroup, keyIndex);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        busJson.put("genMode", (Object)genMode);
        int gMode = Integer.parseInt(genMode);
        switch (gMode) {
            case 0: {
                break;
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
                break;
            }
        }
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        if (encCryptographGroup != null) {
            busJson.put("encCryptographGroup", (Object)encCryptographGroup);
        }
        if (lmk != null) {
            busJson.put("lmk", (Object)lmk);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmUpdate, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sm4Encrypt(String transId, String keyId, String paddingType, String randomLen, String random, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String inData, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!(paddingType == null || "0".equals(paddingType) || "1".equals(paddingType) || "2".equals(paddingType) || "3".equals(paddingType) || "4".equals(paddingType) || "5".equals(paddingType) || "6".equals(paddingType) || "7".equals(paddingType))) {
            throw new InvalidArgumentException("encType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3,4,5,6,7\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + paddingType);
        }
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        if (paddingType != null) {
            busJson.put("paddingType", (Object)paddingType);
        } else {
            busJson.put("paddingType", (Object)"4");
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        busJson.put("inData", (Object)inData);
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmEncrypData, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String sm4Decrypt(String transId, String keyId, String paddingType, String randomLen, String random, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String inData, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!(paddingType == null || "0".equals(paddingType) || "1".equals(paddingType) || "2".equals(paddingType) || "3".equals(paddingType) || "4".equals(paddingType) || "5".equals(paddingType) || "6".equals(paddingType) || "7".equals(paddingType))) {
            throw new InvalidArgumentException("encType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3,4,5,6,7\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + paddingType);
        }
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        if (paddingType != null) {
            busJson.put("paddingType", (Object)paddingType);
        } else {
            busJson.put("paddingType", (Object)"4");
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        busJson.put("inData", (Object)inData);
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmDecryptData, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String macGenerate(String transId, String keyId, String randomLen, String random, String macData, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String macFlag, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(macData, "macData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(macFlag, "macFlag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        busJson.put("macData", (Object)macData);
        busJson.put("macFlag", (Object)macFlag);
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmGenMac, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String macVerify(String transId, String keyId, String randomLen, String random, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String inData, String mac, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(mac, "mac\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        busJson.put("inData", (Object)inData);
        busJson.put("mac", (Object)mac);
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmVerifyMac, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String encryptAndMac(String transId, String keyId, String paddingType, String randomLen, String random, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String macFlag, String inData, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(macFlag, "macFlag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        if (!(paddingType == null || "0".equals(paddingType) || "1".equals(paddingType) || "2".equals(paddingType) || "3".equals(paddingType) || "4".equals(paddingType) || "5".equals(paddingType) || "6".equals(paddingType) || "7".equals(paddingType))) {
            throw new InvalidArgumentException("encType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3,4,5,6,7\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + paddingType);
        }
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        if (paddingType != null) {
            busJson.put("paddingType", (Object)paddingType);
        } else {
            busJson.put("paddingType", (Object)"4");
        }
        busJson.put("inData", (Object)inData);
        busJson.put("macFlag", (Object)macFlag);
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmEncrypAndMac, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String verifyAndDecrypt(String transId, String keyId, String paddingType, String randomLen, String random, String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3, String inData, String mac, String keyVersion, String default1, String default2, String default3, String default4) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(keyId, "keyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(mac, "mac\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkRandomLen(random, randomLen);
        SecureCommonUtil.checkDiversify(diversifyTimes, diversifyFactor1, diversifyFactor2, diversifyFactor3);
        if (!(paddingType == null || "0".equals(paddingType) || "1".equals(paddingType) || "2".equals(paddingType) || "3".equals(paddingType) || "4".equals(paddingType) || "5".equals(paddingType) || "6".equals(paddingType) || "7".equals(paddingType))) {
            throw new InvalidArgumentException("encType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3,4,5,6,7\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + paddingType);
        }
        JSONObject busJson = new JSONObject();
        busJson.put("keyId", (Object)keyId);
        if (paddingType != null) {
            busJson.put("paddingType", (Object)paddingType);
        } else {
            busJson.put("paddingType", (Object)"4");
        }
        busJson.put("inData", (Object)inData);
        busJson.put("mac", (Object)mac);
        busJson.put("diversifyTimes", (Object)diversifyTimes);
        int times = Integer.parseInt(diversifyTimes);
        switch (times) {
            case 0: {
                break;
            }
            case 3: {
                busJson.put("diversifyFactor3", (Object)diversifyFactor3);
            }
            case 2: {
                busJson.put("diversifyFactor2", (Object)diversifyFactor2);
            }
            case 1: {
                busJson.put("diversifyFactor1", (Object)diversifyFactor1);
            }
        }
        if (keyVersion != null) {
            busJson.put("keyVersion", (Object)keyVersion);
        }
        if (randomLen != null) {
            busJson.put("randomLen", (Object)randomLen);
        }
        if (random != null) {
            busJson.put("random", (Object)random);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        if (default4 != null) {
            busJson.put("default4", (Object)default4);
        }
        return this.dealBussiness(RouteConfig.atomicservice_HsmVerifyAndDecrypt, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String createTsResponse(String transId, String timestampRequest, String signAlgorithm) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(timestampRequest, "timestampRequest\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signAlgorithm, "signAlgorithm\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, timestampRequest);
        if (!boo) {
            throw new InvalidArgumentException("timestampRequest\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("timestampRequest", (Object)timestampRequest);
        busJson.put("signAlgorithm", (Object)signAlgorithm);
        return this.dealBussiness(RouteConfig.timestamp_CreateTsResponse, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String getPubInfo(String transId, String kgcId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        return this.dealBussiness(RouteConfig.atomSm9_GetPubInfo, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signatureSm9(String transId, String kgcId, String userId, String inData) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, inData);
        if (!boo) {
            throw new InvalidArgumentException("inData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("userId", (Object)userId);
        busJson.put("inData", (Object)inData);
        return this.dealBussiness(RouteConfig.atomSm9_Signature, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String verifySm9(String transId, String kgcId, String userId, String inData, String signData) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signData, "signData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo1 = Pattern.matches(base64Pattern, inData);
        if (!boo1) {
            throw new InvalidArgumentException("inData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        boolean boo2 = Pattern.matches(base64Pattern, signData);
        if (!boo2) {
            throw new InvalidArgumentException("signData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("userId", (Object)userId);
        busJson.put("inData", (Object)inData);
        busJson.put("signData", (Object)signData);
        return this.dealBussiness(RouteConfig.atomSm9_Verify, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String encryptSm9(String transId, String kgcId, String userId, String inData) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo1 = Pattern.matches(base64Pattern, inData);
        if (!boo1) {
            throw new InvalidArgumentException("inData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("userId", (Object)userId);
        busJson.put("inData", (Object)inData);
        return this.dealBussiness(RouteConfig.atomSm9_Encrypt, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String decryptSm9(String transId, String kgcId, String userId, String encData) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(userId, "userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(encData, "encData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, encData);
        if (!boo) {
            throw new InvalidArgumentException("encData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("userId", (Object)userId);
        busJson.put("encData", (Object)encData);
        return this.dealBussiness(RouteConfig.atomSm9_Decrypt, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String genChipKey(String transId, String kgcId, String chipId, String chip_name, String chip_model, String chip_manufacturer, String imei, String imsi, String create_by, String destroy_by, String encKey, String algFlag, String mode, String iv) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(chipId, "chipId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(encKey, "encKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(algFlag, "algFlag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("chipId", (Object)chipId);
        busJson.put("encKey", (Object)encKey);
        busJson.put("algFlag", (Object)algFlag);
        if (chip_name != null) {
            busJson.put("chip_name", (Object)chip_name);
        }
        if (chip_model != null) {
            busJson.put("chip_model", (Object)chip_model);
        }
        if (chip_manufacturer != null) {
            busJson.put("chip_manufacturer", (Object)chip_manufacturer);
        }
        if (imei != null) {
            busJson.put("imei", (Object)imei);
        }
        if (imsi != null) {
            busJson.put("imsi", (Object)imsi);
        }
        if (create_by != null) {
            busJson.put("create_by", (Object)create_by);
        }
        if (destroy_by != null) {
            busJson.put("destroy_by", (Object)destroy_by);
        }
        if (mode != null) {
            busJson.put("mode", (Object)mode);
        }
        if (iv != null) {
            busJson.put("iv", (Object)iv);
        }
        return this.dealBussiness(RouteConfig.atomSm9_GenChipKey, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String genDeviceKey(String transId, String kgcId, String deviceId, String deviceName, String imei, String imsi, String serialNo, String chipId, String province, String city, String create_by, String destroy_by, String encKey, String algFlag, String mode, String iv, String signAlg, String sign) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(deviceId, "deviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(deviceName, "deviceName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(encKey, "encKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(algFlag, "algFlag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(mode, "mode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(signAlg, "signAlg\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        busJson.put("deviceId", (Object)deviceId);
        busJson.put("deviceName", (Object)deviceName);
        busJson.put("encKey", (Object)encKey);
        busJson.put("algFlag", (Object)algFlag);
        busJson.put("mode", (Object)mode);
        busJson.put("signAlg", (Object)signAlg);
        if (mode != null) {
            busJson.put("imei", (Object)imei);
        }
        if (mode != null) {
            busJson.put("imsi", (Object)imsi);
        }
        if (mode != null) {
            busJson.put("serialNo", (Object)serialNo);
        }
        if (mode != null) {
            busJson.put("chipId", (Object)chipId);
        }
        if (mode != null) {
            busJson.put("province", (Object)province);
        }
        if (mode != null) {
            busJson.put("city", (Object)city);
        }
        if (mode != null) {
            busJson.put("create_by", (Object)create_by);
        }
        if (mode != null) {
            busJson.put("destroy_by", (Object)destroy_by);
        }
        if (mode != null) {
            busJson.put("iv", (Object)iv);
        }
        if (mode != null) {
            busJson.put("sign", (Object)sign);
        }
        return this.dealBussiness(RouteConfig.atomSm9_GenDeviceKey, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String getDeviceKeyStatus(String transId, String kgcId, String chipId, String deviceId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(kgcId, "kgcId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(deviceId, "deviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("kgcId", (Object)kgcId);
        if (chipId != null) {
            busJson.put("chipId", (Object)chipId);
        }
        busJson.put("deviceId", (Object)deviceId);
        return this.dealBussiness(RouteConfig.atomSm9_GetDeviceKeyStatus, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String deviceCheck(String transId, String deviceId, String imei, String imsi) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(deviceId, "deviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("deviceId", (Object)deviceId);
        if (imei != null) {
            busJson.put("imei", (Object)imei);
        }
        if (imsi != null) {
            busJson.put("imsi", (Object)imsi);
        }
        return this.dealBussiness(RouteConfig.atomSm9_DeviceCheck, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String deleteCert(String transId, String orgCertNum, String serviceCode) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("orgCertNum", (Object)orgCertNum);
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        return this.dealBussiness(RouteConfig.cert_deleteCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String userinfoPcUpload(String transId, String usertype, String name, String idnum, String phonenum, String idfile, String unitname, String chinaorgcode, String leagalperson, String leaguepaperId, String transname, String transpaperId, String transphone, String businesslicensefile, String certapplication, String leaguepaperIdfile, String authorization, String receipt, String signfile, String sealfile, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(usertype, "usertype\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(idfile, "idfile\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(unitname, "unitname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (usertype.equals("02")) {
            SecureCommonUtil.requireNonNull(name, "name\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(idnum, "idnum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(phonenum, "phonenum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else if (usertype.equals("01")) {
            SecureCommonUtil.requireNonNull(chinaorgcode, "chinaorgcode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(leagalperson, "leagalperson\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(leaguepaperId, "leaguepaperId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(transname, "transname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(transpaperId, "transpaperId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(transphone, "transphone\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(businesslicensefile, "businesslicensefile\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(certapplication, "certapplication\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(leaguepaperIdfile, "leaguepaperIdfile\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(authorization, "authorization\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(signfile, "signfile\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(sealfile, "sealfile\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else {
            throw new InvalidArgumentException("usertype\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("usertype", (Object)usertype);
        busJson.put("idfile", (Object)idfile);
        busJson.put("unitname", (Object)unitname);
        if (name != null) {
            busJson.put("name", (Object)name);
        }
        if (idnum != null) {
            busJson.put("idnum", (Object)idnum);
        }
        if (phonenum != null) {
            busJson.put("phonenum", (Object)phonenum);
        }
        if (chinaorgcode != null) {
            busJson.put("chinaorgcode", (Object)chinaorgcode);
        }
        if (leagalperson != null) {
            busJson.put("leagalperson", (Object)leagalperson);
        }
        if (leaguepaperId != null) {
            busJson.put("leaguepaperId", (Object)leaguepaperId);
        }
        if (transname != null) {
            busJson.put("transname", (Object)transname);
        }
        if (transpaperId != null) {
            busJson.put("transpaperId", (Object)transpaperId);
        }
        if (transphone != null) {
            busJson.put("transphone", (Object)transphone);
        }
        if (businesslicensefile != null) {
            busJson.put("businesslicensefile", (Object)businesslicensefile);
        }
        if (certapplication != null) {
            busJson.put("certapplication", (Object)certapplication);
        }
        if (leaguepaperIdfile != null) {
            busJson.put("leaguepaperIdfile", (Object)leaguepaperIdfile);
        }
        if (authorization != null) {
            busJson.put("authorization", (Object)authorization);
        }
        if (receipt != null) {
            busJson.put("receipt", (Object)receipt);
        }
        if (signfile != null) {
            busJson.put("signfile", (Object)signfile);
        }
        if (sealfile != null) {
            busJson.put("sealfile", (Object)sealfile);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.certservice_userinfoPCUpload_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String userinfoAppUpload(String transId, String usertype, String name, String idnum, String phonenum, String idfile, String unitname, String chinaorgcode, String leagalperson, String leaguepaperId, String transname, String transpaperId, String transphone, String businesslicensefile, String certapplication, String leaguepaperIdfile, String authorization, String receipt, String signfile, String sealfile, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(usertype, "usertype\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(unitname, "unitname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(chinaorgcode, "chinaorgcode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(leagalperson, "leagalperson\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(leaguepaperId, "leaguepaperId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (usertype.equals("02")) {
            SecureCommonUtil.requireNonNull(name, "name\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(idnum, "idnum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SecureCommonUtil.requireNonNull(phonenum, "phonenum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else if (!usertype.equals("01")) {
            throw new InvalidArgumentException("usertype\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject busJson = new JSONObject();
        busJson.put("usertype", (Object)usertype);
        busJson.put("unitname", (Object)unitname);
        busJson.put("chinaorgcode", (Object)chinaorgcode);
        busJson.put("leagalperson", (Object)leagalperson);
        busJson.put("leaguepaperId", (Object)leaguepaperId);
        if (idfile != null) {
            busJson.put("idfile", (Object)idfile);
        }
        if (name != null) {
            busJson.put("name", (Object)name);
        }
        if (idnum != null) {
            busJson.put("idnum", (Object)idnum);
        }
        if (phonenum != null) {
            busJson.put("phonenum", (Object)phonenum);
        }
        if (transname != null) {
            busJson.put("transname", (Object)transname);
        }
        if (transpaperId != null) {
            busJson.put("transpaperId", (Object)transpaperId);
        }
        if (transphone != null) {
            busJson.put("transphone", (Object)transphone);
        }
        if (businesslicensefile != null) {
            busJson.put("businesslicensefile", (Object)businesslicensefile);
        }
        if (certapplication != null) {
            busJson.put("certapplication", (Object)certapplication);
        }
        if (leaguepaperIdfile != null) {
            busJson.put("leaguepaperIdfile", (Object)leaguepaperIdfile);
        }
        if (authorization != null) {
            busJson.put("authorization", (Object)authorization);
        }
        if (receipt != null) {
            busJson.put("receipt", (Object)receipt);
        }
        if (signfile != null) {
            busJson.put("signfile", (Object)signfile);
        }
        if (sealfile != null) {
            busJson.put("sealfile", (Object)sealfile);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.certservice_userinfoAPPUpload_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String makeunitcert(String transId, String unitname, String chinaorgcode, String leagalperson, String leaguepaperId, String transname, String transphone, String transpaperId, String p10, String canum, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(unitname, "unitname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(chinaorgcode, "chinaorgcode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(leagalperson, "leagalperson\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(leaguepaperId, "leaguepaperId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("unitname", (Object)unitname);
        busJson.put("chinaorgcode", (Object)chinaorgcode);
        busJson.put("leagalperson", (Object)leagalperson);
        busJson.put("leaguepaperId", (Object)leaguepaperId);
        busJson.put("transname", (Object)transname);
        busJson.put("transphone", (Object)transphone);
        busJson.put("transpaperId", (Object)transpaperId);
        busJson.put("p10", (Object)p10);
        busJson.put("canum", (Object)canum);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.moreCA_makeUnitCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String makepersoncert(String transId, String usesrname, String idnum, String phonenum, String unitname, String p10, String canum, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(usesrname, "usesrname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(idnum, "idnum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(phonenum, "phonenum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(unitname, "unitname\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("usesrname", (Object)usesrname);
        busJson.put("idnum", (Object)idnum);
        busJson.put("phonenum", (Object)phonenum);
        busJson.put("unitname", (Object)unitname);
        busJson.put("p10", (Object)p10);
        busJson.put("canum", (Object)canum);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.moreCA_makepersonCert_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String unitcertupdate(String transId, String certsn, String p10, String canum, String pkcs7, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(certsn, "certsn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("certsn", (Object)certsn);
        busJson.put("p10", (Object)p10);
        busJson.put("canum", (Object)canum);
        busJson.put("pkcs7", (Object)pkcs7);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.moreCA_unitCertupdate_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String personcertupdate(String transId, String certsn, String p10, String canum, String pkcs7, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(certsn, "certsn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(p10, "p10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("certsn", (Object)certsn);
        busJson.put("p10", (Object)p10);
        busJson.put("canum", (Object)canum);
        busJson.put("pkcs7", (Object)pkcs7);
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        return this.dealBussiness(RouteConfig.moreCA_personCertupdate_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String unitcertrevoke(String transId, String canum, String certsn, String message) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(certsn, "certsn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("certsn", (Object)certsn);
        busJson.put("message", (Object)message);
        busJson.put("canum", (Object)canum);
        return this.dealBussiness(RouteConfig.moreCA_unitcertRevoke_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String personcertrevoke(String transId, String canum, String certsn) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(certsn, "certsn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("certsn", (Object)certsn);
        busJson.put("canum", (Object)canum);
        return this.dealBussiness(RouteConfig.moreCA_personcertRevoke_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String unitquerycertstate(String transId, String canum, String cert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cert, "cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("canum", (Object)canum);
        busJson.put("cert", (Object)cert);
        return this.dealBussiness(RouteConfig.moreCA_unitqueryCertState_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String personquerycertstate(String transId, String canum, String cert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(canum, "canum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cert, "cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("canum", (Object)canum);
        busJson.put("cert", (Object)cert);
        return this.dealBussiness(RouteConfig.moreCA_personqueryCertState_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String querycertstate(String transId, String cert) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(cert, "cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("cert", (Object)cert);
        return this.dealBussiness(RouteConfig.moreCA_querycertstate_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String companyFileUpload(String transId, String companyCode, String businessLicense, String identityCard, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(companyCode, "companyCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(businessLicense, "businessLicense\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(identityCard, "identityCard\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("companyCode", (Object)companyCode);
        busJson.put("businessLicense", (Object)businessLicense);
        busJson.put("identityCard", (Object)identityCard);
        return this.dealBussiness(RouteConfig.certService_companyFileUpload_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String searchCompanyStatus(String transId, String companyCode, String default1, String default2) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(companyCode, "companyCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("companyCode", (Object)companyCode);
        return this.dealBussiness(RouteConfig.certService_searchCompanyStatus_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String signatureDataP1(String transId, String reqDoc, String orgCertNum, String serviceCode, String default1, String default2, String default3) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDoc, "reqDoc\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(orgCertNum, "orgCertNum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDoc", (Object)reqDoc);
        busJson.put("orgCertNum", (Object)orgCertNum);
        if (serviceCode != null) {
            busJson.put("serviceCode", (Object)serviceCode);
        }
        if (default1 != null) {
            busJson.put("default1", (Object)default1);
        }
        if (default2 != null) {
            busJson.put("default2", (Object)default2);
        }
        if (default3 != null) {
            busJson.put("default3", (Object)default3);
        }
        return this.dealBussiness(RouteConfig.cert_signatureDataP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    public String incidenSignatureDataP1(String transId, String reqDoc, String incidentId) {
        SecureCommonUtil.checkTransId(transId);
        SecureCommonUtil.requireNonNull(reqDoc, "reqDoc\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(incidentId, "incidentId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject busJson = new JSONObject();
        busJson.put("reqDoc", (Object)reqDoc);
        busJson.put("incidentId", (Object)incidentId);
        return this.dealBussiness(RouteConfig.cert_incidenSignatureDataP1_url, transId, busJson.toJSONString(), PreRouteUtils::requestBusiness);
    }

    private static class Holder {
        private static final CertserviceImpl INSTANCE = new CertserviceImpl();

        private Holder() {
        }
    }
}

