/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.core.poll;

import com.xjyb.config.PasswordServiceConfig;
import java.util.concurrent.TimeUnit;
import xjyb.org.apache.http.conn.HttpClientConnectionManager;

public class IdleConnectionMonitor
implements Runnable {
    private final HttpClientConnectionManager connMgr;
    private final PasswordServiceConfig config;
    private volatile boolean shutdown;

    public IdleConnectionMonitor(HttpClientConnectionManager connMgr, PasswordServiceConfig config) {
        this.connMgr = connMgr;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            IdleConnectionMonitor idleConnectionMonitor = this;
            synchronized (idleConnectionMonitor) {
                try {
                    this.wait(this.config.getMonitorInterval());
                    this.connMgr.closeIdleConnections(this.config.getMaxIdleConnectionMs(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitor idleConnectionMonitor = this;
        synchronized (idleConnectionMonitor) {
            this.notifyAll();
        }
    }
}

